// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

class DivTooltip @DivModelInternalApi constructor (
    @JvmField val animationIn: DivAnimation? = null,
    @JvmField val animationOut: DivAnimation? = null,
    @JvmField val backgroundAccessibilityDescription: Expression<String>? = null,
    @JvmField val closeByTapOutside: Expression<Boolean> = CLOSE_BY_TAP_OUTSIDE_DEFAULT_VALUE, // default value: true
    @JvmField val div: Div,
    @JvmField val duration: Expression<Long> = DURATION_DEFAULT_VALUE, // constraint: number >= 0; default value: 5000
    @JvmField val id: String,
    @JvmField val mode: DivTooltipMode = MODE_DEFAULT_VALUE, // default value: DivTooltipMode.Modal(DivTooltipModeModal())
    @JvmField val offset: DivPoint? = null,
    @JvmField val position: Expression<Position>,
    @JvmField val tapOutsideActions: List<DivAction>? = null,
) : JSONSerializable, Hashable {

    private var _hash: Int? = null 

    override fun hash(): Int {
        _hash?.let {
            return it
        }
        val hash = 
            this::class.hashCode() +
            (animationIn?.hash() ?: 0) +
            (animationOut?.hash() ?: 0) +
            (backgroundAccessibilityDescription?.hashCode() ?: 0) +
            closeByTapOutside.hashCode() +
            div.hash() +
            duration.hashCode() +
            id.hashCode() +
            mode.hash() +
            (offset?.hash() ?: 0) +
            position.hashCode() +
            (tapOutsideActions?.sumOf { it.hash() } ?: 0)
        _hash = hash
        return hash
    }

    fun equals(other: DivTooltip?, resolver: ExpressionResolver, otherResolver: ExpressionResolver): Boolean {
        other ?: return false
        return (animationIn?.equals(other.animationIn, resolver, otherResolver) ?: (other.animationIn == null)) &&
            (animationOut?.equals(other.animationOut, resolver, otherResolver) ?: (other.animationOut == null)) &&
            backgroundAccessibilityDescription?.evaluate(resolver) == other.backgroundAccessibilityDescription?.evaluate(otherResolver) &&
            closeByTapOutside.evaluate(resolver) == other.closeByTapOutside.evaluate(otherResolver) &&
            div.equals(other.div, resolver, otherResolver) &&
            duration.evaluate(resolver) == other.duration.evaluate(otherResolver) &&
            id == other.id &&
            mode.equals(other.mode, resolver, otherResolver) &&
            (offset?.equals(other.offset, resolver, otherResolver) ?: (other.offset == null)) &&
            position.evaluate(resolver) == other.position.evaluate(otherResolver) &&
            (tapOutsideActions?.compareWith(other.tapOutsideActions ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.tapOutsideActions == null))
    }

    fun copy(
        animationIn: DivAnimation? = this.animationIn,
        animationOut: DivAnimation? = this.animationOut,
        backgroundAccessibilityDescription: Expression<String>? = this.backgroundAccessibilityDescription,
        closeByTapOutside: Expression<Boolean> = this.closeByTapOutside,
        div: Div = this.div,
        duration: Expression<Long> = this.duration,
        id: String = this.id,
        mode: DivTooltipMode = this.mode,
        offset: DivPoint? = this.offset,
        position: Expression<Position> = this.position,
        tapOutsideActions: List<DivAction>? = this.tapOutsideActions,
    ) = DivTooltip(
        animationIn = animationIn,
        animationOut = animationOut,
        backgroundAccessibilityDescription = backgroundAccessibilityDescription,
        closeByTapOutside = closeByTapOutside,
        div = div,
        duration = duration,
        id = id,
        mode = mode,
        offset = offset,
        position = position,
        tapOutsideActions = tapOutsideActions,
    )

    override fun writeToJSON(): JSONObject {
        return builtInParserComponent.divTooltipJsonEntityParser
            .value
            .serialize(context = builtInParsingContext, value = this)
    }

    companion object {
        private val CLOSE_BY_TAP_OUTSIDE_DEFAULT_VALUE = Expression.constant(true)
        private val DURATION_DEFAULT_VALUE = Expression.constant(5000L)
        private val MODE_DEFAULT_VALUE = DivTooltipMode.Modal(DivTooltipModeModal())

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivTooltip {
            return builtInParserComponent.divTooltipJsonEntityParser
                .value
                .deserialize(context = env, data = json)
        }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivTooltip(env, json = it) }
    }

    enum class Position(private val value: String) {
        LEFT("left"),
        TOP_LEFT("top-left"),
        TOP("top"),
        TOP_RIGHT("top-right"),
        RIGHT("right"),
        BOTTOM_RIGHT("bottom-right"),
        BOTTOM("bottom"),
        BOTTOM_LEFT("bottom-left"),
        CENTER("center");

        companion object Converter {

            fun toString(obj: Position): String {
                return obj.value
            }

            fun fromString(value: String): Position? {
                return when (value) {
                    LEFT.value -> LEFT
                    TOP_LEFT.value -> TOP_LEFT
                    TOP.value -> TOP
                    TOP_RIGHT.value -> TOP_RIGHT
                    RIGHT.value -> RIGHT
                    BOTTOM_RIGHT.value -> BOTTOM_RIGHT
                    BOTTOM.value -> BOTTOM
                    BOTTOM_LEFT.value -> BOTTOM_LEFT
                    CENTER.value -> CENTER
                    else -> null
                }
            }

            @JvmField
            val TO_STRING = { value: Position -> toString(value) }

            @JvmField
            val FROM_STRING = { value: String -> fromString(value) }
        }
    }
}
