/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.storage;

import android.os.SystemClock;
import androidx.annotation.AnyThread;
import com.yandex.div.data.DivParsingEnvironment;
import com.yandex.div.internal.util.UiThreadHandler;
import com.yandex.div.json.ParsingEnvironment;
import com.yandex.div.json.ParsingException;
import com.yandex.div.storage.DivDataRepository;
import com.yandex.div.storage.DivDataRepositoryException;
import com.yandex.div.storage.DivDataRepositoryRemoveResult;
import com.yandex.div.storage.DivDataRepositoryResult;
import com.yandex.div.storage.DivStorage;
import com.yandex.div.storage.RawDataAndMetadata;
import com.yandex.div.storage.analytics.CardErrorLoggerFactory;
import com.yandex.div.storage.database.StorageException;
import com.yandex.div.storage.histogram.HistogramNameProvider;
import com.yandex.div.storage.histogram.HistogramRecorder;
import com.yandex.div.storage.templates.DivParsingHistogramProxy;
import com.yandex.div.storage.templates.Template;
import com.yandex.div.storage.templates.TemplatesContainer;
import com.yandex.div2.DivData;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001a\u001a\u00020\u0014H\u0002J\u0016\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u0015H\u0017J\b\u0010\u001e\u001a\u00020\u001cH\u0017J$\u0010\u001f\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00140 H\u0002J \u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0014H\u0002J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020+H\u0017J\u001c\u0010,\u001a\u00020-2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u00110/H\u0017J\u0016\u00101\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00140 H\u0002J\u0018\u00104\u001a\u00020%*\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020%0\u0013H\u0002J2\u00105\u001a\u000e\u0012\u0004\u0012\u0002H6\u0012\u0004\u0012\u0002H70\u0013\"\u0004\b\u0000\u00106\"\u0004\b\u0001\u00107*\u0010\u0012\u0006\u0012\u0004\u0018\u0001H6\u0012\u0004\u0012\u0002H70\u0013H\u0002J&\u00108\u001a\u00020'*\u00020'2\u0006\u0010(\u001a\u00020\u00142\u0006\u00109\u001a\u00020\u00142\b\u0010:\u001a\u0004\u0018\u00010%H\u0002J\u0018\u0010;\u001a\b\u0012\u0004\u0012\u00020<0\u0015*\b\u0012\u0004\u0012\u00020=0\u0015H\u0002R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/yandex/div/storage/DivDataRepositoryImpl;", "Lcom/yandex/div/storage/DivDataRepository;", "divStorage", "Lcom/yandex/div/storage/DivStorage;", "templateContainer", "Lcom/yandex/div/storage/templates/TemplatesContainer;", "histogramRecorder", "Lcom/yandex/div/storage/histogram/HistogramRecorder;", "histogramNameProvider", "Lcom/yandex/div/storage/histogram/HistogramNameProvider;", "divParsingHistogramProxy", "Ljavax/inject/Provider;", "Lcom/yandex/div/storage/templates/DivParsingHistogramProxy;", "cardErrorFactory", "Lcom/yandex/div/storage/analytics/CardErrorLoggerFactory;", "(Lcom/yandex/div/storage/DivStorage;Lcom/yandex/div/storage/templates/TemplatesContainer;Lcom/yandex/div/storage/histogram/HistogramRecorder;Lcom/yandex/div/storage/histogram/HistogramNameProvider;Ljavax/inject/Provider;Lcom/yandex/div/storage/analytics/CardErrorLoggerFactory;)V", "areCardsSynchronizedWithInMemory", "", "cardsWithErrors", "", "", "", "Lcom/yandex/div/storage/DivDataRepositoryException;", "inMemoryData", "", "Lcom/yandex/div/storage/DivDataRepository$DivDataWithMeta;", "generateUniqueId", "get", "Lcom/yandex/div/storage/DivDataRepositoryResult;", "ids", "getAll", "loadFromStorage", "", "idsToExclude", "parseRawDivData", "Lcom/yandex/div2/DivData;", "rawDivData", "Lorg/json/JSONObject;", "parsingEnvironment", "Lcom/yandex/div/data/DivParsingEnvironment;", "cardId", "put", "payload", "Lcom/yandex/div/storage/DivDataRepository$Payload;", "remove", "Lcom/yandex/div/storage/DivDataRepositoryRemoveResult;", "predicate", "Lkotlin/Function1;", "Lcom/yandex/div/storage/RawDataAndMetadata;", "removeFromInMemory", "", "deletedRecords", "asJSONObject", "filterKeysNotNull", "K", "V", "includeCardContext", "groupId", "metadata", "toDivDataRepositoryExceptions", "Lcom/yandex/div/storage/DivDataRepositoryException$StorageException;", "Lcom/yandex/div/storage/database/StorageException;", "div-storage_release"})
@SourceDebugExtension(value={"SMAP\nDivDataRepositoryImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DivDataRepositoryImpl.kt\ncom/yandex/div/storage/DivDataRepositoryImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,251:1\n1855#2,2:252\n1855#2,2:254\n1855#2,2:256\n1477#2:258\n1502#2,3:259\n1505#2,3:269\n1855#2,2:272\n1855#2,2:274\n1194#2,2:276\n1222#2,4:278\n1855#2,2:282\n1855#2,2:284\n1855#2,2:286\n1549#2:290\n1620#2,3:291\n361#3,7:262\n215#4,2:288\n*S KotlinDebug\n*F\n+ 1 DivDataRepositoryImpl.kt\ncom/yandex/div/storage/DivDataRepositoryImpl\n*L\n52#1:252,2\n80#1:254,2\n129#1:256,2\n132#1:258\n132#1:259,3\n132#1:269,3\n155#1:272,2\n164#1:274,2\n174#1:276,2\n174#1:278,4\n176#1:282,2\n183#1:284,2\n222#1:286,2\n249#1:290\n249#1:291,3\n132#1:262,7\n242#1:288,2\n*E\n"})
public final class DivDataRepositoryImpl
implements DivDataRepository {
    @NotNull
    private final DivStorage divStorage;
    @NotNull
    private final TemplatesContainer templateContainer;
    @NotNull
    private final HistogramRecorder histogramRecorder;
    @Nullable
    private final HistogramNameProvider histogramNameProvider;
    @NotNull
    private final Provider<DivParsingHistogramProxy> divParsingHistogramProxy;
    @NotNull
    private final CardErrorLoggerFactory cardErrorFactory;
    @NotNull
    private final Map<String, DivDataRepository.DivDataWithMeta> inMemoryData;
    private boolean areCardsSynchronizedWithInMemory;
    @NotNull
    private Map<String, ? extends List<? extends DivDataRepositoryException>> cardsWithErrors;

    public DivDataRepositoryImpl(@NotNull DivStorage divStorage, @NotNull TemplatesContainer templateContainer, @NotNull HistogramRecorder histogramRecorder, @Nullable HistogramNameProvider histogramNameProvider, @NotNull Provider<DivParsingHistogramProxy> divParsingHistogramProxy, @NotNull CardErrorLoggerFactory cardErrorFactory) {
        Intrinsics.checkNotNullParameter((Object)divStorage, (String)"divStorage");
        Intrinsics.checkNotNullParameter((Object)templateContainer, (String)"templateContainer");
        Intrinsics.checkNotNullParameter((Object)histogramRecorder, (String)"histogramRecorder");
        Intrinsics.checkNotNullParameter(divParsingHistogramProxy, (String)"divParsingHistogramProxy");
        Intrinsics.checkNotNullParameter((Object)cardErrorFactory, (String)"cardErrorFactory");
        this.divStorage = divStorage;
        this.templateContainer = templateContainer;
        this.histogramRecorder = histogramRecorder;
        this.histogramNameProvider = histogramNameProvider;
        this.divParsingHistogramProxy = divParsingHistogramProxy;
        this.cardErrorFactory = cardErrorFactory;
        this.inMemoryData = new LinkedHashMap();
        this.cardsWithErrors = MapsKt.emptyMap();
    }

    @Override
    @AnyThread
    @NotNull
    public DivDataRepositoryResult put(@NotNull DivDataRepository.Payload payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        List exceptions = new ArrayList();
        String groupId = this.generateUniqueId();
        List<Template> hashedTemplates = !payload.getTemplates().isEmpty() ? this.templateContainer.addTemplates(groupId, this.asJSONObject(payload.getTemplates()), payload.getSourceType()) : CollectionsKt.emptyList();
        long parseStarted = SystemClock.uptimeMillis();
        ArrayList<DivDataRepository.DivDataWithMeta> results = new ArrayList<DivDataRepository.DivDataWithMeta>(payload.getDivs().size());
        ArrayList<RawDataAndMetadata> validPayload = new ArrayList<RawDataAndMetadata>(payload.getDivs().size());
        Iterable $this$forEach$iv = payload.getDivs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DivData divData2;
            RawDataAndMetadata rawData = (RawDataAndMetadata)element$iv;
            boolean bl = false;
            DivParsingEnvironment parsingEnvironment = this.includeCardContext(this.templateContainer.getEnvironment(groupId), rawData.getId(), groupId, rawData.getMetadata());
            try {
                divData2 = this.parseRawDivData(rawData.getDivData(), parsingEnvironment, rawData.getId());
            }
            catch (ParsingException e) {
                parsingEnvironment.getLogger().logError((Exception)((Object)e));
                exceptions.add(new DivDataRepositoryException.JsonParsingException("Error parsing DivData", e, rawData.getId()));
                continue;
            }
            DivData divData3 = divData2;
            validPayload.add(rawData);
            results.add(new DivDataRepository.DivDataWithMeta(rawData.getId(), divData3, rawData.getMetadata()));
        }
        if (UiThreadHandler.isMainThread()) {
            HistogramRecorder.reportDivDataLoadTime$default(this.histogramRecorder, SystemClock.uptimeMillis() - parseStarted, null, 2, null);
        }
        $this$forEach$iv = results;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DivDataRepository.DivDataWithMeta it = (DivDataRepository.DivDataWithMeta)element$iv;
            boolean bl = false;
            this.inMemoryData.put(it.getId(), it);
        }
        DivDataRepository.Payload validStoragePayload = validPayload.size() == payload.getDivs().size() ? payload : DivDataRepository.Payload.copy$default(payload, validPayload, null, null, null, 14, null);
        List<StorageException> divStorageErrors = this.divStorage.saveData(groupId, validStoragePayload.getDivs(), hashedTemplates, payload.getActionOnError()).getErrors();
        exceptions.addAll((Collection)this.toDivDataRepositoryExceptions(divStorageErrors));
        return new DivDataRepositoryResult((List<DivDataRepository.DivDataWithMeta>)results, exceptions);
    }

    private final String generateUniqueId() {
        String string = Calendar.getInstance().getTime().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInstance().time.toString()");
        String time = string;
        int salt = new Object().hashCode();
        return "group-" + time + '-' + salt;
    }

    private final DivParsingEnvironment includeCardContext(DivParsingEnvironment $this$includeCardContext, String cardId, String groupId, JSONObject metadata2) {
        return new DivParsingEnvironment(this.cardErrorFactory.createContextualLogger($this$includeCardContext.getLogger(), cardId, groupId, metadata2), $this$includeCardContext.getTemplates());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @AnyThread
    @NotNull
    public DivDataRepositoryResult getAll() {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        if (this.areCardsSynchronizedWithInMemory && this.cardsWithErrors.isEmpty()) {
            return new DivDataRepositoryResult(CollectionsKt.toList((Iterable)this.inMemoryData.values()), CollectionsKt.emptyList());
        }
        Pair pair = this.areCardsSynchronizedWithInMemory ? TuplesKt.to(this.cardsWithErrors.keySet(), (Object)SetsKt.emptySet()) : TuplesKt.to((Object)SetsKt.emptySet(), (Object)SetsKt.minus(this.inMemoryData.keySet(), (Iterable)this.cardsWithErrors.keySet()));
        Set cardsToRequest = (Set)pair.component1();
        Set cardsToExclude = (Set)pair.component2();
        DivDataRepositoryResult storageResults = this.loadFromStorage(cardsToRequest, cardsToExclude);
        DivDataRepositoryResult resultsWithInMemory = storageResults.addData(this.inMemoryData.values());
        Iterable $this$forEach$iv = storageResults.getResultData();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DivDataRepository.DivDataWithMeta it = (DivDataRepository.DivDataWithMeta)element$iv;
            boolean bl = false;
            this.inMemoryData.put(it.getId(), it);
        }
        this.areCardsSynchronizedWithInMemory = true;
        $this$forEach$iv = storageResults.getErrors();
        DivDataRepositoryImpl divDataRepositoryImpl = this;
        DivDataRepositoryImpl divDataRepositoryImpl2 = this;
        boolean $i$f$groupBy = false;
        Iterator iterator = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            DivDataRepositoryException it = (DivDataRepositoryException)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getCardId();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map map = destination$iv$iv;
        divDataRepositoryImpl2.cardsWithErrors = divDataRepositoryImpl.filterKeysNotNull(map);
        return resultsWithInMemory;
    }

    private final <K, V> Map<K, V> filterKeysNotNull(Map<K, ? extends V> $this$filterKeysNotNull) {
        LinkedHashMap newMap = new LinkedHashMap($this$filterKeysNotNull.size());
        for (Map.Entry<K, V> entry : $this$filterKeysNotNull.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            if (key == null) continue;
            ((Map)newMap).put(key, value);
        }
        return newMap;
    }

    @Override
    @AnyThread
    @NotNull
    public DivDataRepositoryResult get(@NotNull List<String> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        if (ids.isEmpty()) {
            return DivDataRepositoryResult.Companion.getEMPTY();
        }
        Set idsToLoad = CollectionsKt.toMutableSet((Iterable)ids);
        ArrayList<DivDataRepository.DivDataWithMeta> inMemoryResults = new ArrayList<DivDataRepository.DivDataWithMeta>(ids.size());
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DivDataRepository.DivDataWithMeta it;
            String id = (String)element$iv;
            boolean bl = false;
            if (this.inMemoryData.get(id) == null) continue;
            boolean bl2 = false;
            inMemoryResults.add(it);
            idsToLoad.remove(id);
        }
        if (!((Collection)idsToLoad).isEmpty()) {
            DivDataRepositoryResult storageResults = this.loadFromStorage(idsToLoad, SetsKt.emptySet());
            Iterable $this$forEach$iv2 = storageResults.getResultData();
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                DivDataRepository.DivDataWithMeta it = (DivDataRepository.DivDataWithMeta)element$iv;
                boolean bl = false;
                this.inMemoryData.put(it.getId(), it);
            }
            return storageResults.addData((Collection<DivDataRepository.DivDataWithMeta>)inMemoryResults);
        }
        return new DivDataRepositoryResult((List<DivDataRepository.DivDataWithMeta>)inMemoryResults, CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    private final DivDataRepositoryResult loadFromStorage(Set<String> ids, Set<String> idsToExclude) {
        void $this$associateByTo$iv$iv;
        List exceptions = new ArrayList();
        DivStorage.LoadDataResult<DivStorage.RestoredRawData> loadDataResult = this.divStorage.loadData(CollectionsKt.toList((Iterable)ids), CollectionsKt.toList((Iterable)idsToExclude));
        List<DivStorage.RestoredRawData> rawData = loadDataResult.component1();
        List<StorageException> errors = loadDataResult.component2();
        exceptions.addAll((Collection)this.toDivDataRepositoryExceptions(errors));
        Iterable $this$associateBy$iv = rawData;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            DivStorage.RestoredRawData restoredRawData = (DivStorage.RestoredRawData)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getGroupId$div_storage_release(), element$iv$iv);
        }
        Map dataByGroups = destination$iv$iv;
        Iterable $this$forEach$iv = dataByGroups.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String groupId = (String)element$iv;
            boolean bl = false;
            this.templateContainer.getEnvironment(groupId);
        }
        long parseStarted = SystemClock.uptimeMillis();
        ArrayList<DivDataRepository.DivDataWithMeta> results = new ArrayList<DivDataRepository.DivDataWithMeta>(ids.size());
        Iterable $this$forEach$iv2 = rawData;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            DivData divData2;
            DivStorage.RestoredRawData it = (DivStorage.RestoredRawData)element$iv;
            boolean bl = false;
            DivParsingEnvironment parsingEnvironment = this.includeCardContext(this.templateContainer.getEnvironment(it.getGroupId$div_storage_release()), it.getId(), it.getGroupId$div_storage_release(), it.getMetadata());
            try {
                divData2 = this.parseRawDivData(it.getDivData(), parsingEnvironment, it.getId());
            }
            catch (ParsingException e) {
                parsingEnvironment.getLogger().logError((Exception)((Object)e));
                exceptions.add(new DivDataRepositoryException.JsonParsingException("Error parsing DivData", e, it.getId()));
                continue;
            }
            DivData divData3 = divData2;
            results.add(new DivDataRepository.DivDataWithMeta(it.getId(), divData3, it.getMetadata()));
        }
        HistogramRecorder.reportDivDataLoadTime$default(this.histogramRecorder, SystemClock.uptimeMillis() - parseStarted, null, 2, null);
        return new DivDataRepositoryResult((List<DivDataRepository.DivDataWithMeta>)results, exceptions);
    }

    @Override
    @AnyThread
    @NotNull
    public DivDataRepositoryRemoveResult remove(@NotNull Function1<? super RawDataAndMetadata, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        DivStorage.RemoveResult removeResult = this.divStorage.remove(predicate);
        Set<String> deletedIds = removeResult.component1();
        List<StorageException> storageErrors = removeResult.component2();
        List<DivDataRepositoryException.StorageException> exceptions = this.toDivDataRepositoryExceptions(storageErrors);
        this.removeFromInMemory(deletedIds);
        return new DivDataRepositoryRemoveResult(deletedIds, exceptions);
    }

    private final void removeFromInMemory(Set<String> deletedRecords) {
        Iterable $this$forEach$iv = deletedRecords;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.inMemoryData.remove(it);
        }
    }

    private final DivData parseRawDivData(JSONObject rawDivData, DivParsingEnvironment parsingEnvironment, String cardId) throws ParsingException {
        HistogramNameProvider histogramNameProvider = this.histogramNameProvider;
        String componentName = histogramNameProvider != null ? histogramNameProvider.getHistogramNameFromCardId(cardId) : null;
        return ((DivParsingHistogramProxy)this.divParsingHistogramProxy.get()).createDivData((ParsingEnvironment)parsingEnvironment, rawDivData, componentName);
    }

    private final JSONObject asJSONObject(Map<String, ? extends JSONObject> $this$asJSONObject) {
        JSONObject result = new JSONObject();
        Map<String, ? extends JSONObject> $this$forEach$iv = $this$asJSONObject;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends JSONObject>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends JSONObject> element$iv;
            Map.Entry<String, ? extends JSONObject> entry = element$iv = iterator.next();
            boolean bl = false;
            String id = entry.getKey();
            JSONObject template = entry.getValue();
            result.put(id, (Object)template);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DivDataRepositoryException.StorageException> toDivDataRepositoryExceptions(List<? extends StorageException> $this$toDivDataRepositoryExceptions) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toDivDataRepositoryExceptions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            StorageException storageException = (StorageException)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DivDataRepositoryException.StorageException((StorageException)p0));
        }
        return (List)destination$iv$iv;
    }
}

