/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.storage.database;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import androidx.annotation.VisibleForTesting;
import com.yandex.div.internal.Assert;
import com.yandex.div.storage.database.DatabaseOpenHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0010\u0018\u00002\u00020\u0001:\u0003\"#$B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0013H\u0012J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u0013H\u0017R\u000e\u0010\u000f\u001a\u00020\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001c\u00a8\u0006%"}, d2={"Lcom/yandex/div/storage/database/AndroidDatabaseOpenHelper;", "Lcom/yandex/div/storage/database/DatabaseOpenHelper;", "context", "Landroid/content/Context;", "name", "", "version", "", "ccb", "Lcom/yandex/div/storage/database/DatabaseOpenHelper$CreateCallback;", "ucb", "Lcom/yandex/div/storage/database/DatabaseOpenHelper$UpgradeCallback;", "useDatabaseManager", "", "(Landroid/content/Context;Ljava/lang/String;ILcom/yandex/div/storage/database/DatabaseOpenHelper$CreateCallback;Lcom/yandex/div/storage/database/DatabaseOpenHelper$UpgradeCallback;Z)V", "databaseManager", "Lcom/yandex/div/storage/database/AndroidDatabaseOpenHelper$DatabaseManager;", "mOpenCloseInfoMap", "", "Landroid/database/sqlite/SQLiteDatabase;", "Lcom/yandex/div/storage/database/AndroidDatabaseOpenHelper$OpenCloseInfo;", "mOpenCloseLock", "", "mSQLiteOpenHelper", "Landroid/database/sqlite/SQLiteOpenHelper;", "readableDatabase", "Lcom/yandex/div/storage/database/DatabaseOpenHelper$Database;", "getReadableDatabase", "()Lcom/yandex/div/storage/database/DatabaseOpenHelper$Database;", "writableDatabase", "getWritableDatabase", "getOpenCloseInfo", "sqLiteDatabase", "wrapDataBase", "AndroidSQLiteDatabase", "DatabaseManager", "OpenCloseInfo", "div-storage_release"})
public class AndroidDatabaseOpenHelper
implements DatabaseOpenHelper {
    private final boolean useDatabaseManager;
    @NotNull
    private final SQLiteOpenHelper mSQLiteOpenHelper;
    @NotNull
    private final DatabaseManager databaseManager;
    @NotNull
    private final Object mOpenCloseLock;
    @NotNull
    private final Map<SQLiteDatabase, OpenCloseInfo> mOpenCloseInfoMap;

    public AndroidDatabaseOpenHelper(@NotNull Context context, @NotNull String name, int version, final @NotNull DatabaseOpenHelper.CreateCallback ccb, final @NotNull DatabaseOpenHelper.UpgradeCallback ucb, boolean useDatabaseManager) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)ccb, (String)"ccb");
        Intrinsics.checkNotNullParameter((Object)ucb, (String)"ucb");
        this.useDatabaseManager = useDatabaseManager;
        this.mOpenCloseLock = new Object();
        this.mOpenCloseInfoMap = new HashMap();
        this.mSQLiteOpenHelper = new SQLiteOpenHelper(context, name, version){

            public void onCreate(@NotNull SQLiteDatabase sqLiteDatabase) {
                Intrinsics.checkNotNullParameter((Object)sqLiteDatabase, (String)"sqLiteDatabase");
                ccb.onCreate(this.wrapDataBase(sqLiteDatabase));
            }

            public void onUpgrade(@NotNull SQLiteDatabase sqLiteDatabase, int oldVersion, int newVersion) {
                Intrinsics.checkNotNullParameter((Object)sqLiteDatabase, (String)"sqLiteDatabase");
                ucb.onUpgrade(this.wrapDataBase(sqLiteDatabase), oldVersion, newVersion);
            }

            public void onConfigure(@NotNull SQLiteDatabase db) {
                Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                db.setForeignKeyConstraintsEnabled(true);
            }
        };
        this.databaseManager = new DatabaseManager(this.mSQLiteOpenHelper);
    }

    public /* synthetic */ AndroidDatabaseOpenHelper(Context context, String string, int n, DatabaseOpenHelper.CreateCallback createCallback, DatabaseOpenHelper.UpgradeCallback upgradeCallback, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            bl = true;
        }
        this(context, string, n, createCallback, upgradeCallback, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public DatabaseOpenHelper.Database getReadableDatabase() {
        DatabaseOpenHelper.Database database2;
        if (this.useDatabaseManager) {
            database2 = this.wrapDataBase(this.databaseManager.openReadableDatabase());
        } else {
            Object object = this.mOpenCloseLock;
            synchronized (object) {
                boolean bl = false;
                SQLiteDatabase sQLiteDatabase = this.mSQLiteOpenHelper.getReadableDatabase();
                Intrinsics.checkNotNullExpressionValue((Object)sQLiteDatabase, (String)"mSQLiteOpenHelper.readableDatabase");
                DatabaseOpenHelper.Database database3 = this.wrapDataBase(sQLiteDatabase);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl12 : MonitorExitStatement: MONITOREXIT : var1_1
                database2 = database3;
            }
        }
        return database2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public DatabaseOpenHelper.Database getWritableDatabase() {
        DatabaseOpenHelper.Database database2;
        if (this.useDatabaseManager) {
            database2 = this.wrapDataBase(this.databaseManager.openWritableDatabase());
        } else {
            Object object = this.mOpenCloseLock;
            synchronized (object) {
                boolean bl = false;
                SQLiteDatabase sQLiteDatabase = this.mSQLiteOpenHelper.getWritableDatabase();
                Intrinsics.checkNotNullExpressionValue((Object)sQLiteDatabase, (String)"mSQLiteOpenHelper.writableDatabase");
                DatabaseOpenHelper.Database database3 = this.wrapDataBase(sQLiteDatabase);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl12 : MonitorExitStatement: MONITOREXIT : var1_1
                database2 = database3;
            }
        }
        return database2;
    }

    @VisibleForTesting
    @NotNull
    public DatabaseOpenHelper.Database wrapDataBase(@NotNull SQLiteDatabase sqLiteDatabase) {
        Intrinsics.checkNotNullParameter((Object)sqLiteDatabase, (String)"sqLiteDatabase");
        return new AndroidSQLiteDatabase(sqLiteDatabase, this.getOpenCloseInfo(sqLiteDatabase));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OpenCloseInfo getOpenCloseInfo(SQLiteDatabase sqLiteDatabase) {
        Object object = this.mOpenCloseLock;
        synchronized (object) {
            boolean bl = false;
            OpenCloseInfo info = this.mOpenCloseInfoMap.get(sqLiteDatabase);
            if (info == null) {
                info = new OpenCloseInfo();
                this.mOpenCloseInfoMap.put(sqLiteDatabase, info);
            }
            OpenCloseInfo openCloseInfo = info;
            openCloseInfo.setCurrentlyOpenedCount(openCloseInfo.getCurrentlyOpenedCount() + 1);
            openCloseInfo.getCurrentlyOpenedCount();
            OpenCloseInfo openCloseInfo2 = info;
            return openCloseInfo2;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u000b\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016Jk\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0010\u0010\u0013\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0010\u0010\u0016\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u001bJ)\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\r2\u0012\u0010\u0016\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\r\u0018\u00010\u0014H\u0016\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/yandex/div/storage/database/AndroidDatabaseOpenHelper$AndroidSQLiteDatabase;", "Lcom/yandex/div/storage/database/DatabaseOpenHelper$Database;", "mDb", "Landroid/database/sqlite/SQLiteDatabase;", "mOpenCloseInfo", "Lcom/yandex/div/storage/database/AndroidDatabaseOpenHelper$OpenCloseInfo;", "(Lcom/yandex/div/storage/database/AndroidDatabaseOpenHelper;Landroid/database/sqlite/SQLiteDatabase;Lcom/yandex/div/storage/database/AndroidDatabaseOpenHelper$OpenCloseInfo;)V", "beginTransaction", "", "close", "compileStatement", "Landroid/database/sqlite/SQLiteStatement;", "sql", "", "endTransaction", "execSQL", "query", "Landroid/database/Cursor;", "table", "columns", "", "selection", "selectionArgs", "groupBy", "having", "orderBy", "limit", "(Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Landroid/database/Cursor;", "rawQuery", "(Ljava/lang/String;[Ljava/lang/String;)Landroid/database/Cursor;", "setTransactionSuccessful", "div-storage_release"})
    private final class AndroidSQLiteDatabase
    implements DatabaseOpenHelper.Database {
        @NotNull
        private final SQLiteDatabase mDb;
        @NotNull
        private final OpenCloseInfo mOpenCloseInfo;

        public AndroidSQLiteDatabase(@NotNull SQLiteDatabase mDb, OpenCloseInfo mOpenCloseInfo) {
            Intrinsics.checkNotNullParameter((Object)mDb, (String)"mDb");
            Intrinsics.checkNotNullParameter((Object)mOpenCloseInfo, (String)"mOpenCloseInfo");
            this.mDb = mDb;
            this.mOpenCloseInfo = mOpenCloseInfo;
        }

        @Override
        public void execSQL(@NotNull String sql) {
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            this.mDb.execSQL(sql);
        }

        @Override
        @NotNull
        public Cursor query(@NotNull String table, @Nullable String[] columns, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy, @Nullable String limit) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Cursor cursor = this.mDb.query(table, columns, selection, selectionArgs, groupBy, having, orderBy, limit);
            Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"mDb.query(table, columns\u2026, having, orderBy, limit)");
            return cursor;
        }

        @Override
        @NotNull
        public Cursor rawQuery(@NotNull String query, @Nullable String[] selectionArgs) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Cursor cursor = this.mDb.rawQuery(query, selectionArgs);
            Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"mDb.rawQuery(query, selectionArgs)");
            return cursor;
        }

        @Override
        public void beginTransaction() {
            this.mDb.beginTransaction();
        }

        @Override
        public void setTransactionSuccessful() {
            this.mDb.setTransactionSuccessful();
        }

        @Override
        public void endTransaction() {
            this.mDb.endTransaction();
        }

        @Override
        @NotNull
        public SQLiteStatement compileStatement(@NotNull String sql) {
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            SQLiteStatement sQLiteStatement = this.mDb.compileStatement(sql);
            Intrinsics.checkNotNullExpressionValue((Object)sQLiteStatement, (String)"mDb.compileStatement(sql)");
            return sQLiteStatement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (AndroidDatabaseOpenHelper.this.useDatabaseManager) {
                AndroidDatabaseOpenHelper.this.databaseManager.closeDatabase(this.mDb);
                return;
            }
            Object object = AndroidDatabaseOpenHelper.this.mOpenCloseLock;
            AndroidDatabaseOpenHelper androidDatabaseOpenHelper = AndroidDatabaseOpenHelper.this;
            Object object2 = object;
            synchronized (object2) {
                Object object3;
                boolean bl = false;
                OpenCloseInfo openCloseInfo = this.mOpenCloseInfo;
                openCloseInfo.setCurrentlyOpenedCount(openCloseInfo.getCurrentlyOpenedCount() + -1);
                if (openCloseInfo.getCurrentlyOpenedCount() > 0) {
                    openCloseInfo = this.mOpenCloseInfo;
                    openCloseInfo.setPostponedCloseCount(openCloseInfo.getPostponedCloseCount() + 1);
                    object3 = openCloseInfo.getPostponedCloseCount();
                } else {
                    androidDatabaseOpenHelper.mOpenCloseInfoMap.remove(this.mDb);
                    while (this.mOpenCloseInfo.getPostponedCloseCount() > 0) {
                        this.mDb.close();
                        openCloseInfo = this.mOpenCloseInfo;
                        openCloseInfo.setPostponedCloseCount(openCloseInfo.getPostponedCloseCount() + -1);
                        openCloseInfo.getPostponedCloseCount();
                    }
                    object3 = Unit.INSTANCE;
                }
                Object object4 = object3;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006J\u0006\u0010\u0012\u001a\u00020\u0006J\u0006\u0010\u0013\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/yandex/div/storage/database/AndroidDatabaseOpenHelper$DatabaseManager;", "", "databaseHelper", "Landroid/database/sqlite/SQLiteOpenHelper;", "(Landroid/database/sqlite/SQLiteOpenHelper;)V", "readableDatabase", "Landroid/database/sqlite/SQLiteDatabase;", "readableUsers", "", "Ljava/lang/Thread;", "readableUsersCount", "", "writableDatabase", "writableUsers", "writableUsersCount", "closeDatabase", "", "mDb", "openReadableDatabase", "openWritableDatabase", "div-storage_release"})
    private static final class DatabaseManager {
        @NotNull
        private final SQLiteOpenHelper databaseHelper;
        @NotNull
        private final Set<Thread> readableUsers;
        private int readableUsersCount;
        @Nullable
        private SQLiteDatabase readableDatabase;
        @NotNull
        private final Set<Thread> writableUsers;
        private int writableUsersCount;
        @Nullable
        private SQLiteDatabase writableDatabase;

        public DatabaseManager(@NotNull SQLiteOpenHelper databaseHelper) {
            Intrinsics.checkNotNullParameter((Object)databaseHelper, (String)"databaseHelper");
            this.databaseHelper = databaseHelper;
            this.readableUsers = new LinkedHashSet();
            this.writableUsers = new LinkedHashSet();
        }

        @NotNull
        public final synchronized SQLiteDatabase openWritableDatabase() {
            this.writableDatabase = this.databaseHelper.getWritableDatabase();
            int n = this.writableUsersCount;
            this.writableUsersCount = n + 1;
            Thread thread = Thread.currentThread();
            Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"currentThread()");
            this.writableUsers.add(thread);
            SQLiteDatabase sQLiteDatabase = this.writableDatabase;
            Intrinsics.checkNotNull((Object)sQLiteDatabase);
            return sQLiteDatabase;
        }

        @NotNull
        public final synchronized SQLiteDatabase openReadableDatabase() {
            this.readableDatabase = this.databaseHelper.getReadableDatabase();
            int n = this.readableUsersCount;
            this.readableUsersCount = n + 1;
            Thread thread = Thread.currentThread();
            Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"currentThread()");
            this.readableUsers.add(thread);
            SQLiteDatabase sQLiteDatabase = this.readableDatabase;
            Intrinsics.checkNotNull((Object)sQLiteDatabase);
            return sQLiteDatabase;
        }

        public final synchronized void closeDatabase(@NotNull SQLiteDatabase mDb) {
            Intrinsics.checkNotNullParameter((Object)mDb, (String)"mDb");
            if (Intrinsics.areEqual((Object)mDb, (Object)this.writableDatabase)) {
                this.writableUsers.remove(Thread.currentThread());
                if (this.writableUsers.isEmpty()) {
                    while (true) {
                        int n = this.writableUsersCount;
                        this.writableUsersCount = n + -1;
                        if (n > 0) {
                            SQLiteDatabase sQLiteDatabase = this.writableDatabase;
                            Intrinsics.checkNotNull((Object)sQLiteDatabase);
                            sQLiteDatabase.close();
                            continue;
                        }
                        break;
                    }
                }
            } else if (Intrinsics.areEqual((Object)mDb, (Object)this.readableDatabase)) {
                this.readableUsers.remove(Thread.currentThread());
                if (this.readableUsers.isEmpty()) {
                    while (true) {
                        int n = this.readableUsersCount;
                        this.readableUsersCount = n + -1;
                        if (n > 0) {
                            SQLiteDatabase sQLiteDatabase = this.readableDatabase;
                            Intrinsics.checkNotNull((Object)sQLiteDatabase);
                            sQLiteDatabase.close();
                            continue;
                        }
                        break;
                    }
                }
            } else {
                Assert.fail((String)"Trying to close unknown database from DatabaseManager");
                mDb.close();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Lcom/yandex/div/storage/database/AndroidDatabaseOpenHelper$OpenCloseInfo;", "", "()V", "currentlyOpenedCount", "", "getCurrentlyOpenedCount", "()I", "setCurrentlyOpenedCount", "(I)V", "postponedCloseCount", "getPostponedCloseCount", "setPostponedCloseCount", "div-storage_release"})
    private static final class OpenCloseInfo {
        private int currentlyOpenedCount;
        private int postponedCloseCount;

        public final int getCurrentlyOpenedCount() {
            return this.currentlyOpenedCount;
        }

        public final void setCurrentlyOpenedCount(int n) {
            this.currentlyOpenedCount = n;
        }

        public final int getPostponedCloseCount() {
            return this.postponedCloseCount;
        }

        public final void setPostponedCloseCount(int n) {
            this.postponedCloseCount = n;
        }
    }
}

