/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.storage.database;

import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteStatement;
import com.yandex.div.internal.Assert;
import com.yandex.div.internal.KAssert;
import com.yandex.div.storage.RawDataAndMetadata;
import com.yandex.div.storage.database.ReadState;
import com.yandex.div.storage.database.SqlCompiler;
import com.yandex.div.storage.database.StorageStatement;
import com.yandex.div.storage.database.StorageStatements;
import com.yandex.div.storage.rawjson.RawJson;
import com.yandex.div.storage.templates.Template;
import com.yandex.div.storage.util.SqlExtensionsKt;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002J\u0014\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fJ\u0014\u0010\u0010\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fJ\u0006\u0010\u0011\u001a\u00020\rJ\u0006\u0010\u0012\u001a\u00020\rJ9\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052!\u0010\u0016\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u001a0\tJ1\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u00052!\u0010\u0016\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u001a0\tJ)\u0010\u001d\u001a\u00020\r2!\u0010\u001e\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u001a0\tJ)\u0010 \u001a\u00020\r2!\u0010\u001e\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u001a0\tJ8\u0010!\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u001a\b\u0002\u0010%\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050#\u0012\u0004\u0012\u00020\u001a0\tJ0\u0010&\u001a\u00020\r2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0#2\u001a\b\u0002\u0010%\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050#\u0012\u0004\u0012\u00020\u001a0\tJ\u0014\u0010)\u001a\u00020\r2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0#J\u001c\u0010,\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00052\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0#J\u0018\u0010-\u001a\u00020\u0005\"\u0004\b\u0000\u0010.*\b\u0012\u0004\u0012\u0002H.0/H\u0002\u00a8\u00060"}, d2={"Lcom/yandex/div/storage/database/StorageStatements;", "", "()V", "captureTemplateIds", "", "", "readState", "Lcom/yandex/div/storage/database/ReadState;", "filter", "Lkotlin/Function1;", "Landroid/database/Cursor;", "", "deleteCardsAndTemplates", "Lcom/yandex/div/storage/database/StorageStatement;", "elementIds", "", "deleteRawJsons", "deleteTemplatesWithoutLinksToCards", "dropAllTables", "isCardExists", "cardId", "groupId", "result", "Lkotlin/ParameterName;", "name", "exists", "", "isTemplateExists", "templateHash", "readData", "reader", "r", "readRawJsons", "replaceCards", "cards", "", "Lcom/yandex/div/storage/RawDataAndMetadata;", "onFailedTransactions", "replaceRawJsons", "rawJsons", "Lcom/yandex/div/storage/rawjson/RawJson;", "writeTemplates", "templates", "Lcom/yandex/div/storage/templates/Template;", "writeTemplatesUsages", "asSqlList", "T", "", "div-storage_release"})
@SourceDebugExtension(value={"SMAP\nStorageStatements.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageStatements.kt\ncom/yandex/div/storage/database/StorageStatements\n+ 2 KAssert.kt\ncom/yandex/div/internal/KAssert\n*L\n1#1,269:1\n23#2,4:270\n*S KotlinDebug\n*F\n+ 1 StorageStatements.kt\ncom/yandex/div/storage/database/StorageStatements\n*L\n32#1:270,4\n*E\n"})
public final class StorageStatements {
    @NotNull
    public static final StorageStatements INSTANCE = new StorageStatements();

    private StorageStatements() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<String> captureTemplateIds(ReadState readState2, Function1<? super Cursor, Boolean> filter) {
        List usedTemplates = new ArrayList();
        Closeable closeable = readState2;
        Throwable throwable = null;
        try {
            ReadState it = (ReadState)closeable;
            boolean bl = false;
            Cursor cursor = it.getCursor();
            if (!cursor.moveToFirst()) {
                List list = usedTemplates;
                return list;
            }
            do {
                if (!((Boolean)filter.invoke((Object)cursor)).booleanValue()) continue;
                try {
                    String templateId = cursor.getString(cursor.getColumnIndex("template_id"));
                    Intrinsics.checkNotNullExpressionValue((Object)templateId, (String)"templateId");
                    usedTemplates.add(templateId);
                }
                catch (SQLException e) {
                    KAssert this_$iv = KAssert.INSTANCE;
                    boolean $i$f$fail = false;
                    if (!Assert.isEnabled()) continue;
                    boolean bl2 = false;
                    Assert.fail((String)"Error getting templates", (Throwable)e);
                }
            } while (cursor.moveToNext());
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return usedTemplates;
    }

    static /* synthetic */ List captureTemplateIds$default(StorageStatements storageStatements, ReadState readState2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = captureTemplateIds.1.INSTANCE;
        }
        return storageStatements.captureTemplateIds(readState2, (Function1<? super Cursor, Boolean>)function1);
    }

    @NotNull
    public final StorageStatement writeTemplates(@NotNull List<Template> templates) {
        Intrinsics.checkNotNullParameter(templates, (String)"templates");
        return new StorageStatement(templates){
            final /* synthetic */ List<Template> $templates;
            {
                this.$templates = $templates;
            }

            public void execute(@NotNull SqlCompiler compiler) {
                Intrinsics.checkNotNullParameter((Object)compiler, (String)"compiler");
                SQLiteStatement insertStatement = compiler.compileStatement("INSERT OR IGNORE INTO templates VALUES (?, ?)");
                Iterable $this$forEach$iv = this.$templates;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Template it = (Template)element$iv;
                    boolean bl = false;
                    insertStatement.bindString(1, it.getHash());
                    String string = it.getTemplate().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.template.toString()");
                    byte[] byArray = string.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                    insertStatement.bindBlob(2, byArray);
                    insertStatement.executeInsert();
                }
            }

            @NotNull
            public String toString() {
                return "Write templates " + CollectionsKt.joinToString$default((Iterable)this.$templates, null, null, null, (int)0, null, (Function1)writeTemplates.toString.1.INSTANCE, (int)31, null);
            }
        };
    }

    @NotNull
    public final StorageStatement replaceRawJsons(@NotNull List<? extends RawJson> rawJsons, @NotNull Function1<? super List<String>, Unit> onFailedTransactions) {
        Intrinsics.checkNotNullParameter(rawJsons, (String)"rawJsons");
        Intrinsics.checkNotNullParameter(onFailedTransactions, (String)"onFailedTransactions");
        return new StorageStatement(rawJsons, onFailedTransactions){
            @NotNull
            private final Lazy cardIdsString$delegate;
            final /* synthetic */ List<RawJson> $rawJsons;
            final /* synthetic */ Function1<List<String>, Unit> $onFailedTransactions;
            {
                this.$rawJsons = $rawJsons;
                this.$onFailedTransactions = $onFailedTransactions;
                this.cardIdsString$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<String>($rawJsons){
                    final /* synthetic */ List<RawJson> $rawJsons;
                    {
                        this.$rawJsons = $rawJsons;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return CollectionsKt.joinToString$default((Iterable)this.$rawJsons, null, null, null, (int)0, null, (Function1)replaceRawJsons.cardIdsString.1.INSTANCE, (int)31, null);
                    }
                }));
            }

            public void execute(@NotNull SqlCompiler compiler) {
                Intrinsics.checkNotNullParameter((Object)compiler, (String)"compiler");
                List failedTransactions = new ArrayList<E>();
                SQLiteStatement replaceStatement = compiler.compileStatement("INSERT OR REPLACE INTO raw_json VALUES (?, ?)");
                Iterable $this$forEach$iv = this.$rawJsons;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    RawJson json = (RawJson)element$iv;
                    boolean bl = false;
                    SQLiteStatement $this$execute_u24lambda_u243_u24lambda_u242 = replaceStatement;
                    boolean bl2 = false;
                    $this$execute_u24lambda_u243_u24lambda_u242.bindString(1, json.getId());
                    String string = json.getData().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json.data.toString()");
                    byte[] byArray = string.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                    $this$execute_u24lambda_u243_u24lambda_u242.bindBlob(2, byArray);
                    Long l = $this$execute_u24lambda_u243_u24lambda_u242.executeInsert();
                    long id = ((Number)l).longValue();
                    boolean bl3 = false;
                    Long l2 = id < 0L ? l : null;
                    if (l2 == null) continue;
                    long it = ((Number)l2).longValue();
                    boolean bl4 = false;
                    failedTransactions.add(json.getId());
                }
                if (!((Collection)failedTransactions).isEmpty()) {
                    this.$onFailedTransactions.invoke((Object)failedTransactions);
                }
            }

            @NotNull
            public String toString() {
                return "Replace raw jsons (" + this.getCardIdsString() + ')';
            }

            private final String getCardIdsString() {
                Lazy lazy = this.cardIdsString$delegate;
                return (String)lazy.getValue();
            }
        };
    }

    public static /* synthetic */ StorageStatement replaceRawJsons$default(StorageStatements storageStatements, List list, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = replaceRawJsons.1.INSTANCE;
        }
        return storageStatements.replaceRawJsons(list, (Function1<? super List<String>, Unit>)function1);
    }

    @NotNull
    public final StorageStatement replaceCards(@NotNull String groupId, @NotNull List<? extends RawDataAndMetadata> cards, @NotNull Function1<? super List<String>, Unit> onFailedTransactions) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter(cards, (String)"cards");
        Intrinsics.checkNotNullParameter(onFailedTransactions, (String)"onFailedTransactions");
        return new StorageStatement(cards, onFailedTransactions, groupId){
            @NotNull
            private final Lazy cardIdsString$delegate;
            final /* synthetic */ List<RawDataAndMetadata> $cards;
            final /* synthetic */ Function1<List<String>, Unit> $onFailedTransactions;
            final /* synthetic */ String $groupId;
            {
                this.$cards = $cards;
                this.$onFailedTransactions = $onFailedTransactions;
                this.$groupId = $groupId;
                this.cardIdsString$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<String>($cards){
                    final /* synthetic */ List<RawDataAndMetadata> $cards;
                    {
                        this.$cards = $cards;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return CollectionsKt.joinToString$default((Iterable)this.$cards, null, null, null, (int)0, null, (Function1)replaceCards.cardIdsString.1.INSTANCE, (int)31, null);
                    }
                }));
            }

            private final String getCardIdsString() {
                Lazy lazy = this.cardIdsString$delegate;
                return (String)lazy.getValue();
            }

            /*
             * WARNING - void declaration
             */
            public void execute(@NotNull SqlCompiler compiler) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)compiler, (String)"compiler");
                List failedTransactions = new ArrayList<E>();
                SQLiteStatement replaceCardStatement = compiler.compileStatement("INSERT OR REPLACE INTO cards VALUES (?, ?, ?, ?)");
                Iterable iterable = this.$cards;
                String string = this.$groupId;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    byte[] divData2;
                    byte[] byArray;
                    String string2;
                    RawDataAndMetadata dataAndMetadata = (RawDataAndMetadata)element$iv;
                    boolean bl = false;
                    String cardId = dataAndMetadata.getId();
                    String string3 = dataAndMetadata.getDivData().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"dataAndMetadata.divData.toString()");
                    Intrinsics.checkNotNullExpressionValue((Object)string3.getBytes(Charsets.UTF_8), (String)"this as java.lang.String).getBytes(charset)");
                    Object object = dataAndMetadata.getMetadata();
                    if (object != null && (object = (string2 = object.toString())) != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"toString()");
                        byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
                        byArray = byArray2;
                        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
                    } else {
                        byArray = null;
                    }
                    byte[] metaBlob = byArray;
                    int c = 1;
                    replaceCardStatement.bindString(c++, cardId);
                    SqlExtensionsKt.bindNullableBlob(replaceCardStatement, c++, divData2);
                    SqlExtensionsKt.bindNullableBlob(replaceCardStatement, c++, metaBlob);
                    replaceCardStatement.bindString(c++, string);
                    long id = replaceCardStatement.executeInsert();
                    if (id >= 0L) continue;
                    failedTransactions.add(cardId);
                }
                if (!((Collection)failedTransactions).isEmpty()) {
                    this.$onFailedTransactions.invoke((Object)failedTransactions);
                }
            }

            @NotNull
            public String toString() {
                return "Replace cards (" + this.getCardIdsString() + ")}";
            }
        };
    }

    public static /* synthetic */ StorageStatement replaceCards$default(StorageStatements storageStatements, String string, List list, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = replaceCards.1.INSTANCE;
        }
        return storageStatements.replaceCards(string, list, (Function1<? super List<String>, Unit>)function1);
    }

    @NotNull
    public final StorageStatement deleteTemplatesWithoutLinksToCards() {
        return new StorageStatement(){

            public void execute(@NotNull SqlCompiler compiler) {
                Intrinsics.checkNotNullParameter((Object)compiler, (String)"compiler");
                compiler.compileStatement("\n    DELETE FROM template_references\n    WHERE group_id NOT IN\n        (SELECT group_id FROM cards)\n    ").executeUpdateDelete();
                compiler.compileStatement("\n    DELETE FROM templates\n    WHERE template_hash NOT IN\n        (SELECT DISTINCT template_hash FROM template_references)\n    ").executeUpdateDelete();
            }

            @NotNull
            public String toString() {
                return "Deleting unused templates";
            }
        };
    }

    @NotNull
    public final StorageStatement deleteCardsAndTemplates(@NotNull Set<String> elementIds) {
        Intrinsics.checkNotNullParameter(elementIds, (String)"elementIds");
        return new StorageStatement(elementIds){
            final /* synthetic */ Set<String> $elementIds;
            {
                this.$elementIds = $elementIds;
            }

            public void execute(@NotNull SqlCompiler compiler) {
                Intrinsics.checkNotNullParameter((Object)compiler, (String)"compiler");
                SQLiteStatement deleteCardsStatement = compiler.compileStatement("DELETE FROM cards WHERE layout_id IN  " + StorageStatements.access$asSqlList(StorageStatements.INSTANCE, this.$elementIds));
                SQLiteStatement deleteTemplateUsagesStatement = compiler.compileStatement("\n    DELETE FROM template_references WHERE group_id IN\n " + StorageStatements.access$asSqlList(StorageStatements.INSTANCE, this.$elementIds));
                deleteCardsStatement.executeUpdateDelete();
                deleteTemplateUsagesStatement.executeUpdateDelete();
            }

            @NotNull
            public String toString() {
                return "Deleting cards with ids: " + this.$elementIds;
            }
        };
    }

    @NotNull
    public final StorageStatement deleteRawJsons(@NotNull Set<String> elementIds) {
        Intrinsics.checkNotNullParameter(elementIds, (String)"elementIds");
        return new StorageStatement(elementIds){
            final /* synthetic */ Set<String> $elementIds;
            {
                this.$elementIds = $elementIds;
            }

            public void execute(@NotNull SqlCompiler compiler) {
                Intrinsics.checkNotNullParameter((Object)compiler, (String)"compiler");
                compiler.compileStatement("DELETE FROM raw_json WHERE raw_json_id IN " + StorageStatements.access$asSqlList(StorageStatements.INSTANCE, this.$elementIds)).executeUpdateDelete();
            }

            @NotNull
            public String toString() {
                return "Deleting raw jsons with ids: " + this.$elementIds;
            }
        };
    }

    private final <T> String asSqlList(Collection<? extends T> $this$asSqlList) {
        return CollectionsKt.joinToString$default((Iterable)$this$asSqlList, (CharSequence)"', '", (CharSequence)"('", (CharSequence)"')", (int)0, null, null, (int)56, null);
    }

    @NotNull
    public final StorageStatement isTemplateExists(@NotNull String templateHash, @NotNull Function1<? super Boolean, Unit> result) {
        Intrinsics.checkNotNullParameter((Object)templateHash, (String)"templateHash");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        return new StorageStatement(templateHash, result){
            final /* synthetic */ String $templateHash;
            final /* synthetic */ Function1<Boolean, Unit> $result;
            {
                this.$templateHash = $templateHash;
                this.$result = $result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(@NotNull SqlCompiler compiler) {
                Intrinsics.checkNotNullParameter((Object)compiler, (String)"compiler");
                ReadState state = compiler.compileQuery("SELECT 1 FROM templates WHERE template_hash == '" + this.$templateHash + "' ", new String[0]);
                Closeable closeable = state;
                Function1<Boolean, Unit> function1 = this.$result;
                Throwable throwable = null;
                try {
                    ReadState it = (ReadState)closeable;
                    boolean bl = false;
                    function1.invoke((Object)(it.getCursor().getCount() > 0 ? 1 : 0));
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }

            @NotNull
            public String toString() {
                return "Check template '" + this.$templateHash + "' exists in group";
            }
        };
    }

    @NotNull
    public final StorageStatement isCardExists(@NotNull String cardId, @NotNull String groupId, @NotNull Function1<? super Boolean, Unit> result) {
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        return new StorageStatement(cardId, groupId, result){
            final /* synthetic */ String $cardId;
            final /* synthetic */ String $groupId;
            final /* synthetic */ Function1<Boolean, Unit> $result;
            {
                this.$cardId = $cardId;
                this.$groupId = $groupId;
                this.$result = $result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(@NotNull SqlCompiler compiler) {
                Intrinsics.checkNotNullParameter((Object)compiler, (String)"compiler");
                ReadState state = compiler.compileQuery("SELECT 1 FROM cards WHERE layout_id == '" + this.$cardId + "' AND group_id == '" + this.$groupId + '\'', new String[0]);
                Closeable closeable = state;
                Function1<Boolean, Unit> function1 = this.$result;
                Throwable throwable = null;
                try {
                    ReadState it = (ReadState)closeable;
                    boolean bl = false;
                    function1.invoke((Object)(it.getCursor().getCount() > 0 ? 1 : 0));
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }

            @NotNull
            public String toString() {
                return "Check card '" + this.$cardId + "' with group '" + this.$groupId + "' exists";
            }
        };
    }

    @NotNull
    public final StorageStatement readData(@NotNull Function1<? super ReadState, Unit> reader) {
        Intrinsics.checkNotNullParameter(reader, (String)"reader");
        return new StorageStatement(reader){
            final /* synthetic */ Function1<ReadState, Unit> $reader;
            {
                this.$reader = $reader;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(@NotNull SqlCompiler compiler) {
                Intrinsics.checkNotNullParameter((Object)compiler, (String)"compiler");
                ReadState readState2 = compiler.compileQuery("SELECT * FROM cards", new String[0]);
                Closeable closeable = readState2;
                Function1<ReadState, Unit> function1 = this.$reader;
                Throwable throwable = null;
                try {
                    Object object = function1.invoke((Object)closeable);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }

            @NotNull
            public String toString() {
                return "Selecting all div data";
            }
        };
    }

    @NotNull
    public final StorageStatement readRawJsons(@NotNull Function1<? super ReadState, Unit> reader) {
        Intrinsics.checkNotNullParameter(reader, (String)"reader");
        return new StorageStatement(reader){
            final /* synthetic */ Function1<ReadState, Unit> $reader;
            {
                this.$reader = $reader;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(@NotNull SqlCompiler compiler) {
                Intrinsics.checkNotNullParameter((Object)compiler, (String)"compiler");
                ReadState readState2 = compiler.compileQuery("SELECT * FROM raw_json", new String[0]);
                Closeable closeable = readState2;
                Function1<ReadState, Unit> function1 = this.$reader;
                Throwable throwable = null;
                try {
                    Object object = function1.invoke((Object)closeable);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }

            @NotNull
            public String toString() {
                return "Selecting all raw jsons";
            }
        };
    }

    @NotNull
    public final StorageStatement writeTemplatesUsages(@NotNull String groupId, @NotNull List<Template> templates) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter(templates, (String)"templates");
        return new StorageStatement(templates, groupId){
            final /* synthetic */ List<Template> $templates;
            final /* synthetic */ String $groupId;
            {
                this.$templates = $templates;
                this.$groupId = $groupId;
            }

            /*
             * WARNING - void declaration
             */
            public void execute(@NotNull SqlCompiler compiler) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)compiler, (String)"compiler");
                SQLiteStatement insertUsageStatement = compiler.compileStatement("INSERT OR IGNORE INTO template_references VALUES (?, ?, ?)");
                Iterable iterable = this.$templates;
                String string = this.$groupId;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Template template = (Template)element$iv;
                    boolean bl = false;
                    insertUsageStatement.bindString(1, string);
                    insertUsageStatement.bindString(2, template.getId());
                    insertUsageStatement.bindString(3, template.getHash());
                    insertUsageStatement.executeInsert();
                }
            }

            @NotNull
            public String toString() {
                return "Write template usages for " + this.$groupId;
            }
        };
    }

    @NotNull
    public final StorageStatement dropAllTables() {
        return new StorageStatement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(@NotNull SqlCompiler compiler) {
                Intrinsics.checkNotNullParameter((Object)compiler, (String)"compiler");
                List tableNames = new ArrayList<E>();
                Closeable closeable = compiler.compileQuery("SELECT name FROM sqlite_master WHERE type='table'", new String[0]);
                Throwable throwable = null;
                try {
                    ReadState it = (ReadState)closeable;
                    boolean bl = false;
                    Cursor cursor = it.getCursor();
                    if (!cursor.moveToFirst()) {
                        return;
                    }
                    do {
                        String string = cursor.getString(cursor.getColumnIndexOrThrow("name"));
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cursor.getString(cursor.\u2026lumnIndexOrThrow(\"name\"))");
                        tableNames.add(string);
                    } while (cursor.moveToNext());
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                Iterable $this$forEach$iv = tableNames;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    compiler.compileStatement("DROP TABLE IF EXISTS " + it).execute();
                }
            }

            @NotNull
            public String toString() {
                return "Drop all database tables";
            }
        };
    }

    public static final /* synthetic */ String access$asSqlList(StorageStatements $this, Collection $receiver) {
        return $this.asSqlList($receiver);
    }
}

