/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.storage.db;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.yandex.div.internal.Assert;
import com.yandex.div.storage.db.DBKt;
import com.yandex.div.storage.db.TemplateDao;
import com.yandex.div.storage.entity.Template;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\tH\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0014\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013*\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\n \u0014*\u0004\u0018\u00010\r0\r*\u00020\u0015H\u0002J\u0012\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/yandex/div/storage/db/TemplateDaoImpl;", "Lcom/yandex/div/storage/db/TemplateDao;", "writableDatabase", "Landroid/database/sqlite/SQLiteDatabase;", "(Landroid/database/sqlite/SQLiteDatabase;)V", "deleteAllTemplates", "", "deleteUnusedTemplates", "getAllTemplates", "", "Lcom/yandex/div/storage/entity/Template;", "getTemplates", "cardId", "", "getTemplatesByIds", "templateIds", "insertTemplate", "template", "getData", "", "kotlin.jvm.PlatformType", "Landroid/database/Cursor;", "getId", "retrieveTemplates", "div-storage_release"})
@SourceDebugExtension(value={"SMAP\nTemplateDaoImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemplateDaoImpl.kt\ncom/yandex/div/storage/db/TemplateDaoImpl\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,72:1\n26#2:73\n37#3,2:74\n*S KotlinDebug\n*F\n+ 1 TemplateDaoImpl.kt\ncom/yandex/div/storage/db/TemplateDaoImpl\n*L\n25#1:73\n42#1:74,2\n*E\n"})
public final class TemplateDaoImpl
implements TemplateDao {
    @NotNull
    private final SQLiteDatabase writableDatabase;

    public TemplateDaoImpl(@NotNull SQLiteDatabase writableDatabase) {
        Intrinsics.checkNotNullParameter((Object)writableDatabase, (String)"writableDatabase");
        this.writableDatabase = writableDatabase;
        if (this.writableDatabase.isReadOnly()) {
            Assert.fail((String)(this.getClass().getName() + " requires writable db!"));
        }
    }

    @Override
    @NotNull
    public List<Template> getAllTemplates() {
        boolean $i$f$emptyArray = false;
        Cursor cursor = this.writableDatabase.rawQuery("SELECT * FROM templates", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"cursor");
        List<Template> templates = this.retrieveTemplates(cursor);
        cursor.close();
        return templates;
    }

    @Override
    @NotNull
    public List<Template> getTemplates(@NotNull String cardId) {
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        String[] stringArray = new String[]{cardId};
        Cursor cursor = this.writableDatabase.rawQuery("SELECT templates.template_id, templates.template_data FROM templates INNER JOIN template_usages ON templates.template_id = template_usages.template_id WHERE template_usages.card_id = ?", stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"cursor");
        List<Template> templates = this.retrieveTemplates(cursor);
        cursor.close();
        return templates;
    }

    @Override
    @NotNull
    public List<Template> getTemplatesByIds(@NotNull List<String> templateIds) {
        Intrinsics.checkNotNullParameter(templateIds, (String)"templateIds");
        StringBuilder queryBuilder = DBKt.appendPlaceholders(new StringBuilder("SELECT template_id, template_data FROM templates WHERE template_id IN "), templateIds.size());
        Collection $this$toTypedArray$iv = templateIds;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Cursor cursor = this.writableDatabase.rawQuery(queryBuilder.toString(), thisCollection$iv.toArray(new String[0]));
        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"cursor");
        List<Template> templates = this.retrieveTemplates(cursor);
        cursor.close();
        return templates;
    }

    @Override
    public void insertTemplate(@NotNull Template template) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Object[] objectArray = new Serializable[]{template.getId(), template.getData()};
        this.writableDatabase.execSQL("INSERT OR IGNORE INTO `templates` (`template_id`,`template_data`) VALUES (?,?)", objectArray);
    }

    @Override
    public void deleteAllTemplates() {
        this.writableDatabase.execSQL("DELETE FROM templates");
    }

    @Override
    public void deleteUnusedTemplates() {
        this.writableDatabase.execSQL("DELETE FROM templates WHERE template_id NOT IN (SELECT DISTINCT template_id FROM template_usages)");
    }

    private final String getId(Cursor $this$getId) {
        return $this$getId.getString($this$getId.getColumnIndexOrThrow("template_id"));
    }

    private final byte[] getData(Cursor $this$getData) {
        return $this$getData.getBlob($this$getData.getColumnIndexOrThrow("template_data"));
    }

    private final List<Template> retrieveTemplates(Cursor $this$retrieveTemplates) {
        List templates = new ArrayList();
        while ($this$retrieveTemplates.moveToNext()) {
            String id = this.getId($this$retrieveTemplates);
            byte[] data2 = this.getData($this$retrieveTemplates);
            Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
            Intrinsics.checkNotNullExpressionValue((Object)data2, (String)"data");
            templates.add(new Template(id, data2));
        }
        return templates;
    }
}

