/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.storage.histogram;

import androidx.annotation.AnyThread;
import com.yandex.div.histogram.HistogramFilter;
import com.yandex.div.histogram.reporter.HistogramReporter;
import com.yandex.div.histogram.reporter.HistogramReporterDelegate;
import com.yandex.div.storage.histogram.HistogramNameProvider;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\b\u0010\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0012J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0017J\"\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0012J\u001a\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0017J\u001e\u0010\u0017\u001a\u00020\u000f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/yandex/div/storage/histogram/HistogramRecorder;", "", "histogramReporterDelegate", "Lcom/yandex/div/histogram/reporter/HistogramReporterDelegate;", "histogramNameProvider", "Lcom/yandex/div/storage/histogram/HistogramNameProvider;", "(Lcom/yandex/div/histogram/reporter/HistogramReporterDelegate;Lcom/yandex/div/storage/histogram/HistogramNameProvider;)V", "histogramReporter", "Lcom/yandex/div/histogram/reporter/HistogramReporter;", "recordedHistograms", "Ljava/util/concurrent/CopyOnWriteArraySet;", "", "getHistogramCallType", "histogramName", "reportDivDataLoadTime", "", "duration", "", "filter", "Lcom/yandex/div/histogram/HistogramFilter;", "reportDuration", "time", "reportTemplateLoadedTime", "reportTemplatesParseTime", "parsingHistogramNames", "", "div-storage_release"})
@SourceDebugExtension(value={"SMAP\nHistogramRecorder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HistogramRecorder.kt\ncom/yandex/div/storage/histogram/HistogramRecorder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1855#2,2:68\n*S KotlinDebug\n*F\n+ 1 HistogramRecorder.kt\ncom/yandex/div/storage/histogram/HistogramRecorder\n*L\n62#1:68,2\n*E\n"})
public class HistogramRecorder {
    @Nullable
    private final HistogramNameProvider histogramNameProvider;
    @NotNull
    private final HistogramReporter histogramReporter;
    @NotNull
    private final CopyOnWriteArraySet<String> recordedHistograms;

    public HistogramRecorder(@NotNull HistogramReporterDelegate histogramReporterDelegate, @Nullable HistogramNameProvider histogramNameProvider) {
        Intrinsics.checkNotNullParameter((Object)histogramReporterDelegate, (String)"histogramReporterDelegate");
        this.histogramNameProvider = histogramNameProvider;
        this.histogramReporter = new HistogramReporter(histogramReporterDelegate);
        this.recordedHistograms = new CopyOnWriteArraySet();
    }

    @AnyThread
    public void reportTemplateLoadedTime(long duration, @NotNull HistogramFilter filter) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
            HistogramNameProvider histogramNameProvider = this.histogramNameProvider;
            if (histogramNameProvider == null) break block0;
            HistogramNameProvider $this$reportTemplateLoadedTime_u24lambda_u240 = histogramNameProvider;
            boolean bl = false;
            this.reportDuration($this$reportTemplateLoadedTime_u24lambda_u240.getDivLoadTemplatesReportName(), duration, filter);
        }
    }

    public static /* synthetic */ void reportTemplateLoadedTime$default(HistogramRecorder histogramRecorder, long l, HistogramFilter histogramFilter, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reportTemplateLoadedTime");
        }
        if ((n & 2) != 0) {
            histogramFilter = HistogramFilter.Companion.getON();
        }
        histogramRecorder.reportTemplateLoadedTime(l, histogramFilter);
    }

    @AnyThread
    public void reportDivDataLoadTime(long duration, @NotNull HistogramFilter filter) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
            HistogramNameProvider histogramNameProvider = this.histogramNameProvider;
            if (histogramNameProvider == null) break block0;
            HistogramNameProvider $this$reportDivDataLoadTime_u24lambda_u241 = histogramNameProvider;
            boolean bl = false;
            this.reportDuration($this$reportDivDataLoadTime_u24lambda_u241.getDivDataLoadReportName(), duration, filter);
        }
    }

    public static /* synthetic */ void reportDivDataLoadTime$default(HistogramRecorder histogramRecorder, long l, HistogramFilter histogramFilter, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reportDivDataLoadTime");
        }
        if ((n & 2) != 0) {
            histogramFilter = HistogramFilter.Companion.getON();
        }
        histogramRecorder.reportDivDataLoadTime(l, histogramFilter);
    }

    private void reportDuration(String histogramName, long time, HistogramFilter filter) {
        HistogramReporter histogramReporter = this.histogramReporter;
        HistogramNameProvider histogramNameProvider = this.histogramNameProvider;
        String string = histogramNameProvider != null ? histogramNameProvider.getComponentName() : null;
        String string2 = this.getHistogramCallType(histogramName);
        histogramReporter.reportDuration(histogramName, time, string, string2, filter);
    }

    static /* synthetic */ void reportDuration$default(HistogramRecorder histogramRecorder, String string, long l, HistogramFilter histogramFilter, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reportDuration");
        }
        if ((n & 4) != 0) {
            histogramFilter = HistogramFilter.Companion.getON();
        }
        histogramRecorder.reportDuration(string, l, histogramFilter);
    }

    private String getHistogramCallType(String histogramName) {
        Object object;
        if (this.recordedHistograms.add(histogramName)) {
            object = this.histogramNameProvider;
            if (object == null || (object = object.getColdCallTypeSuffix()) == null) {
                object = "Cold";
            }
        } else {
            object = this.histogramNameProvider;
            if (object == null || (object = object.getHotCallTypeSuffix()) == null) {
                object = "Warm";
            }
        }
        return object;
    }

    public void reportTemplatesParseTime(@NotNull Set<String> parsingHistogramNames, long duration) {
        Intrinsics.checkNotNullParameter(parsingHistogramNames, (String)"parsingHistogramNames");
        Iterable $this$forEach$iv = parsingHistogramNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            HistogramNameProvider histogramNameProvider = this.histogramNameProvider;
            HistogramReporter.reportDuration$default((HistogramReporter)this.histogramReporter, (String)it, (long)duration, (String)(histogramNameProvider != null ? histogramNameProvider.getComponentName() : null), null, null, (int)24, null);
        }
    }
}

