/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.storage.templates;

import android.os.SystemClock;
import com.yandex.div.data.DivParsingEnvironment;
import com.yandex.div.json.ParsingErrorLogger;
import com.yandex.div.storage.DivStorage;
import com.yandex.div.storage.database.StorageException;
import com.yandex.div.storage.histogram.HistogramRecorder;
import com.yandex.div.storage.templates.DivParsingHistogramProxy;
import com.yandex.div.storage.templates.RawTemplateData;
import com.yandex.div.storage.templates.TemplateHashIds;
import com.yandex.div.storage.templates.TemplateReferenceResolver;
import com.yandex.div.storage.templates.TemplatesContainerKt;
import com.yandex.div2.DivTemplate;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u0014\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\u0010\u0012\u0004\u0012\u00020\u00110\u00152\u0006\u0010\u0016\u001a\u00020\u0017J&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u001bH\u0002J\u001a\u0010\u001c\u001a\u00020\u00192\n\u0010\u001d\u001a\u00060\u0007j\u0002`\u00102\u0006\u0010\u001e\u001a\u00020\u0011R\u001e\u0010\u000e\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/yandex/div/storage/templates/CommonTemplatesPool;", "", "divStorage", "Lcom/yandex/div/storage/DivStorage;", "logger", "Lcom/yandex/div/json/ParsingErrorLogger;", "histogramComponent", "", "histogramRecorder", "Lcom/yandex/div/storage/histogram/HistogramRecorder;", "parsingHistogramProxy", "Ljavax/inject/Provider;", "Lcom/yandex/div/storage/templates/DivParsingHistogramProxy;", "(Lcom/yandex/div/storage/DivStorage;Lcom/yandex/div/json/ParsingErrorLogger;Ljava/lang/String;Lcom/yandex/div/storage/histogram/HistogramRecorder;Ljavax/inject/Provider;)V", "commonTemplates", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/yandex/div/storage/templates/TemplateHash;", "Lcom/yandex/div2/DivTemplate;", "env", "Lcom/yandex/div/data/DivParsingEnvironment;", "load", "", "templateReferences", "Lcom/yandex/div/storage/templates/TemplateReferenceResolver;", "loadFromStorage", "", "templateHashes", "", "put", "templateHash", "template", "div-storage_release"})
@SourceDebugExtension(value={"SMAP\nTemplatesContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemplatesContainer.kt\ncom/yandex/div/storage/templates/CommonTemplatesPool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 TemplatesContainer.kt\ncom/yandex/div/storage/templates/TemplateReferenceResolver\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,382:1\n1#2:383\n515#3:384\n500#3,6:385\n1855#4:391\n1855#4,2:394\n1856#4:400\n1855#4,2:401\n356#5,2:392\n358#5,4:396\n215#6,2:403\n*S KotlinDebug\n*F\n+ 1 TemplatesContainer.kt\ncom/yandex/div/storage/templates/CommonTemplatesPool\n*L\n275#1:384\n275#1:385,6\n285#1:391\n294#1:394,2\n285#1:400\n303#1:401,2\n294#1:392,2\n294#1:396,4\n310#1:403,2\n*E\n"})
final class CommonTemplatesPool {
    @NotNull
    private final DivStorage divStorage;
    @Nullable
    private final String histogramComponent;
    @NotNull
    private final HistogramRecorder histogramRecorder;
    @NotNull
    private final Provider<DivParsingHistogramProxy> parsingHistogramProxy;
    @NotNull
    private final ConcurrentHashMap<String, DivTemplate> commonTemplates;
    @NotNull
    private final DivParsingEnvironment env;

    public CommonTemplatesPool(@NotNull DivStorage divStorage, @NotNull ParsingErrorLogger logger, @Nullable String histogramComponent, @NotNull HistogramRecorder histogramRecorder, @NotNull Provider<DivParsingHistogramProxy> parsingHistogramProxy2) {
        Intrinsics.checkNotNullParameter((Object)divStorage, (String)"divStorage");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)histogramRecorder, (String)"histogramRecorder");
        Intrinsics.checkNotNullParameter(parsingHistogramProxy2, (String)"parsingHistogramProxy");
        this.divStorage = divStorage;
        this.histogramComponent = histogramComponent;
        this.histogramRecorder = histogramRecorder;
        this.parsingHistogramProxy = parsingHistogramProxy2;
        this.commonTemplates = new ConcurrentHashMap();
        this.env = TemplatesContainerKt.access$createEmptyEnv(logger);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, DivTemplate> load(@NotNull TemplateReferenceResolver templateReferences) {
        void $this$filterTo$iv$iv;
        Set set;
        Intrinsics.checkNotNullParameter((Object)templateReferences, (String)"templateReferences");
        Set<String> templateHashes = templateReferences.getTemplateHashes();
        Set $this$load_u24lambda_u240 = set = CollectionsKt.toMutableSet((Iterable)templateHashes);
        boolean $i$a$-apply-CommonTemplatesPool$load$nonLoaded$22 = false;
        Set set2 = this.commonTemplates.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"commonTemplates.keys");
        $this$load_u24lambda_u240.removeAll(set2);
        Set nonLoaded = set;
        if (!((Collection)nonLoaded).isEmpty()) {
            this.loadFromStorage(this.env, templateReferences, nonLoaded);
        }
        Map $this$filter$iv = this.commonTemplates;
        boolean $i$f$filter = false;
        Map $i$a$-apply-CommonTemplatesPool$load$nonLoaded$22 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!templateHashes.contains(it.getKey())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    private final void loadFromStorage(DivParsingEnvironment env, TemplateReferenceResolver templateReferences, Set<String> templateHashes) {
        Map results;
        Object it;
        long loadingStarted = SystemClock.uptimeMillis();
        DivStorage.LoadDataResult<RawTemplateData> loadResult = this.divStorage.readTemplates(templateHashes);
        HistogramRecorder.reportTemplateLoadedTime$default(this.histogramRecorder, SystemClock.uptimeMillis() - loadingStarted, null, 2, null);
        JSONObject templatesJson = new JSONObject();
        Iterable $this$forEach$iv = loadResult.getRestoredData();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            String templateId;
            JSONObject jSONObject;
            it = (RawTemplateData)element$iv;
            boolean bl2 = false;
            String hash = ((RawTemplateData)it).getHash();
            try {
                jSONObject = new JSONObject(new String(((RawTemplateData)it).getData(), Charsets.UTF_8));
            }
            catch (JSONException e) {
                env.getLogger().logError((Exception)new IllegalStateException("Template deserialization failed (hash: " + hash + ")!", e));
                jSONObject = Unit.INSTANCE;
            }
            JSONObject json = jSONObject;
            TemplateReferenceResolver this_$iv = templateReferences;
            boolean $i$f$doOnEachResolvedId = false;
            TemplateHashIds ids$iv = (TemplateHashIds)TemplateReferenceResolver.access$getTemplateIdRefs(this_$iv).get(hash);
            if (ids$iv instanceof TemplateHashIds.Collection) {
                Iterable $this$forEach$iv$iv = ((TemplateHashIds.Collection)ids$iv).unbox-impl();
                boolean $i$f$forEach2 = false;
                for (Object element$iv$iv : $this$forEach$iv$iv) {
                    String it$iv = (String)element$iv$iv;
                    boolean bl3 = false;
                    templateId = it$iv;
                    bl = false;
                    try {
                        templatesJson.put(templateId, (Object)json);
                    }
                    catch (JSONException e) {
                        env.getLogger().logError((Exception)new IllegalStateException("Template '" + templateId + "' adding to json failed!", e));
                    }
                }
                continue;
            }
            if (ids$iv instanceof TemplateHashIds.Single) {
                templateId = ((TemplateHashIds.Single)ids$iv).unbox-impl();
                bl = false;
                try {
                    templatesJson.put(templateId, (Object)json);
                }
                catch (JSONException e) {
                    env.getLogger().logError((Exception)new IllegalStateException("Template '" + templateId + "' adding to json failed!", e));
                }
                continue;
            }
            if (ids$iv != null) continue;
            TemplateReferenceResolver.access$getLogger$p(this_$iv).logError((Exception)new IllegalStateException("No template id was found for hash!"));
        }
        $this$forEach$iv = loadResult.getErrors();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StorageException)element$iv;
            boolean bl = false;
            env.getLogger().logError((Exception)it);
        }
        Map $this$forEach$iv2 = results = ((DivParsingHistogramProxy)this.parsingHistogramProxy.get()).parseTemplatesWithResultsAndDependencies(env, templatesJson, this.histogramComponent).getParsedTemplates();
        boolean $i$f$forEach3 = false;
        Iterator iterator = $this$forEach$iv2.entrySet().iterator();
        while (iterator.hasNext()) {
            String hash;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String id = (String)entry.getKey();
            DivTemplate template = (DivTemplate)entry.getValue();
            if (templateReferences.resolveTemplateHash(id) == null) {
                CommonTemplatesPool $this$loadFromStorage_u24lambda_u246_u24lambda_u245 = this;
                boolean bl4 = false;
                env.getLogger().logError((Exception)new IllegalStateException("Failed to resolve template hash for id: " + id));
                continue;
            }
            ((Map)this.commonTemplates).put(hash, template);
        }
    }

    public final void put(@NotNull String templateHash, @NotNull DivTemplate template) {
        Intrinsics.checkNotNullParameter((Object)templateHash, (String)"templateHash");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        ((Map)this.commonTemplates).put(templateHash, template);
    }
}

