/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.yanzhenjie.permission.LRequest;
import com.yanzhenjie.permission.MRequest;
import com.yanzhenjie.permission.Request;
import com.yanzhenjie.permission.SettingService;
import com.yanzhenjie.permission.setting.PermissionSetting;
import com.yanzhenjie.permission.source.AppActivitySource;
import com.yanzhenjie.permission.source.ContextSource;
import com.yanzhenjie.permission.source.FragmentSource;
import com.yanzhenjie.permission.source.Source;
import com.yanzhenjie.permission.source.SupportFragmentSource;
import java.util.List;

public class AndPermission {
    private static final RequestFactory FACTORY = Build.VERSION.SDK_INT >= 23 ? new MRequestFactory() : new LRequestFactory();

    public static boolean hasAlwaysDeniedPermission(@NonNull Activity activity, @NonNull List<String> deniedPermissions) {
        return AndPermission.hasAlwaysDeniedPermission((Source)new AppActivitySource(activity), deniedPermissions);
    }

    public static boolean hasAlwaysDeniedPermission(@NonNull android.support.v4.app.Fragment fragment, @NonNull List<String> deniedPermissions) {
        return AndPermission.hasAlwaysDeniedPermission((Source)new SupportFragmentSource(fragment), deniedPermissions);
    }

    public static boolean hasAlwaysDeniedPermission(@NonNull Fragment fragment, @NonNull List<String> deniedPermissions) {
        return AndPermission.hasAlwaysDeniedPermission((Source)new FragmentSource(fragment), deniedPermissions);
    }

    public static boolean hasAlwaysDeniedPermission(@NonNull Context context, @NonNull List<String> deniedPermissions) {
        return AndPermission.hasAlwaysDeniedPermission((Source)new ContextSource(context), deniedPermissions);
    }

    private static boolean hasAlwaysDeniedPermission(@NonNull Source source, @NonNull List<String> deniedPermissions) {
        for (String permission : deniedPermissions) {
            if (source.isShowRationalePermission(permission)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAlwaysDeniedPermission(@NonNull Activity activity, String ... deniedPermissions) {
        return AndPermission.hasAlwaysDeniedPermission((Source)new AppActivitySource(activity), deniedPermissions);
    }

    public static boolean hasAlwaysDeniedPermission(@NonNull android.support.v4.app.Fragment fragment, String ... deniedPermissions) {
        return AndPermission.hasAlwaysDeniedPermission((Source)new SupportFragmentSource(fragment), deniedPermissions);
    }

    public static boolean hasAlwaysDeniedPermission(@NonNull Fragment fragment, String ... deniedPermissions) {
        return AndPermission.hasAlwaysDeniedPermission((Source)new FragmentSource(fragment), deniedPermissions);
    }

    public static boolean hasAlwaysDeniedPermission(@NonNull Context context, String ... deniedPermissions) {
        return AndPermission.hasAlwaysDeniedPermission((Source)new ContextSource(context), deniedPermissions);
    }

    private static boolean hasAlwaysDeniedPermission(@NonNull Source source, String ... deniedPermissions) {
        for (String permission : deniedPermissions) {
            if (source.isShowRationalePermission(permission)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    public static SettingService permissionSetting(@NonNull Activity activity) {
        return new PermissionSetting(new AppActivitySource(activity));
    }

    @NonNull
    public static SettingService permissionSetting(@NonNull android.support.v4.app.Fragment fragment) {
        return new PermissionSetting(new SupportFragmentSource(fragment));
    }

    @NonNull
    public static SettingService permissionSetting(@NonNull Fragment fragment) {
        return new PermissionSetting(new FragmentSource(fragment));
    }

    @NonNull
    public static SettingService permissionSetting(@NonNull Context context) {
        return new PermissionSetting(new ContextSource(context));
    }

    @NonNull
    public static Request with(@NonNull Activity activity) {
        return FACTORY.create(new AppActivitySource(activity));
    }

    @NonNull
    public static Request with(@NonNull android.support.v4.app.Fragment fragment) {
        return FACTORY.create(new SupportFragmentSource(fragment));
    }

    @NonNull
    public static Request with(@NonNull Fragment fragment) {
        return FACTORY.create(new FragmentSource(fragment));
    }

    @NonNull
    public static Request with(@NonNull Context context) {
        return FACTORY.create(new ContextSource(context));
    }

    private AndPermission() {
    }

    @RequiresApi(api=23)
    private static class MRequestFactory
    implements RequestFactory {
        private MRequestFactory() {
        }

        @Override
        public Request create(Source source) {
            return new MRequest(source);
        }
    }

    private static class LRequestFactory
    implements RequestFactory {
        private LRequestFactory() {
        }

        @Override
        public Request create(Source source) {
            return new LRequest(source);
        }
    }

    private static interface RequestFactory {
        public Request create(Source var1);
    }
}

