/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission;

import android.support.annotation.NonNull;
import com.yanzhenjie.permission.Action;
import com.yanzhenjie.permission.Rationale;
import com.yanzhenjie.permission.Request;
import com.yanzhenjie.permission.checker.PermissionChecker;
import com.yanzhenjie.permission.checker.StrictChecker;
import com.yanzhenjie.permission.source.Source;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class LRequest
implements Request {
    private static final PermissionChecker CHECKER = new StrictChecker();
    private Source mSource;
    private String[] mPermissions;
    private Action mGranted;
    private Action mDenied;

    LRequest(Source source) {
        this.mSource = source;
    }

    @Override
    @NonNull
    public Request permission(String ... permissions) {
        this.mPermissions = permissions;
        return this;
    }

    @Override
    @NonNull
    public Request permission(String[] ... groups) {
        ArrayList<String> permissionList = new ArrayList<String>();
        for (String[] group : groups) {
            permissionList.addAll(Arrays.asList(group));
        }
        this.mPermissions = permissionList.toArray(new String[permissionList.size()]);
        return this;
    }

    @Override
    @NonNull
    public Request rationale(Rationale listener) {
        return this;
    }

    @Override
    @NonNull
    public Request onGranted(Action granted) {
        this.mGranted = granted;
        return this;
    }

    @Override
    @NonNull
    public Request onDenied(Action denied) {
        this.mDenied = denied;
        return this;
    }

    @Override
    public void start() {
        List<String> deniedList = LRequest.getDeniedPermissions(this.mSource, this.mPermissions);
        if (deniedList.isEmpty()) {
            this.callbackSucceed();
        } else {
            this.callbackFailed(deniedList);
        }
    }

    private void callbackSucceed() {
        block3: {
            if (this.mGranted != null) {
                List<String> permissionList = Arrays.asList(this.mPermissions);
                try {
                    this.mGranted.onAction(permissionList);
                }
                catch (Exception e) {
                    if (this.mDenied == null) break block3;
                    this.mDenied.onAction(permissionList);
                }
            }
        }
    }

    private void callbackFailed(@NonNull List<String> deniedList) {
        if (this.mDenied != null) {
            this.mDenied.onAction(deniedList);
        }
    }

    private static List<String> getDeniedPermissions(@NonNull Source source, String ... permissions) {
        ArrayList<String> deniedList = new ArrayList<String>(1);
        for (String permission : permissions) {
            if (CHECKER.hasPermission(source.getContext(), permission)) continue;
            deniedList.add(permission);
        }
        return deniedList;
    }
}

