/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;

@RequiresApi(api=23)
public final class PermissionActivity
extends Activity {
    private static final String KEY_INPUT_PERMISSIONS = "KEY_INPUT_PERMISSIONS";
    private static PermissionListener sPermissionListener;

    public static void requestPermission(Context context, String[] permissions, PermissionListener permissionListener) {
        sPermissionListener = permissionListener;
        Intent intent = new Intent(context, PermissionActivity.class);
        intent.setFlags(0x10000000);
        intent.putExtra(KEY_INPUT_PERMISSIONS, permissions);
        context.startActivity(intent);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        PermissionActivity.invasionStatusBar(this);
        Intent intent = this.getIntent();
        String[] permissions = intent.getStringArrayExtra(KEY_INPUT_PERMISSIONS);
        if (permissions != null && sPermissionListener != null) {
            this.requestPermissions(permissions, 1);
        } else {
            this.finish();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (sPermissionListener != null) {
            sPermissionListener.onRequestPermissionsResult(permissions);
        }
        this.finish();
    }

    protected void onDestroy() {
        super.onDestroy();
        sPermissionListener = null;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    private static void invasionStatusBar(Activity activity) {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            View decorView = window.getDecorView();
            decorView.setSystemUiVisibility(decorView.getSystemUiVisibility() | 0x400 | 0x100);
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(0);
        }
    }

    static interface PermissionListener {
        public void onRequestPermissionsResult(@NonNull String[] var1);
    }
}

