/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.checker;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.support.annotation.RequiresPermission;
import com.yanzhenjie.permission.checker.PermissionTest;
import java.util.List;

class LocationTest
implements PermissionTest {
    private LocationManager mManager;

    LocationTest(Context context) {
        this.mManager = (LocationManager)context.getSystemService("location");
    }

    @Override
    @RequiresPermission(anyOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"})
    public boolean test() throws Throwable {
        List list = this.mManager.getProviders(true);
        if (list.contains("gps")) {
            return true;
        }
        if (list.contains("network")) {
            return true;
        }
        this.mManager.requestLocationUpdates("gps", 0L, 0.0f, (LocationListener)new MLocationListener(this.mManager));
        return true;
    }

    private static class MLocationListener
    implements LocationListener {
        private LocationManager mManager;

        public MLocationListener(LocationManager manager) {
            this.mManager = manager;
        }

        public void onLocationChanged(Location location) {
            this.mManager.removeUpdates((LocationListener)this);
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
            this.mManager.removeUpdates((LocationListener)this);
        }

        public void onProviderEnabled(String provider) {
            this.mManager.removeUpdates((LocationListener)this);
        }

        public void onProviderDisabled(String provider) {
            this.mManager.removeUpdates((LocationListener)this);
        }
    }
}

