/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.checker;

import android.app.AppOpsManager;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.yanzhenjie.permission.checker.PermissionChecker;
import java.util.Arrays;
import java.util.List;

public final class StandardChecker
implements PermissionChecker {
    @Override
    public boolean hasPermission(@NonNull Context context, String ... permissions) {
        return this.hasPermission(context, Arrays.asList(permissions));
    }

    @Override
    public boolean hasPermission(@NonNull Context context, @NonNull List<String> permissions) {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        for (String permission : permissions) {
            int result = context.checkPermission(permission, Process.myPid(), Process.myUid());
            if (result == -1) {
                return false;
            }
            String op = AppOpsManager.permissionToOp((String)permission);
            if (TextUtils.isEmpty((CharSequence)op)) {
                return true;
            }
            AppOpsManager appOpsManager = (AppOpsManager)context.getSystemService(AppOpsManager.class);
            result = appOpsManager.noteProxyOp(op, context.getPackageName());
            if (result == 0) continue;
            return false;
        }
        return true;
    }
}

