/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.checker;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.yanzhenjie.permission.checker.AddVoicemailTest;
import com.yanzhenjie.permission.checker.CalendarReadTest;
import com.yanzhenjie.permission.checker.CalendarWriteTest;
import com.yanzhenjie.permission.checker.CallLogReadTest;
import com.yanzhenjie.permission.checker.CallLogWriteTest;
import com.yanzhenjie.permission.checker.CameraTest;
import com.yanzhenjie.permission.checker.ContactsReadTest;
import com.yanzhenjie.permission.checker.ContactsWriteTest;
import com.yanzhenjie.permission.checker.LocationTest;
import com.yanzhenjie.permission.checker.PermissionChecker;
import com.yanzhenjie.permission.checker.PhoneStateReadTest;
import com.yanzhenjie.permission.checker.RecordAudioTest;
import com.yanzhenjie.permission.checker.SensorsTest;
import com.yanzhenjie.permission.checker.SipTest;
import com.yanzhenjie.permission.checker.SmsReadTest;
import com.yanzhenjie.permission.checker.StorageReadTest;
import com.yanzhenjie.permission.checker.StorageWriteTest;
import java.util.List;

public final class StrictChecker
implements PermissionChecker {
    @Override
    public boolean hasPermission(@NonNull Context context, String ... permissions) {
        if (Build.VERSION.SDK_INT < 21) {
            return true;
        }
        for (String permission : permissions) {
            if (this.hasPermission(context, permission)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasPermission(@NonNull Context context, @NonNull List<String> permissions) {
        if (Build.VERSION.SDK_INT < 21) {
            return true;
        }
        for (String permission : permissions) {
            if (this.hasPermission(context, permission)) continue;
            return false;
        }
        return true;
    }

    @RequiresApi(api=19)
    private boolean hasPermission(Context context, String permission) {
        try {
            switch (permission) {
                case "android.permission.READ_CALENDAR": {
                    return StrictChecker.checkReadCalendar(context);
                }
                case "android.permission.WRITE_CALENDAR": {
                    return StrictChecker.checkWriteCalendar(context);
                }
                case "android.permission.CAMERA": {
                    return StrictChecker.checkCamera(context);
                }
                case "android.permission.READ_CONTACTS": {
                    return StrictChecker.checkReadContacts(context);
                }
                case "android.permission.WRITE_CONTACTS": {
                    return StrictChecker.checkWriteContacts(context);
                }
                case "android.permission.GET_ACCOUNTS": {
                    return true;
                }
                case "android.permission.ACCESS_COARSE_LOCATION": 
                case "android.permission.ACCESS_FINE_LOCATION": {
                    return StrictChecker.checkLocation(context);
                }
                case "android.permission.RECORD_AUDIO": {
                    return StrictChecker.checkRecordAudio();
                }
                case "android.permission.READ_PHONE_STATE": {
                    return StrictChecker.checkReadPhoneState(context);
                }
                case "android.permission.CALL_PHONE": {
                    return true;
                }
                case "android.permission.READ_CALL_LOG": {
                    return StrictChecker.checkReadCallLog(context);
                }
                case "android.permission.WRITE_CALL_LOG": {
                    return StrictChecker.checkWriteCallLog(context);
                }
                case "com.android.voicemail.permission.ADD_VOICEMAIL": {
                    return StrictChecker.checkAddVoicemail(context);
                }
                case "android.permission.USE_SIP": {
                    return StrictChecker.checkSip(context);
                }
                case "android.permission.PROCESS_OUTGOING_CALLS": {
                    return true;
                }
                case "android.permission.BODY_SENSORS": {
                    return StrictChecker.checkSensors(context);
                }
                case "android.permission.SEND_SMS": 
                case "android.permission.RECEIVE_MMS": {
                    return true;
                }
                case "android.permission.READ_SMS": {
                    return StrictChecker.checkReadSms(context);
                }
                case "android.permission.RECEIVE_WAP_PUSH": 
                case "android.permission.RECEIVE_SMS": {
                    return true;
                }
                case "android.permission.READ_EXTERNAL_STORAGE": {
                    return StrictChecker.checkReadStorage();
                }
                case "android.permission.WRITE_EXTERNAL_STORAGE": {
                    return StrictChecker.checkWriteStorage();
                }
            }
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    private static boolean checkReadCalendar(Context context) throws Throwable {
        CalendarReadTest test = new CalendarReadTest(context);
        return test.test();
    }

    private static boolean checkWriteCalendar(Context context) throws Throwable {
        CalendarWriteTest test = new CalendarWriteTest(context);
        return test.test();
    }

    private static boolean checkCamera(Context context) throws Throwable {
        CameraTest test = new CameraTest(context);
        return test.test();
    }

    private static boolean checkReadContacts(Context context) throws Throwable {
        ContactsReadTest test = new ContactsReadTest(context);
        return test.test();
    }

    private static boolean checkWriteContacts(Context context) throws Throwable {
        ContentResolver resolver = context.getContentResolver();
        ContactsWriteTest test = new ContactsWriteTest(resolver);
        return test.test();
    }

    private static boolean checkLocation(Context context) throws Throwable {
        LocationTest test = new LocationTest(context);
        return test.test();
    }

    private static boolean checkRecordAudio() throws Throwable {
        RecordAudioTest test = new RecordAudioTest();
        return test.test();
    }

    private static boolean checkReadPhoneState(Context context) throws Throwable {
        PhoneStateReadTest test = new PhoneStateReadTest(context);
        return test.test();
    }

    private static boolean checkReadCallLog(Context context) throws Throwable {
        CallLogReadTest test = new CallLogReadTest(context);
        return test.test();
    }

    private static boolean checkWriteCallLog(Context context) throws Throwable {
        CallLogWriteTest test = new CallLogWriteTest(context);
        return test.test();
    }

    private static boolean checkAddVoicemail(Context context) throws Throwable {
        AddVoicemailTest test = new AddVoicemailTest(context);
        return test.test();
    }

    private static boolean checkSip(Context context) throws Throwable {
        SipTest test = new SipTest(context);
        return test.test();
    }

    private static boolean checkSensors(Context context) throws Throwable {
        SensorsTest test = new SensorsTest(context);
        return test.test();
    }

    private static boolean checkReadSms(Context context) throws Throwable {
        SmsReadTest test = new SmsReadTest(context);
        return test.test();
    }

    private static boolean checkReadStorage() throws Throwable {
        StorageReadTest test = new StorageReadTest();
        return test.test();
    }

    private static boolean checkWriteStorage() throws Throwable {
        StorageWriteTest test = new StorageWriteTest();
        return test.test();
    }
}

