/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission;

import android.app.Fragment;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import com.yanzhenjie.permission.FileProvider;
import com.yanzhenjie.permission.Options;
import com.yanzhenjie.permission.Setting;
import com.yanzhenjie.permission.checker.PermissionChecker;
import com.yanzhenjie.permission.checker.StandardChecker;
import com.yanzhenjie.permission.source.ContextSource;
import com.yanzhenjie.permission.source.FragmentSource;
import com.yanzhenjie.permission.source.Source;
import com.yanzhenjie.permission.source.SupportFragmentSource;
import java.io.File;
import java.util.List;

public class AndPermission {
    private static final PermissionChecker PERMISSION_CHECKER = new StandardChecker();

    public static Options with(android.support.v4.app.Fragment fragment) {
        return new Options(new SupportFragmentSource(fragment));
    }

    public static Options with(Fragment fragment) {
        return new Options(new FragmentSource(fragment));
    }

    public static Options with(Context context) {
        return new Options(new ContextSource(context));
    }

    public static boolean hasAlwaysDeniedPermission(android.support.v4.app.Fragment fragment, List<String> deniedPermissions) {
        return AndPermission.hasAlwaysDeniedPermission((Source)new SupportFragmentSource(fragment), deniedPermissions);
    }

    public static boolean hasAlwaysDeniedPermission(Fragment fragment, List<String> deniedPermissions) {
        return AndPermission.hasAlwaysDeniedPermission((Source)new FragmentSource(fragment), deniedPermissions);
    }

    public static boolean hasAlwaysDeniedPermission(Context context, List<String> deniedPermissions) {
        return AndPermission.hasAlwaysDeniedPermission((Source)new ContextSource(context), deniedPermissions);
    }

    private static boolean hasAlwaysDeniedPermission(Source source, List<String> deniedPermissions) {
        for (String permission : deniedPermissions) {
            if (source.isShowRationalePermission(permission)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAlwaysDeniedPermission(android.support.v4.app.Fragment fragment, String ... deniedPermissions) {
        return AndPermission.hasAlwaysDeniedPermission((Source)new SupportFragmentSource(fragment), deniedPermissions);
    }

    public static boolean hasAlwaysDeniedPermission(Fragment fragment, String ... deniedPermissions) {
        return AndPermission.hasAlwaysDeniedPermission((Source)new FragmentSource(fragment), deniedPermissions);
    }

    public static boolean hasAlwaysDeniedPermission(Context context, String ... deniedPermissions) {
        return AndPermission.hasAlwaysDeniedPermission((Source)new ContextSource(context), deniedPermissions);
    }

    private static boolean hasAlwaysDeniedPermission(Source source, String ... deniedPermissions) {
        for (String permission : deniedPermissions) {
            if (source.isShowRationalePermission(permission)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static Setting permissionSetting(android.support.v4.app.Fragment fragment) {
        return AndPermission.with(fragment).runtime().setting();
    }

    @Deprecated
    public static Setting permissionSetting(Fragment fragment) {
        return AndPermission.with(fragment).runtime().setting();
    }

    @Deprecated
    public static Setting permissionSetting(Context context) {
        return AndPermission.with(context).runtime().setting();
    }

    public static boolean hasPermissions(android.support.v4.app.Fragment fragment, String ... permissions) {
        return AndPermission.hasPermissions(fragment.getContext(), permissions);
    }

    public static boolean hasPermissions(Fragment fragment, String ... permissions) {
        return AndPermission.hasPermissions((Context)fragment.getActivity(), permissions);
    }

    public static boolean hasPermissions(Context context, String ... permissions) {
        return PERMISSION_CHECKER.hasPermission(context, permissions);
    }

    public static boolean hasPermissions(android.support.v4.app.Fragment fragment, String[] ... permissions) {
        return AndPermission.hasPermissions(fragment.getContext(), permissions);
    }

    public static boolean hasPermissions(Fragment fragment, String[] ... permissions) {
        return AndPermission.hasPermissions((Context)fragment.getActivity(), permissions);
    }

    public static boolean hasPermissions(Context context, String[] ... permissions) {
        for (String[] permission : permissions) {
            boolean hasPermission = PERMISSION_CHECKER.hasPermission(context, permission);
            if (hasPermission) continue;
            return false;
        }
        return true;
    }

    public static Uri getFileUri(android.support.v4.app.Fragment fragment, File file) {
        return AndPermission.getFileUri(fragment.getContext(), file);
    }

    public static Uri getFileUri(Fragment fragment, File file) {
        return AndPermission.getFileUri((Context)fragment.getActivity(), file);
    }

    public static Uri getFileUri(Context context, File file) {
        if (Build.VERSION.SDK_INT >= 24) {
            return FileProvider.getUriForFile(context, context.getPackageName() + ".file.path.share", file);
        }
        return Uri.fromFile((File)file);
    }

    private AndPermission() {
    }
}

