/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.KeyEvent;
import com.yanzhenjie.permission.overlay.setting.AlertWindowSettingPage;
import com.yanzhenjie.permission.overlay.setting.OverlaySettingPage;
import com.yanzhenjie.permission.runtime.setting.RuntimeSettingPage;
import com.yanzhenjie.permission.source.ContextSource;

public final class PermissionActivity
extends Activity {
    private static final String KEY_INPUT_OPERATION = "KEY_INPUT_OPERATION";
    private static final int VALUE_INPUT_PERMISSION = 1;
    private static final int VALUE_INPUT_PERMISSION_SETTING = 2;
    private static final int VALUE_INPUT_INSTALL = 3;
    private static final int VALUE_INPUT_OVERLAY = 4;
    private static final int VALUE_INPUT_ALERT_WINDOW = 5;
    private static final String KEY_INPUT_PERMISSIONS = "KEY_INPUT_PERMISSIONS";
    private static RequestListener sRequestListener;

    public static void requestPermission(Context context, String[] permissions, RequestListener requestListener) {
        sRequestListener = requestListener;
        Intent intent = new Intent(context, PermissionActivity.class);
        intent.putExtra(KEY_INPUT_OPERATION, 1);
        intent.putExtra(KEY_INPUT_PERMISSIONS, permissions);
        intent.setFlags(0x10000000);
        context.startActivity(intent);
    }

    public static void permissionSetting(Context context, RequestListener requestListener) {
        sRequestListener = requestListener;
        Intent intent = new Intent(context, PermissionActivity.class);
        intent.putExtra(KEY_INPUT_OPERATION, 2);
        intent.setFlags(0x10000000);
        context.startActivity(intent);
    }

    public static void requestInstall(Context context, RequestListener requestListener) {
        sRequestListener = requestListener;
        Intent intent = new Intent(context, PermissionActivity.class);
        intent.putExtra(KEY_INPUT_OPERATION, 3);
        intent.setFlags(0x10000000);
        context.startActivity(intent);
    }

    public static void requestOverlay(Context context, RequestListener requestListener) {
        sRequestListener = requestListener;
        Intent intent = new Intent(context, PermissionActivity.class);
        intent.putExtra(KEY_INPUT_OPERATION, 4);
        intent.setFlags(0x10000000);
        context.startActivity(intent);
    }

    public static void requestAlertWindow(Context context, RequestListener requestListener) {
        sRequestListener = requestListener;
        Intent intent = new Intent(context, PermissionActivity.class);
        intent.putExtra(KEY_INPUT_OPERATION, 5);
        intent.setFlags(0x10000000);
        context.startActivity(intent);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        int operation = intent.getIntExtra(KEY_INPUT_OPERATION, 0);
        switch (operation) {
            case 1: {
                String[] permissions = intent.getStringArrayExtra(KEY_INPUT_PERMISSIONS);
                if (permissions != null && sRequestListener != null) {
                    this.requestPermissions(permissions, 1);
                    break;
                }
                this.finish();
                break;
            }
            case 2: {
                if (sRequestListener != null) {
                    RuntimeSettingPage setting = new RuntimeSettingPage(new ContextSource((Context)this));
                    setting.start(2);
                    break;
                }
                this.finish();
                break;
            }
            case 3: {
                if (sRequestListener != null) {
                    Intent manageIntent = new Intent("android.settings.MANAGE_UNKNOWN_APP_SOURCES");
                    manageIntent.setData(Uri.fromParts((String)"package", (String)this.getPackageName(), null));
                    this.startActivityForResult(manageIntent, 3);
                    break;
                }
                this.finish();
                break;
            }
            case 4: {
                if (sRequestListener != null) {
                    OverlaySettingPage settingPage = new OverlaySettingPage(new ContextSource((Context)this));
                    settingPage.start(4);
                    break;
                }
                this.finish();
                break;
            }
            case 5: {
                if (sRequestListener != null) {
                    AlertWindowSettingPage settingPage = new AlertWindowSettingPage(new ContextSource((Context)this));
                    settingPage.start(5);
                    break;
                }
                this.finish();
                break;
            }
            default: {
                throw new AssertionError((Object)"This should not be the case.");
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (sRequestListener != null) {
            sRequestListener.onRequestCallback();
        }
        this.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (sRequestListener != null) {
            sRequestListener.onRequestCallback();
        }
        this.finish();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public void finish() {
        sRequestListener = null;
        super.finish();
    }

    public static interface RequestListener {
        public void onRequestCallback();
    }
}

