/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.install;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.yanzhenjie.permission.Action;
import com.yanzhenjie.permission.AndPermission;
import com.yanzhenjie.permission.Rationale;
import com.yanzhenjie.permission.RequestExecutor;
import com.yanzhenjie.permission.install.InstallRequest;
import com.yanzhenjie.permission.source.Source;
import java.io.File;

abstract class BaseRequest
implements InstallRequest {
    private Source mSource;
    private File mFile;
    private Rationale<File> mRationale = new Rationale<File>(){

        @Override
        public void showRationale(Context context, File data, RequestExecutor executor) {
            executor.execute();
        }
    };
    private Action<File> mGranted;
    private Action<File> mDenied;

    BaseRequest(Source source) {
        this.mSource = source;
    }

    @Override
    public final InstallRequest file(File file) {
        this.mFile = file;
        return this;
    }

    @Override
    public final InstallRequest rationale(Rationale<File> rationale) {
        this.mRationale = rationale;
        return this;
    }

    @Override
    public final InstallRequest onGranted(Action<File> granted) {
        this.mGranted = granted;
        return this;
    }

    @Override
    public final InstallRequest onDenied(Action<File> denied) {
        this.mDenied = denied;
        return this;
    }

    final void showRationale(RequestExecutor executor) {
        this.mRationale.showRationale(this.mSource.getContext(), null, executor);
    }

    final void install() {
        Intent intent = new Intent("android.intent.action.INSTALL_PACKAGE");
        intent.setFlags(0x10000000);
        intent.addFlags(1);
        Uri uri = AndPermission.getFileUri(this.mSource.getContext(), this.mFile);
        intent.setDataAndType(uri, "application/vnd.android.package-archive");
        this.mSource.startActivity(intent);
    }

    final void callbackSucceed() {
        if (this.mGranted != null) {
            this.mGranted.onAction(this.mFile);
        }
    }

    final void callbackFailed() {
        if (this.mDenied != null) {
            this.mDenied.onAction(this.mFile);
        }
    }
}

