/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.gradle.tasks.download.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;

public class ProgressLoggerWrapper {
    private final Logger logger;
    private final Object progressLogger;

    public ProgressLoggerWrapper(Project project, String src) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> progressLoggerFactoryClass;
        this.logger = project.getLogger();
        try {
            progressLoggerFactoryClass = Class.forName("org.gradle.internal.logging.progress.ProgressLoggerFactory");
        }
        catch (ClassNotFoundException e) {
            progressLoggerFactoryClass = Class.forName("org.gradle.logging.ProgressLoggerFactory");
        }
        Object serviceFactory = ProgressLoggerWrapper.invoke(project, "getServices", new Object[0]);
        Object progressLoggerFactory = ProgressLoggerWrapper.invoke(serviceFactory, "get", progressLoggerFactoryClass);
        this.progressLogger = ProgressLoggerWrapper.invoke(progressLoggerFactory, "newOperation", this.getClass());
        String desc = "Download " + src;
        ProgressLoggerWrapper.invoke(this.progressLogger, "setDescription", desc);
        try {
            ProgressLoggerWrapper.invoke(this.progressLogger, "setLoggingHeader", desc);
        }
        catch (ReflectiveOperationException e) {
            this.logger.lifecycle(desc);
        }
    }

    private static Object invoke(Object obj, String method, Object ... args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class[] argumentTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argumentTypes[i] = args[i].getClass();
        }
        Method m = obj.getClass().getMethod(method, argumentTypes);
        m.setAccessible(true);
        return m.invoke(obj, args);
    }

    private void invokeIgnoreExceptions(Object obj, String method, Object ... args) {
        try {
            ProgressLoggerWrapper.invoke(obj, method, args);
        }
        catch (ReflectiveOperationException e) {
            this.logger.trace("Unable to log progress", (Throwable)e);
        }
    }

    public void started() {
        this.invokeIgnoreExceptions(this.progressLogger, "started", new Object[0]);
    }

    public void completed() {
        this.invokeIgnoreExceptions(this.progressLogger, "completed", new Object[0]);
    }

    public void progress(String msg) {
        this.invokeIgnoreExceptions(this.progressLogger, "progress", msg);
    }
}

