/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.gradle.tasks.download;

import de.undercouch.gradle.tasks.download.DownloadAction;
import de.undercouch.gradle.tasks.download.DownloadSpec;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;

public class DownloadExtension {
    private final ProjectLayout projectLayout;
    private final Logger logger;
    private final Object servicesOwner;
    private final ObjectFactory objectFactory;
    private final boolean isOffline;
    private final File buildDir;

    public DownloadExtension(Project project) {
        this(project, null);
    }

    @Inject
    public DownloadExtension(Task task) {
        this(task.getProject(), task);
    }

    public DownloadExtension(Project project, @Nullable Task task) {
        this(project.getLayout(), project.getLogger(), task != null ? task : project, project.getObjects(), project.getGradle().getStartParameter().isOffline(), (File)project.getLayout().getBuildDirectory().getAsFile().get());
    }

    private DownloadExtension(ProjectLayout projectLayout, Logger logger, Object servicesOwner, ObjectFactory objectFactory, boolean isOffline, File buildDir) {
        this.projectLayout = projectLayout;
        this.logger = logger;
        this.servicesOwner = servicesOwner;
        this.objectFactory = objectFactory;
        this.isOffline = isOffline;
        this.buildDir = buildDir;
    }

    public void run(Action<DownloadSpec> action) {
        DownloadAction da = new DownloadAction(this.projectLayout, this.logger, this.servicesOwner, this.objectFactory, this.isOffline, this.buildDir);
        action.execute((Object)da);
        try {
            da.execute(false).get();
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                message = "Could not download file";
            }
            throw new IllegalStateException(message, e);
        }
    }

    public CompletableFuture<Void> runAsync(Action<DownloadSpec> action) {
        DownloadAction da = new DownloadAction(this.projectLayout, this.logger, this.servicesOwner, this.objectFactory, this.isOffline, this.buildDir);
        action.execute((Object)da);
        try {
            return da.execute(false);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                message = "Could not download file";
            }
            throw new IllegalStateException(message, e);
        }
    }
}

