/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.gradle.tasks.download.internal;

import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.EntityDetails;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.Header;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpRequest;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpRequestInterceptor;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.protocol.HttpContext;
import java.util.Map;

public class StripPortsFromHostInterceptor
implements HttpRequestInterceptor {
    private final Map<String, String> headers;

    public StripPortsFromHostInterceptor(Map<String, String> headers) {
        this.headers = headers;
    }

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) {
        if (this.headers != null && this.headers.containsKey("Host")) {
            return;
        }
        Header host = request.getFirstHeader("Host");
        String strHost = host.getValue();
        String scheme = request.getScheme();
        if (scheme.equals("http") && strHost.endsWith(":80")) {
            request.setHeader("Host", strHost.substring(0, strHost.length() - 3));
        } else if (scheme.equals("https") && strHost.endsWith(":443")) {
            request.setHeader("Host", strHost.substring(0, strHost.length() - 4));
        }
    }
}

