/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.multimedia.audiokit.interfaces;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.huawei.multimedia.audioengine.IHwAudioKaraokeFeature;
import com.huawei.multimedia.audiokit.interfaces.AudioFeaturesKit;
import com.huawei.multimedia.audiokit.interfaces.FeatureKitManager;
import com.huawei.multimedia.audiokit.utils.LogUtils;

public class HwAudioKaraokeFeatureKit
extends AudioFeaturesKit {
    private static final String TAG = "HwAudioKit.HwAudioKaraokeFeatureKit";
    private static final String ENGINE_CLASS_NAME = "com.huawei.multimedia.audioengine.HwAudioKaraokeFeatureService";
    private Context mContext;
    private FeatureKitManager mFeatureKitManager = null;
    private boolean mIsServiceConnected = false;
    private IHwAudioKaraokeFeature mIHwAudioKaraokeFeatureAidl;
    private IBinder mService = null;
    private ServiceConnection mConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            LogUtils.info(HwAudioKaraokeFeatureKit.TAG, "onServiceConnected");
            HwAudioKaraokeFeatureKit.this.mIHwAudioKaraokeFeatureAidl = IHwAudioKaraokeFeature.Stub.asInterface(service);
            if (HwAudioKaraokeFeatureKit.this.mIHwAudioKaraokeFeatureAidl != null) {
                HwAudioKaraokeFeatureKit.this.mIsServiceConnected = true;
                HwAudioKaraokeFeatureKit.this.mFeatureKitManager.onCallBack(1000);
                HwAudioKaraokeFeatureKit.this.serviceInit(HwAudioKaraokeFeatureKit.this.mContext.getPackageName());
                HwAudioKaraokeFeatureKit.this.serviceLinkToDeath(service);
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            LogUtils.info(HwAudioKaraokeFeatureKit.TAG, "onServiceDisconnected");
            HwAudioKaraokeFeatureKit.this.mIsServiceConnected = false;
            if (HwAudioKaraokeFeatureKit.this.mFeatureKitManager != null) {
                HwAudioKaraokeFeatureKit.this.mFeatureKitManager.onCallBack(1001);
            }
        }
    };
    private IBinder.DeathRecipient mDeathRecipient = new IBinder.DeathRecipient(){

        public void binderDied() {
            LogUtils.error(HwAudioKaraokeFeatureKit.TAG, "binderDied");
            HwAudioKaraokeFeatureKit.this.mService.unlinkToDeath(HwAudioKaraokeFeatureKit.this.mDeathRecipient, 0);
            HwAudioKaraokeFeatureKit.this.mFeatureKitManager.onCallBack(1003);
            HwAudioKaraokeFeatureKit.this.mService = null;
        }
    };

    protected HwAudioKaraokeFeatureKit(Context context) {
        this.mFeatureKitManager = FeatureKitManager.getInstance();
        this.mContext = context;
    }

    private void serviceLinkToDeath(IBinder service) {
        this.mService = service;
        try {
            if (service != null) {
                service.linkToDeath(this.mDeathRecipient, 0);
            }
        }
        catch (RemoteException e) {
            this.mFeatureKitManager.onCallBack(1002);
            LogUtils.error(TAG, "serviceLinkToDeath, RemoteException");
        }
    }

    protected void initialize(Context context) {
        LogUtils.info(TAG, "initialize");
        if (context == null) {
            LogUtils.info(TAG, "initialize, context is null");
            return;
        }
        if (!this.mFeatureKitManager.isMediaKitSupport(context)) {
            this.mFeatureKitManager.onCallBack(2);
            LogUtils.info(TAG, "initialize, not install AudioEngine");
            return;
        }
        this.bindService(context);
    }

    private void bindService(Context context) {
        LogUtils.info(TAG, "bindService");
        if (this.mFeatureKitManager != null && !this.mIsServiceConnected) {
            this.mFeatureKitManager.bindService(context, this.mConnection, ENGINE_CLASS_NAME);
        }
    }

    public void destroy() {
        LogUtils.info(TAG, "destroy, mIsServiceConnected = {}", this.mIsServiceConnected);
        if (this.mIsServiceConnected) {
            this.mIsServiceConnected = false;
            this.mFeatureKitManager.unbindService(this.mContext, this.mConnection);
        }
    }

    public boolean isKaraokeFeatureSupport() {
        LogUtils.info(TAG, "isKaraokeFeatureSupport");
        try {
            if (this.mIHwAudioKaraokeFeatureAidl != null && this.mIsServiceConnected) {
                return this.mIHwAudioKaraokeFeatureAidl.isKaraokeFeatureSupport();
            }
        }
        catch (RemoteException ex) {
            LogUtils.error(TAG, "isFeatureSupported,RemoteException ex : {}", ex.getMessage());
        }
        return false;
    }

    public int enableKaraokeFeature(boolean enable) {
        LogUtils.info(TAG, "enableKaraokeFeature, enable = {}", enable);
        try {
            if (this.mIHwAudioKaraokeFeatureAidl != null && this.mIsServiceConnected) {
                return this.mIHwAudioKaraokeFeatureAidl.enableKaraokeFeature(enable);
            }
        }
        catch (RemoteException ex) {
            LogUtils.error(TAG, "enableKaraokeFeature,RemoteException ex : {}", ex.getMessage());
        }
        return -2;
    }

    public int getKaraokeLatency() {
        LogUtils.info(TAG, "getKaraokeLatency");
        try {
            if (this.mIHwAudioKaraokeFeatureAidl != null && this.mIsServiceConnected) {
                return this.mIHwAudioKaraokeFeatureAidl.getKaraokeLatency();
            }
        }
        catch (RemoteException ex) {
            LogUtils.error(TAG, "getKaraokeLatency,RemoteException ex : {}", ex.getMessage());
        }
        return -1;
    }

    public int setParameter(ParameName param, int value) {
        try {
            LogUtils.info(TAG, "parame.getParameName() = {}, parameValue = {}", param.getParameName(), value);
            if (this.mIHwAudioKaraokeFeatureAidl != null && this.mIsServiceConnected) {
                return this.mIHwAudioKaraokeFeatureAidl.setParameter(param.getParameName(), value);
            }
        }
        catch (RemoteException ex) {
            LogUtils.error(TAG, "setParameter,RemoteException ex : {}", ex.getMessage());
        }
        return -2;
    }

    private void serviceInit(String packageName) {
        try {
            if (this.mIHwAudioKaraokeFeatureAidl != null && this.mIsServiceConnected) {
                this.mIHwAudioKaraokeFeatureAidl.init(packageName);
            }
        }
        catch (RemoteException ex) {
            LogUtils.error(TAG, "isFeatureSupported,RemoteException ex : {}", ex.getMessage());
        }
    }

    public static enum ParameName {
        CMD_SET_AUDIO_EFFECT_MODE_BASE("Karaoke_reverb_mode="),
        CMD_SET_VOCAL_VOLUME_BASE("Karaoke_volume="),
        CMD_SET_VOCAL_EQUALIZER_MODE("Karaoke_eq_mode=");

        private String mParameName;

        private ParameName(String parameName) {
            this.mParameName = parameName;
        }

        public String getParameName() {
            return this.mParameName;
        }
    }
}

