/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.audio;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioRecordingConfiguration;
import android.media.AudioTimestamp;
import android.media.AudioTrack;
import android.media.MediaRouter;
import android.media.audiofx.AcousticEchoCanceler;
import android.os.Build;
import android.os.LocaleList;
import android.os.Process;
import android.util.DisplayMetrics;
import io.agora.rtc.audio.HardwareEarbackController;
import io.agora.rtc.audio.VolumeBroadcastReceiver;
import io.agora.rtc.internal.Logging;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.locks.ReentrantLock;

class AudioDevice {
    final String TAG = "AudioDevice Java";
    private final int _MaxRecPlay10msBlocks = 4;
    private AudioTrack _audioTrack = null;
    private AudioRecord _audioRecord = null;
    private Context _context;
    private AudioManager _audioManager;
    private ByteBuffer _playBuffer;
    private ByteBuffer _recBuffer;
    private byte[] _tempBufPlay;
    private byte[] _tempBufRec;
    private final ReentrantLock _playLock = new ReentrantLock();
    private final ReentrantLock _recLock = new ReentrantLock();
    private boolean _doPlayInit = true;
    private boolean _doRecInit = true;
    private boolean _isRecording = false;
    private boolean _isPlaying = false;
    private long previous_time_ms = 0L;
    private long current_time_ms = 0L;
    private long _currentTotalPostion = 0L;
    private long _framePostion = 0L;
    private int _bufferedRecSamples = 0;
    private int _bufferedPlaySamples = 0;
    private int _playPosition = 0;
    private int _playbackSampleRate = 0;
    private int _playBufSize = 0;
    private int _playbackRestartCount = 0;
    private int _recordSampleRate = 0;
    private int _recordChannel = 0;
    private int _playChannel = 0;
    private int _recordBufSize = 0;
    private int _recordSource = 0;
    private int _recordRestartCount = 0;
    private boolean _renderStart = false;
    private long _firstRenderTS = 0L;
    private int _playPreviousUnderrun = 0;
    private long _recDelay = 10L;
    private long _lastRecDelay = 0L;
    private long _recStartTS = 0L;
    private int _recStartDelay = 0;
    private int _sdkVer = Build.VERSION.SDK_INT;
    private long _recPosition = 0L;
    private long[] _audioStatistic = new long[6];
    private final int POSITION_PLAY_APP = 0;
    private final int POSITION_PLAY_SYS = 1;
    private final int LAST_WRITE_TIME = 2;
    private final int POSITION_REC_APP = 3;
    private final int POSITION_REC_SYS = 4;
    private final int LAST_READ_TIME = 5;
    private AcousticEchoCanceler aec = null;
    private boolean useBuiltInAEC = false;
    private int _streamType = 0;
    private int playWriten = 0;
    private int maxDelay = 0;
    private int totalDelay = 0;
    private long mNativeHandle = 0L;
    private int currentPlayoutVolume = -1;
    private VolumeBroadcastReceiver mVolumeBroadcastReceiver = null;
    private static final String VOLUME_CHANGED_ACTION = "android.media.VOLUME_CHANGED_ACTION";

    AudioDevice(long l) {
        this.mNativeHandle = l;
        try {
            this._playBuffer = ByteBuffer.allocateDirect(7680);
            this._recBuffer = ByteBuffer.allocateDirect(7680);
        }
        catch (Exception exception) {
            Logging.e("AudioDevice Java", "failed to allocate bytebuffer", exception);
        }
        this._tempBufPlay = new byte[7680];
        this._tempBufRec = new byte[7680];
    }

    private boolean BuiltInAECIsAvailable() {
        try {
            if (Build.VERSION.SDK_INT >= 17) {
                return AcousticEchoCanceler.isAvailable();
            }
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            Logging.e("AudioDevice Java", "Unable to create AEC object ", exceptionInInitializerError);
        }
        catch (Exception exception) {
            Logging.e("AudioDevice Java", "Unable to query Audio Effect: Acoustic Echo Cancellation");
        }
        return false;
    }

    private int GetPreferedSampleRate() {
        int n = 0;
        try {
            if (this._audioManager == null && this._context != null) {
                this._audioManager = (AudioManager)this._context.getSystemService("audio");
            }
            String string = this._audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            Logging.e("AudioDevice Java", "GetPreferedSampleRate error", exception);
        }
        if (n == 0) {
            n = 16000;
        }
        return n;
    }

    private boolean EnableBuiltInAEC(boolean bl) {
        if (Build.VERSION.SDK_INT <= 18) {
            return false;
        }
        this.useBuiltInAEC = bl;
        if (this.aec != null) {
            int n = this.aec.setEnabled(bl);
            if (n != 0) {
                Logging.e("AudioDevice Java", "AcousticEchoCanceler.setEnabled failed");
                return false;
            }
            Logging.e("AudioDevice Java", "AcousticEchoCanceler.getEnabled: " + this.aec.getEnabled());
        }
        return true;
    }

    private boolean BuiltInAECIsEnabled() {
        return this.useBuiltInAEC;
    }

    private int InitRecording(int n, int n2, int n3) {
        AudioFormat audioFormat;
        this._recLock.lock();
        int n4 = AudioRecord.getMinBufferSize((int)n2, (int)(n3 == 2 ? 12 : 16), (int)2);
        Logging.d("AudioDevice Java", "Java minimum recording buffer size is " + n4);
        int n5 = n4;
        this._bufferedRecSamples = 5 * n2 / 200;
        if (this.aec != null) {
            this.aec.release();
            this.aec = null;
        }
        if (this._audioRecord != null) {
            this._audioRecord.release();
            this._audioRecord = null;
        }
        try {
            if (Build.VERSION.SDK_INT < 31) {
                this._audioRecord = new AudioRecord(n, n2, n3 == 2 ? 12 : 16, 2, n5);
            } else {
                audioFormat = new AudioFormat.Builder().setSampleRate(n2).setEncoding(2).setChannelMask(n3 == 2 ? 12 : 16).build();
                AudioRecord.Builder builder = new AudioRecord.Builder();
                builder.setAudioFormat(audioFormat);
                builder.setBufferSizeInBytes(n5);
                if (this._context != null) {
                    builder.setContext(this._context);
                }
                this._audioRecord = builder.build();
            }
        }
        catch (Exception exception) {
            Logging.e("AudioDevice Java", "Unable to new AudioRecord: ", exception);
            this._recLock.unlock();
            return -1;
        }
        if (this._audioRecord.getState() != 1) {
            Logging.e("AudioDevice Java", "Java recording not initialized " + n2);
            this._recLock.unlock();
            return -2;
        }
        this._recordSampleRate = n2;
        this._recordChannel = n3;
        this._recordSource = n;
        this._recordBufSize = n5;
        this._recordRestartCount = 0;
        Logging.d("AudioDevice Java", "Java recording sample rate set to " + n2);
        Logging.d("AudioDevice Java", "AcousticEchoCanceler.isAvailable: " + this.BuiltInAECIsAvailable());
        if (!this.BuiltInAECIsAvailable()) {
            this._recLock.unlock();
            return this._bufferedRecSamples;
        }
        this.aec = AcousticEchoCanceler.create((int)this._audioRecord.getAudioSessionId());
        if (this.aec == null) {
            Logging.e("AudioDevice Java", "AcousticEchoCanceler.create failed");
        } else {
            audioFormat = this.aec.getDescriptor();
            if (null == audioFormat) {
                Logging.e("AudioDevice Java", "getDescriptor() failed");
            } else {
                Logging.d("AudioDevice Java", "AcousticEchoCanceler name: " + audioFormat.name + ", implementor: " + audioFormat.implementor + ", uuid: " + audioFormat.uuid);
            }
            this.EnableBuiltInAEC(this.useBuiltInAEC);
        }
        this._recLock.unlock();
        return this._bufferedRecSamples;
    }

    private int StartRecording() {
        this._recLock.lock();
        try {
            if (this._audioRecord == null) {
                int n = -2;
                return n;
            }
            this._audioRecord.startRecording();
            Logging.e("AudioDevice Java", "Recording start time " + System.nanoTime());
            this._recStartTS = System.nanoTime();
            this._recStartDelay = 0;
            this._recDelay = 10L;
            this._isRecording = true;
            this._recPosition = 0L;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e("AudioDevice Java", "failed to startRecording", illegalStateException);
            int n = -1;
            return n;
        }
        catch (Exception exception) {
            Logging.e("AudioDevice Java", "failed to startRecording Exception", exception);
            int n = -2;
            return n;
        }
        finally {
            this._recLock.unlock();
        }
        return 0;
    }

    private int CheckAudioStatus(int n) {
        int n2 = 0;
        if (Build.VERSION.SDK_INT >= 24) {
            if (this._audioManager == null) {
                if (this._context != null) {
                    this._audioManager = (AudioManager)this._context.getSystemService("audio");
                } else {
                    Logging.e("AudioDevice Java", "CheckAudioStatus error");
                    return -1;
                }
            }
            if (n == 0) {
                if (this._context.checkPermission("android.permission.RECORD_AUDIO", Process.myPid(), Process.myUid()) != 0 || this._context.checkPermission("android.permission.MODIFY_AUDIO_SETTINGS", Process.myPid(), Process.myUid()) != 0) {
                    n2 = 2;
                    Logging.e("AudioDevice Java", "CheckAudioStatus Microphone Permission denied");
                    return n2;
                }
                if (this._audioManager != null) {
                    int n3 = -1;
                    if (this._audioRecord != null) {
                        n3 = this._audioRecord.getAudioSessionId();
                    }
                    List list = this._audioManager.getActiveRecordingConfigurations();
                    for (AudioRecordingConfiguration audioRecordingConfiguration : list) {
                        if (audioRecordingConfiguration.getClientAudioSessionId() == n3) continue;
                        n2 = 1033;
                    }
                } else {
                    Logging.e("AudioDevice Java", "CheckAudioStatus unkonwn error");
                    return -1;
                }
            }
        }
        return n2;
    }

    private int InitPlayback(int n, int n2, int n3, int n4) {
        this._playLock.lock();
        this._streamType = n3;
        int n5 = n4 * n * n2 * 2 / 1000;
        int n6 = AudioTrack.getMinBufferSize((int)n, (int)(n2 == 2 ? 12 : 4), (int)2);
        Logging.d("AudioDevice Java", "Java minimum playback buffer size is " + n6 + ", profiledMiniOutBufferSize is " + n5 + " stream type " + this._streamType);
        int n7 = n6;
        if (n7 < n5) {
            n7 = n5;
        }
        this._bufferedPlaySamples = 0;
        this._currentTotalPostion = 0L;
        Logging.d("AudioDevice Java", "Java playback buffer size is " + n7 + ", duration is " + n7 * 1000 / (n * n2 * 2) + " ms");
        if (this._audioTrack != null) {
            this._audioTrack.release();
            this._audioTrack = null;
        }
        try {
            this._audioTrack = new AudioTrack(this._streamType, n, n2 == 2 ? 12 : 4, 2, n7, 1);
        }
        catch (Exception exception) {
            Logging.e("AudioDevice Java", "Unable to new AudioTrack: ", exception);
            this._playLock.unlock();
            return -1;
        }
        this._playbackSampleRate = n;
        this._playChannel = n2;
        this._playBufSize = n7;
        this._playbackRestartCount = 0;
        if (this._audioTrack.getState() != 1) {
            Logging.e("AudioDevice Java", "Java playback not initialized " + n);
            this._playLock.unlock();
            return -1;
        }
        Logging.d("AudioDevice Java", "Java play sample rate is set to " + n);
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        if (this._audioManager == null) {
            this._playLock.unlock();
            return 0;
        }
        this._playLock.unlock();
        return this._audioManager.getStreamMaxVolume(this._streamType);
    }

    private int StartPlayback() {
        this._playLock.lock();
        this._firstRenderTS = 0L;
        this._renderStart = false;
        try {
            this.playWriten = 0;
            this._playBuffer.rewind();
            this._audioTrack.play();
            this.maxDelay = 0;
            this.totalDelay = 0;
            this._isPlaying = true;
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
            int n = -1;
            return n;
        }
        catch (Exception exception) {
            Logging.e("AudioDevice Java", "startplayback fail", exception);
            int n = -1;
            return n;
        }
        finally {
            this._playLock.unlock();
        }
        this.monitorPlayoutVolumeChange(true);
        this.notifyPlayoutVolumeChange();
        return 0;
    }

    private int StopRecording() {
        this._recLock.lock();
        try {
            if (this._audioRecord != null && this._audioRecord.getRecordingState() == 3) {
                this._audioRecord.stop();
            }
            if (this.aec != null) {
                this.aec.release();
                this.aec = null;
            }
            this._isRecording = false;
        }
        catch (Exception exception) {
            Logging.e("AudioDevice Java", "error in StopRecording ", exception);
        }
        finally {
            if (this._audioRecord != null) {
                this._audioRecord.release();
                this._audioRecord = null;
            }
            this._doRecInit = true;
            this._recLock.unlock();
        }
        return 0;
    }

    private int StopPlayback() {
        this._firstRenderTS = 0L;
        this._isPlaying = false;
        this._playLock.lock();
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                this._audioTrack.setVolume(0.0f);
            } else {
                this._audioTrack.setStereoVolume(0.0f, 0.0f);
            }
            if (this._audioTrack.getPlayState() == 3) {
                this._audioTrack.stop();
                this._audioTrack.flush();
            }
            this._audioTrack.release();
            this._audioTrack = null;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e("AudioDevice Java", "Unable to stop playback: ", illegalStateException);
            int n = -1;
            return n;
        }
        catch (Exception exception) {
            Logging.e("AudioDevice Java", "Stop playback fail", exception);
        }
        finally {
            if (this._audioTrack != null) {
                this._audioTrack.flush();
                this._audioTrack.release();
                this._audioTrack = null;
            }
            this._doPlayInit = true;
            this._playLock.unlock();
        }
        this.monitorPlayoutVolumeChange(false);
        return 0;
    }

    private int getPlayBufferMs() {
        if (this._playbackSampleRate == 0 || this._playChannel == 0) {
            return 10;
        }
        int n = this._playBufSize / (2 * this._playChannel);
        int n2 = n * 1000 / this._playbackSampleRate;
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int PlayNoBlockAudio(int n) {
        int n2 = 0;
        if (Build.VERSION.SDK_INT < 23) {
            Logging.e("AudioDevice Java", "Play failed,  SDK_INT " + Build.VERSION.SDK_INT);
            return -2;
        }
        this._playLock.lock();
        try {
            int n3;
            if (this._audioTrack == null) {
                Logging.e("AudioDevice Java", "Play failed, _audioTrack == null ");
                int n4 = -2;
                return n4;
            }
            if (this._doPlayInit) {
                try {
                    Process.setThreadPriority((int)-19);
                }
                catch (Exception exception) {
                    Logging.e("AudioDevice Java", "Set play thread priority failed: ", exception);
                }
                this._doPlayInit = false;
                this.previous_time_ms = System.nanoTime() / 1000L / 1000L;
            }
            int n5 = 0;
            int n6 = 0;
            int n7 = n;
            this._playBuffer.get(this._tempBufPlay);
            while (this._isPlaying) {
                int n8;
                n6 = this._audioTrack.write(this._tempBufPlay, n5, n7, 1);
                if (n6 < 0) {
                    if (this._playbackRestartCount > 20) {
                        n8 = n5;
                        return n8;
                    }
                    Logging.e("AudioDevice Java", "Error writing AudioTrack! Restart AudioTrack " + n5);
                    ++this._playbackRestartCount;
                    this._audioTrack.stop();
                    this._audioTrack.release();
                    this._audioTrack = null;
                    try {
                        this._audioTrack = new AudioTrack(this._streamType, this._playbackSampleRate, this._playChannel == 2 ? 12 : 4, 2, this._playBufSize, 1);
                        this._audioTrack.play();
                    }
                    catch (Exception exception) {
                        Logging.e("AudioDevice Java", "restart audio fail", exception);
                    }
                    int n9 = n5;
                    return n9;
                }
                if ((n5 += n6) == n) break;
                if (n6 < n7) {
                    n8 = this.getPlayBufferMs() / 3;
                    Thread.sleep(n8);
                }
                n7 = n - n5;
            }
            this._bufferedPlaySamples += n5 >> 1;
            this.playWriten += n5;
            this._currentTotalPostion += (long)((n5 >> 1) / this._playChannel);
            if (Build.VERSION.SDK_INT >= 24) {
                this.current_time_ms = System.nanoTime() / 1000L / 1000L;
                if (this.current_time_ms - this.previous_time_ms >= 50L) {
                    AudioTimestamp audioTimestamp = new AudioTimestamp();
                    this._audioTrack.getTimestamp(audioTimestamp);
                    this._framePostion = audioTimestamp.framePosition;
                    this._bufferedPlaySamples = this.current_time_ms - this.previous_time_ms > 65L ? (int)(this._currentTotalPostion - (long)(this._playPosition / this._playChannel)) : (int)(this._currentTotalPostion - this._framePostion);
                    this.previous_time_ms = audioTimestamp.nanoTime / 1000L / 1000L;
                }
            }
            if ((n3 = this._audioTrack.getPlaybackHeadPosition() * this._playChannel) < this._playPosition) {
                this._playPosition = 0;
            }
            this._playPosition = n3;
            this._audioStatistic[0] = this._currentTotalPostion * 1000L / (long)this._playbackSampleRate;
            this._audioStatistic[1] = (long)this._playPosition * 1000L / (long)this._playbackSampleRate;
            this._audioStatistic[2] = System.nanoTime() / 1000L / 1000L;
            if (!this._isRecording) {
                n2 = this._bufferedPlaySamples;
            }
        }
        catch (Exception exception) {
            Logging.e("AudioDevice Java", "PlayNBAudio got fatal error ", exception);
        }
        finally {
            this._playBuffer.rewind();
            this._playLock.unlock();
        }
        return this._bufferedPlaySamples * this._playChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int PlayAudio(int n) {
        block20: {
            int n2 = 0;
            this._playLock.lock();
            try {
                int n3;
                if (this._audioTrack == null) {
                    int n4 = -2;
                    return n4;
                }
                if (!this._isPlaying) {
                    Logging.w("AudioDevice Java", "PlayAudio not ready!");
                    int n5 = 0;
                    return n5;
                }
                if (this._doPlayInit) {
                    try {
                        Process.setThreadPriority((int)-19);
                    }
                    catch (Exception exception) {
                        Logging.e("AudioDevice Java", "Set play thread priority failed: ", exception);
                    }
                    this._doPlayInit = false;
                    this.previous_time_ms = System.nanoTime() / 1000L / 1000L;
                }
                int n6 = 0;
                this._playBuffer.get(this._tempBufPlay);
                n6 = this._audioTrack.write(this._tempBufPlay, 0, n);
                this._playBuffer.rewind();
                this._bufferedPlaySamples += n6 >> 1;
                this.playWriten += n6;
                this._currentTotalPostion += (long)((n6 >> 1) / this._playChannel);
                if (Build.VERSION.SDK_INT >= 24) {
                    this.current_time_ms = System.nanoTime() / 1000L / 1000L;
                    if (this.current_time_ms - this.previous_time_ms >= 50L) {
                        AudioTimestamp audioTimestamp = new AudioTimestamp();
                        this._audioTrack.getTimestamp(audioTimestamp);
                        this._framePostion = audioTimestamp.framePosition;
                        this._bufferedPlaySamples = this.current_time_ms - this.previous_time_ms > 65L ? (int)(this._currentTotalPostion - (long)(this._playPosition / this._playChannel)) : (int)(this._currentTotalPostion - this._framePostion);
                        this.previous_time_ms = audioTimestamp.nanoTime / 1000L / 1000L;
                    }
                }
                if ((n3 = this._audioTrack.getPlaybackHeadPosition() * this._playChannel) < this._playPosition) {
                    this._playPosition = 0;
                }
                this._playPosition = n3;
                this._audioStatistic[0] = this._currentTotalPostion * 1000L / (long)this._playbackSampleRate;
                this._audioStatistic[1] = (long)this._playPosition * 1000L / (long)this._playbackSampleRate;
                this._audioStatistic[2] = System.nanoTime() / 1000L / 1000L;
                if (!this._isRecording) {
                    n2 = this._bufferedPlaySamples;
                }
                if (n6 == n) break block20;
                if (this._playbackRestartCount > 20) {
                    int n7 = n6;
                    return n7;
                }
                Logging.e("AudioDevice Java", "Error writing AudioTrack! Restart AudioTrack " + this._playbackRestartCount);
                ++this._playbackRestartCount;
                this._audioTrack.stop();
                this._audioTrack.release();
                this._audioTrack = null;
                try {
                    this._audioTrack = new AudioTrack(this._streamType, this._playbackSampleRate, this._playChannel == 2 ? 12 : 4, 2, this._playBufSize, 1);
                    this._audioTrack.play();
                }
                catch (Exception exception) {
                    Logging.e("AudioDevice Java", "restart audio fail", exception);
                }
                int n8 = n6;
                return n8;
            }
            catch (Exception exception) {
                Logging.e("AudioDevice Java", "PlayAudio got fatal error ", exception);
            }
            finally {
                this._playLock.unlock();
            }
        }
        return this._bufferedPlaySamples * this._playChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int RecordAudio(int n) {
        this._recLock.lock();
        int n2 = 0;
        try {
            if (!this._isRecording) {
                Logging.w("AudioDevice Java", "RecordAudio not ready!");
                int n3 = 0;
                return n3;
            }
            if (this._audioRecord == null) {
                int n4 = -4;
                return n4;
            }
            if (this._doRecInit) {
                try {
                    Process.setThreadPriority((int)-19);
                }
                catch (Exception exception) {
                    Logging.e("AudioDevice Java", "Set rec thread priority failed: ", exception);
                }
                this._doRecInit = false;
            }
            int n5 = 0;
            this._recBuffer.rewind();
            n5 = this._audioRecord.read(this._tempBufRec, 0, n);
            if (n5 != n) {
                if (this._recordRestartCount > 0 && this._audioRecord != null) {
                    Logging.e("AudioDevice Java", "audioRecord.read retry failed!  ");
                    this._audioRecord.release();
                    this._audioRecord = null;
                    int n6 = -20;
                    return n6;
                }
                if (this._recordRestartCount == 0) {
                    Logging.e("AudioDevice Java", "Retry audioRecord for read failed:  " + n5);
                    try {
                        this._audioRecord = new AudioRecord(this._recordSource, this._recordSampleRate, this._recordChannel == 2 ? 12 : 16, 2, this._recordBufSize);
                        this._audioRecord.startRecording();
                    }
                    catch (Exception exception) {
                        Logging.e("AudioDevice Java", "Retry audioRecord created failed: ", exception);
                    }
                    this._recStartTS = System.nanoTime();
                    this._recStartDelay = 0;
                }
                ++this._recordRestartCount;
                int n7 = n5;
                return n7;
            }
            this._recordRestartCount = 0;
            this._recBuffer.put(this._tempBufRec);
            if (this._recDelay == 10L) {
                if (Build.VERSION.SDK_INT >= 24) {
                    AudioTimestamp audioTimestamp = new AudioTimestamp();
                    this._audioRecord.getTimestamp(audioTimestamp, 0);
                    this._recDelay = (System.nanoTime() - audioTimestamp.nanoTime) / 1000L / 1000L;
                    if (this._recDelay > 50L) {
                        this._recDelay = 10L;
                    }
                } else {
                    this._recDelay = 10L;
                }
                if (this._recStartDelay == 0) {
                    this._recStartDelay = (int)(System.nanoTime() - this._recStartTS) / 1000 / 1000;
                }
                this._recDelay += (long)this._recStartDelay;
            }
            if (this._lastRecDelay != this._recDelay) {
                if (Build.VERSION.SDK_INT >= 23) {
                    int n8 = this._audioRecord.getBufferSizeInFrames();
                    Logging.i("AudioDevice Java", "frames  " + n8 + " recDelay " + this._recDelay + " caculated frames delay " + n8 / (this._audioRecord.getSampleRate() / 1000));
                } else {
                    Logging.i("AudioDevice Java", "_recDelay: " + this._recDelay);
                }
                this._lastRecDelay = this._recDelay;
            }
            if (n5 >= 0) {
                this._recPosition += (long)(n5 / this._recordChannel / 2);
            }
            this._audioStatistic[3] = this._recPosition * 1000L / (long)this._recordSampleRate;
            this._audioStatistic[5] = System.nanoTime() / 1000L / 1000L;
            this._recordRestartCount = 0;
        }
        catch (Exception exception) {
            n2 = -10;
            this._audioRecord = null;
            Logging.e("AudioDevice Java", "RecordAudio try failed: ", exception);
        }
        finally {
            this._recLock.unlock();
        }
        return n2;
    }

    private int GetUnderrunCount() {
        if (Build.VERSION.SDK_INT >= 24) {
            return this.GetUnderrunCountOnNougatOrHigher();
        }
        return this.GetUnderrunCountOnLowerThanNougat();
    }

    @TargetApi(value=24)
    private int GetUnderrunCountOnNougatOrHigher() {
        int n = 0;
        int n2 = 0;
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                n2 = this._audioTrack.getUnderrunCount();
            }
            catch (Exception exception) {
                Logging.e("AudioDevice Java", "getUnderrun fail ", exception);
            }
            n = n2 - this._playPreviousUnderrun;
            if (n < 0) {
                n = 0;
            }
            this._playPreviousUnderrun = n2;
            if (n > 0) {
                Logging.d("AudioDevice Java", "Android AudioTrack underrun count: " + n);
            }
        }
        return n;
    }

    private int GetUnderrunCountOnLowerThanNougat() {
        return -1;
    }

    private int QuerySpeakerStatus() {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                MediaRouter mediaRouter = (MediaRouter)this._context.getSystemService("media_router");
                MediaRouter.RouteInfo routeInfo = mediaRouter.getSelectedRoute(1);
                routeInfo.getName().toString().compareToIgnoreCase("phone");
                Configuration configuration = this._context.getResources().getConfiguration();
                LocaleList localeList = configuration.getLocales();
                DisplayMetrics displayMetrics = this._context.getResources().getDisplayMetrics();
                configuration.setLocale(Locale.ENGLISH);
                int n = -1;
                this._context.getResources().updateConfiguration(configuration, displayMetrics);
                if (routeInfo.getName(this._context).toString().compareToIgnoreCase("phone") == 0) {
                    Logging.e("AudioDevice Java", "speaker");
                } else if (routeInfo.getName(this._context).toString().compareToIgnoreCase("headset") == 0) {
                    Logging.e("AudioDevice Java", "headset");
                    n = 0;
                } else if (routeInfo.getName(this._context).toString().compareToIgnoreCase("bluetooth") == 0) {
                    Logging.e("AudioDevice Java", "bluetooth");
                    n = 5;
                }
                configuration.setLocales(localeList);
                this._context.getResources().updateConfiguration(configuration, displayMetrics);
                if (n != -1) {
                    return n;
                }
            }
        }
        catch (Exception exception) {
            Logging.e("error in Query audio route ");
            exception.printStackTrace();
        }
        if (this._audioManager == null) {
            Logging.e("AudioDevice Java", "Could not get audio routing - no audio manager");
            return -1;
        }
        if (this._audioManager.isBluetoothA2dpOn()) {
            return 5;
        }
        if (this._audioManager.isSpeakerphoneOn()) {
            return 3;
        }
        if (this._audioManager.isBluetoothScoOn()) {
            return 5;
        }
        if (this._audioManager.isWiredHeadsetOn()) {
            return 0;
        }
        return 1;
    }

    private int SetPlayoutSpeaker(boolean bl) {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        if (this._audioManager == null) {
            Logging.e("AudioDevice Java", "Could not change audio routing - no audio manager");
            return -1;
        }
        this._audioManager.setSpeakerphoneOn(bl);
        return 0;
    }

    private int SetPlayoutVolume(int n) {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        int n2 = -1;
        if (this._audioManager != null) {
            int n3 = this._audioManager.getStreamMaxVolume(this._streamType);
            n = n >= 255 ? n3 : n * n3 / 255;
            this._audioManager.setStreamVolume(this._streamType, n, 0);
            n2 = 0;
        }
        return n2;
    }

    private int GetPlayoutVolume() {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        int n = -1;
        try {
            if (this._audioManager != null) {
                n = this._audioManager.getStreamVolume(this._streamType);
            }
        }
        catch (Exception exception) {
            Logging.e("AudioDevice Java", "getStreamVolume failed! ");
        }
        return n;
    }

    private int GetPlayoutMaxVolume() {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        int n = -1;
        if (this._audioManager != null) {
            n = this._audioManager.getStreamMaxVolume(this._streamType);
        }
        return n;
    }

    private int SetAudioMode(int n) {
        try {
            if (this._audioManager == null && this._context != null) {
                this._audioManager = (AudioManager)this._context.getSystemService("audio");
            }
            if (this._audioManager == null) {
                Logging.e("AudioDevice Java", "Could not change audio routing - no audio manager");
                return -1;
            }
            int n2 = this._audioManager.getStreamMaxVolume(3);
            int n3 = this._audioManager.getStreamVolume(3);
            int n4 = this._audioManager.getStreamMaxVolume(0);
            int n5 = this._audioManager.getStreamVolume(0);
            int n6 = n2 - n4;
            double d = (double)n4 / (double)n2;
            if (this._audioManager.getMode() == n) {
                return 0;
            }
            switch (n) {
                case 0: {
                    this._audioManager.setMode(0);
                    break;
                }
                case 1: {
                    this._audioManager.setMode(1);
                    break;
                }
                case 2: {
                    this._audioManager.setMode(2);
                    break;
                }
                case 3: {
                    this._audioManager.setMode(3);
                    break;
                }
                default: {
                    this._audioManager.setMode(0);
                    break;
                }
            }
        }
        catch (Exception exception) {
            Logging.e("AudioDevice Java", "set audio mode failed! ");
        }
        return 0;
    }

    private int GetAudioMode() {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        if (this._audioManager == null) {
            Logging.e("AudioDevice Java", "Could not change audio routing - no audio manager");
            return -1;
        }
        return this._audioManager.getMode();
    }

    private int GetNativeSampleRate() {
        String string;
        int n = 44100;
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        if (this._audioManager == null) {
            Logging.w("AudioDevice Java", "Could not set audio mode - no audio manager");
            return n;
        }
        if (Build.VERSION.SDK_INT >= 17 && (string = this._audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE")) != null) {
            n = Integer.parseInt(string);
        }
        return n;
    }

    private int GetNativePlayDelay() {
        if (this._recDelay < 0L) {
            this._recDelay = -1L;
        }
        if (this.totalDelay < 0) {
            this.totalDelay = -1;
        }
        return this.totalDelay + (int)this._recDelay;
    }

    private boolean isHardwareEarbackSupported() {
        boolean bl = false;
        if (this._context != null) {
            bl = HardwareEarbackController.getInstance(this._context).isHardwareEarbackSupported();
        }
        return bl;
    }

    private int enableHardwareEarback(boolean bl) {
        Logging.i("AudioDevice Java", "enableHardwareEarback " + bl);
        int n = -1;
        n = HardwareEarbackController.getInstance(this._context).enableHardwareEarback(bl);
        Logging.i("AudioDevice Java", "enableHardwareEarback " + bl + " ret " + n);
        return n;
    }

    private int setHardwareEarbackVolume(int n) {
        int n2 = -1;
        if (this._context != null) {
            n2 = HardwareEarbackController.getInstance(this._context).setHardwareEarbackVolume(n);
        }
        return n2;
    }

    public void monitorPlayoutVolumeChange(boolean bl) {
        if (bl) {
            if (this.mVolumeBroadcastReceiver == null) {
                try {
                    this.mVolumeBroadcastReceiver = new VolumeBroadcastReceiver(this);
                    Context context = this._context;
                    if (context != null && this.mVolumeBroadcastReceiver != null) {
                        IntentFilter intentFilter = new IntentFilter();
                        intentFilter.addAction(VOLUME_CHANGED_ACTION);
                        context.registerReceiver((BroadcastReceiver)this.mVolumeBroadcastReceiver, intentFilter);
                    }
                }
                catch (Exception exception) {
                    Logging.e("AudioDevice Java", "Unable to create VolumeBroadcastReceiver, ", exception);
                }
            }
        } else {
            try {
                Context context = this._context;
                if (context != null && this.mVolumeBroadcastReceiver != null) {
                    context.unregisterReceiver((BroadcastReceiver)this.mVolumeBroadcastReceiver);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.mVolumeBroadcastReceiver = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPlayoutVolumeChange() {
        AudioDevice audioDevice = this;
        synchronized (audioDevice) {
            int n = this.GetPlayoutVolume();
            if (this.currentPlayoutVolume != n) {
                this.nativeNotifyPlayoutVolumeChange(this.mNativeHandle, n);
                this.currentPlayoutVolume = n;
                Logging.i("AudioDevice Java", " notifyPlayoutVolumeChange: " + n);
            }
        }
    }

    native void nativeNotifyPlayoutVolumeChange(long var1, int var3);
}

