/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.audio;

import android.content.Context;
import android.media.AudioManager;
import android.media.MediaRouter;
import android.os.Build;
import io.agora.rtc.audio.HardwareEarbackController;
import java.lang.ref.WeakReference;

class AudioManagerAndroid {
    private static final int DEFAULT_SAMPLING_RATE = 44100;
    private static final int DEFAULT_FRAMES_PER_BUFFER = 256;
    private int mNativeOutputSampleRate;
    private boolean mAudioLowLatencySupported;
    private int mAudioLowLatencyOutputFrameSize;
    private AudioManager audioManager;
    private WeakReference<Context> mcontext;

    private AudioManagerAndroid(Context context) {
        this.mcontext = new WeakReference<Context>(context);
        this.audioManager = (AudioManager)context.getSystemService("audio");
        this.mNativeOutputSampleRate = 44100;
        this.mAudioLowLatencyOutputFrameSize = 256;
        if (Build.VERSION.SDK_INT >= 17) {
            String string;
            String string2 = this.audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
            if (string2 != null) {
                this.mNativeOutputSampleRate = Integer.parseInt(string2);
            }
            if ((string = this.audioManager.getProperty("android.media.property.OUTPUT_FRAMES_PER_BUFFER")) != null) {
                this.mAudioLowLatencyOutputFrameSize = Integer.parseInt(string);
            }
        }
        this.mAudioLowLatencySupported = context.getPackageManager().hasSystemFeature("android.hardware.audio.low_latency");
    }

    private int getNativeOutputSampleRate() {
        return this.mNativeOutputSampleRate;
    }

    private boolean isAudioLowLatencySupported() {
        return this.mAudioLowLatencySupported;
    }

    private int getAudioLowLatencyOutputFrameSize() {
        return this.mAudioLowLatencyOutputFrameSize;
    }

    private int QuerySpeakerStatus() {
        boolean bl = this.audioManager.getMode() == 3 || this.audioManager.getMode() == 2;
        Context context = (Context)this.mcontext.get();
        if (this.audioManager == null && context != null) {
            this.audioManager = (AudioManager)context.getSystemService("audio");
        }
        if (bl) {
            if (this.audioManager.isSpeakerphoneOn()) {
                return 3;
            }
            if (this.audioManager.isBluetoothScoOn()) {
                return 5;
            }
            if (this.audioManager.isWiredHeadsetOn()) {
                return 0;
            }
            return 1;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            MediaRouter mediaRouter = (MediaRouter)context.getSystemService("media_router");
            MediaRouter.RouteInfo routeInfo = mediaRouter.getSelectedRoute(1);
            if (routeInfo.getDeviceType() == 3) {
                return 5;
            }
            if (this.audioManager.isWiredHeadsetOn()) {
                return 0;
            }
            if (this.audioManager.isSpeakerphoneOn()) {
                return 3;
            }
            return 1;
        }
        if (this.audioManager.isBluetoothA2dpOn()) {
            return 5;
        }
        if (this.audioManager.isWiredHeadsetOn()) {
            return 0;
        }
        if (this.audioManager.isSpeakerphoneOn()) {
            return 3;
        }
        return 1;
    }

    private int SetPlayoutSpeaker(boolean bl) {
        this.audioManager.setSpeakerphoneOn(bl);
        return 0;
    }

    private int SetAudioMode(int n) {
        try {
            switch (n) {
                case 0: {
                    this.audioManager.setMode(0);
                    break;
                }
                case 1: {
                    this.audioManager.setMode(1);
                    break;
                }
                case 2: {
                    this.audioManager.setMode(2);
                    break;
                }
                case 3: {
                    this.audioManager.setMode(3);
                    break;
                }
                default: {
                    this.audioManager.setMode(0);
                    break;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 0;
    }

    private int GetAudioMode() {
        return this.audioManager.getMode();
    }

    private boolean isHardwareEarbackSupported() {
        boolean bl = false;
        Context context = (Context)this.mcontext.get();
        if (context != null) {
            bl = HardwareEarbackController.getInstance(context).isHardwareEarbackSupported();
        }
        return bl;
    }

    private int enableHardwareEarback(boolean bl) {
        int n = -1;
        Context context = (Context)this.mcontext.get();
        if (context != null) {
            n = HardwareEarbackController.getInstance(context).enableHardwareEarback(bl);
        }
        return n;
    }

    private int setHardwareEarbackVolume(int n) {
        int n2 = -1;
        Context context = (Context)this.mcontext.get();
        if (context != null) {
            n2 = HardwareEarbackController.getInstance(context).setHardwareEarbackVolume(n);
        }
        return n2;
    }

    private boolean checkAudioPermission() {
        Context context = (Context)this.mcontext.get();
        return context != null && context.checkCallingOrSelfPermission("android.permission.RECORD_AUDIO") == 0 && context.checkCallingOrSelfPermission("android.permission.MODIFY_AUDIO_SETTINGS") == 0;
    }
}

