/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.audio;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import io.agora.rtc.internal.Logging;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;

public class MediaCodecAudioEncoder {
    private MediaCodec mMediaCodec = null;
    private MediaFormat mTrackFormat = null;
    private String mCodecString = null;
    private File outputFile = null;
    private BufferedOutputStream outputStream = null;
    private ByteBuffer[] mInputBuffers;
    private ByteBuffer[] mOutputBuffers;
    private MediaCodec mAACEncoder = null;
    private MediaFormat mAACFormat = null;
    private ByteBuffer[] mAACInputBuffers;
    private ByteBuffer[] mAACOutputBuffers;
    private ByteBuffer mAACEncodedBuffer = ByteBuffer.allocateDirect(1024);
    private String TAG = "MediaCodec Audio Encoder";

    public boolean createStreaming(String string, int n, int n2, int n3) {
        try {
            Logging.i(this.TAG, "Recording aac with fs = " + n + ", ch = " + n2 + ", quality = " + n3);
            String string2 = string.substring(string.length() - 3);
            if (string2.equalsIgnoreCase("3gp") || string2.equalsIgnoreCase("amr")) {
                if (n == 8000) {
                    this.mMediaCodec = MediaCodec.createEncoderByType((String)"audio/3gpp");
                    this.mTrackFormat = MediaFormat.createAudioFormat((String)"audio/3gpp", (int)n, (int)n2);
                    this.mTrackFormat.setInteger("bitrate", 12200);
                    this.mCodecString = "audio/3gpp";
                } else if (n == 16000) {
                    this.mMediaCodec = MediaCodec.createEncoderByType((String)"audio/amr-wb");
                    this.mTrackFormat = MediaFormat.createAudioFormat((String)"audio/amr-wb", (int)n, (int)n2);
                    this.mTrackFormat.setInteger("bitrate", 23850);
                    this.mCodecString = "audio/amr-wb";
                }
            } else if (string2.equalsIgnoreCase("aac")) {
                int n4 = 50000;
                switch (n3) {
                    case 0: {
                        n4 = 16000;
                        break;
                    }
                    case 1: {
                        n4 = 25000;
                        break;
                    }
                    default: {
                        n4 = 50000;
                    }
                }
                this.mMediaCodec = MediaCodec.createEncoderByType((String)"audio/mp4a-latm");
                this.mTrackFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)n, (int)n2);
                int[] nArray = new int[]{2, 5, 39};
                this.mTrackFormat.setInteger("aac-profile", 2);
                this.mTrackFormat.setInteger("sample-rate", n);
                this.mTrackFormat.setInteger("channel-count", n2);
                this.mTrackFormat.setInteger("bitrate", n4);
                this.mCodecString = "audio/mp4a-latm";
            } else {
                return false;
            }
            this.mMediaCodec.configure(this.mTrackFormat, null, null, 1);
            if (this.mMediaCodec != null) {
                this.mMediaCodec.start();
            }
            this.outputFile = new File(string);
            this.touch(this.outputFile);
            try {
                this.outputStream = new BufferedOutputStream(new FileOutputStream(this.outputFile));
                Logging.i(this.TAG, "outputStream initialized");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.mCodecString == "audio/3gpp") {
                byte[] byArray = new byte[]{35, 33, 65, 77, 82, 10};
                this.outputStream.write(byArray);
            } else if (this.mCodecString == "audio/amr-wb") {
                byte[] byArray = new byte[]{35, 33, 65, 77, 82, 45, 87, 66, 10};
                this.outputStream.write(byArray);
            }
        }
        catch (Exception exception) {
            Logging.e(this.TAG, "Error when creating aac file encoder");
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public void setChannelCount(int n) {
        try {
            this.mTrackFormat.setInteger("channel-count", n);
        }
        catch (Exception exception) {
            Logging.e(this.TAG, "Error when setting aac file encoder channel count");
            exception.printStackTrace();
        }
    }

    public void setSampleRate(int n) {
        try {
            this.mTrackFormat.setInteger("sample-rate", n);
        }
        catch (Exception exception) {
            Logging.e(this.TAG, "Error when setting aac file encoder sample rate");
            exception.printStackTrace();
        }
    }

    public void releaseStreaming() {
        try {
            if (this.mMediaCodec != null) {
                this.mMediaCodec.stop();
                this.mMediaCodec.release();
                this.mMediaCodec = null;
            }
            if (this.outputStream != null) {
                this.outputStream.flush();
                this.outputStream.close();
                this.outputStream = null;
            }
        }
        catch (Exception exception) {
            Logging.e(this.TAG, "Error when releasing aac file encoder");
            exception.printStackTrace();
        }
    }

    public void encodeFrame(byte[] byArray) {
        try {
            Object object;
            int n = this.mMediaCodec.dequeueInputBuffer(2000L);
            if (n != -1) {
                if (Build.VERSION.SDK_INT >= 21) {
                    object = this.mMediaCodec.getInputBuffer(n);
                } else {
                    this.mInputBuffers = this.mMediaCodec.getInputBuffers();
                    object = this.mInputBuffers[n];
                }
                ((ByteBuffer)object).clear();
                ((ByteBuffer)object).put(byArray);
                this.mMediaCodec.queueInputBuffer(n, 0, byArray.length, 0L, 0);
            }
            object = new MediaCodec.BufferInfo();
            int n2 = this.mMediaCodec.dequeueOutputBuffer((MediaCodec.BufferInfo)object, 0L);
            while (n2 >= 0) {
                byte[] byArray2;
                ByteBuffer byteBuffer;
                int n3 = ((MediaCodec.BufferInfo)object).size;
                if (Build.VERSION.SDK_INT >= 21) {
                    byteBuffer = this.mMediaCodec.getOutputBuffer(n2);
                } else {
                    this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
                    byteBuffer = this.mOutputBuffers[n2];
                }
                byteBuffer.position(((MediaCodec.BufferInfo)object).offset);
                byteBuffer.limit(((MediaCodec.BufferInfo)object).offset + n3);
                if (this.mCodecString == "audio/mp4a-latm") {
                    int n4 = n3 + 7;
                    byArray2 = new byte[n4];
                    this.addADTStoPacket(byArray2, n4);
                    byteBuffer.get(byArray2, 7, n3);
                    byteBuffer.position(((MediaCodec.BufferInfo)object).offset);
                    this.outputStream.write(byArray2, 0, byArray2.length);
                } else if (this.mCodecString == "audio/3gpp" || this.mCodecString == "audio/amr-wb") {
                    byArray2 = new byte[n3];
                    byteBuffer.get(byArray2, 0, n3);
                    byteBuffer.position(((MediaCodec.BufferInfo)object).offset);
                    this.outputStream.write(byArray2, 0, byArray2.length);
                }
                this.mMediaCodec.releaseOutputBuffer(n2, false);
                n2 = this.mMediaCodec.dequeueOutputBuffer((MediaCodec.BufferInfo)object, 0L);
            }
        }
        catch (Exception exception) {
            Logging.e(this.TAG, "Error when encoding aac file");
            exception.printStackTrace();
        }
    }

    private void addADTStoPacket(byte[] byArray, int n) {
        int n2 = 2;
        int n3 = 5;
        int n4 = 1;
        byArray[0] = -1;
        byArray[1] = -7;
        byArray[2] = (byte)((n2 - 1 << 6) + (n3 << 2) + (n4 >> 2));
        byArray[3] = (byte)(((n4 & 3) << 6) + (n >> 11));
        byArray[4] = (byte)((n & 0x7FF) >> 3);
        byArray[5] = (byte)(((n & 7) << 5) + 31);
        byArray[6] = -4;
    }

    private void touch(File file) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean createAACStreaming(int n, int n2, int n3) {
        try {
            Logging.i(this.TAG, "Encoding aac with fs = " + n + ", bitrate = " + n3);
            this.mAACEncoder = MediaCodec.createEncoderByType((String)"audio/mp4a-latm");
            this.mAACFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)n, (int)n2);
            int[] nArray = new int[]{2, 5, 39};
            this.mAACFormat.setInteger("aac-profile", 2);
            this.mAACFormat.setInteger("sample-rate", n);
            this.mAACFormat.setInteger("channel-count", n2);
            this.mAACFormat.setInteger("bitrate", n3);
            this.mAACEncoder.configure(this.mAACFormat, null, null, 1);
            if (this.mAACEncoder != null) {
                this.mAACEncoder.start();
            }
        }
        catch (Exception exception) {
            Logging.e(this.TAG, "Error when creating aac encode stream");
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean setAACEncodeBitrate(int n) {
        Logging.w(this.TAG, "Set hw aac bitrate = " + n);
        try {
            if (this.mAACEncoder != null) {
                this.mAACEncoder.stop();
                this.mAACFormat.setInteger("bitrate", n);
                this.mAACEncoder.configure(this.mAACFormat, null, null, 1);
                this.mAACEncoder.start();
            }
        }
        catch (Exception exception) {
            Logging.e(this.TAG, "Error when setting aac encode bitrate");
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public void releaseAACStreaming() {
        try {
            if (this.mAACEncoder != null) {
                this.mAACEncoder.stop();
                this.mAACEncoder.release();
                this.mAACEncoder = null;
            }
        }
        catch (Exception exception) {
            Logging.e(this.TAG, "Error when releasing aac encode stream");
            exception.printStackTrace();
        }
    }

    public int encodeAACFrame(byte[] byArray) {
        int n = 0;
        try {
            int n2;
            Object object;
            int n3 = this.mAACEncoder.dequeueInputBuffer(2000L);
            if (n3 != -1) {
                if (Build.VERSION.SDK_INT >= 21) {
                    object = this.mAACEncoder.getInputBuffer(n3);
                } else {
                    this.mAACInputBuffers = this.mAACEncoder.getInputBuffers();
                    object = this.mAACInputBuffers[n3];
                }
                ((ByteBuffer)object).clear();
                ((ByteBuffer)object).put(byArray);
                this.mAACEncoder.queueInputBuffer(n3, 0, byArray.length, 0L, 0);
            }
            if ((n2 = this.mAACEncoder.dequeueOutputBuffer((MediaCodec.BufferInfo)(object = new MediaCodec.BufferInfo()), 0L)) >= 0) {
                ByteBuffer byteBuffer;
                int n4 = ((MediaCodec.BufferInfo)object).size;
                if (Build.VERSION.SDK_INT >= 21) {
                    byteBuffer = this.mAACEncoder.getOutputBuffer(n2);
                } else {
                    this.mAACOutputBuffers = this.mAACEncoder.getOutputBuffers();
                    byteBuffer = this.mAACOutputBuffers[n2];
                }
                n = (((MediaCodec.BufferInfo)object).flags & 2) == 2 ? 0 : ((MediaCodec.BufferInfo)object).size;
                byteBuffer.position(((MediaCodec.BufferInfo)object).offset);
                byteBuffer.limit(((MediaCodec.BufferInfo)object).offset + n4);
                this.mAACEncodedBuffer.position(0);
                this.mAACEncodedBuffer.put(byteBuffer);
                this.mAACEncoder.releaseOutputBuffer(n2, false);
            }
        }
        catch (Exception exception) {
            Logging.e(this.TAG, "Error when encoding aac stream");
            exception.printStackTrace();
        }
        return n;
    }
}

