/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.audio;

import android.content.Context;
import io.agora.rtc.audio.IHardwareEarback;
import io.agora.rtc.audio.ReflectUtils;
import io.agora.rtc.internal.Logging;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class OppoHardwareEarback
implements IHardwareEarback {
    private boolean isConnected = false;
    private Context mContext = null;
    private static String TAG = "AG-OPPO";
    private Class clsMediaUnit;
    private Class clsMediaClient;
    private Class clsOnConnectionSucceedListener;
    private boolean mClsInited = false;

    public OppoHardwareEarback(Context context) {
        this.mContext = context;
        this.initialize();
    }

    public static boolean hasMediaUnitClass() {
        Class clazz = ReflectUtils.safeFindClass("com.coloros.ocs.mediaunit.MediaUnit");
        Class clazz2 = ReflectUtils.safeFindClass("com.coloros.ocs.mediaunit.MediaUnitClient");
        Class clazz3 = ReflectUtils.safeFindClass("com.coloros.ocs.base.common.api.OnConnectionSucceedListener");
        return clazz2 != null && clazz != null && clazz3 != null;
    }

    @Override
    public void initialize() {
        this.clsMediaUnit = ReflectUtils.safeFindClass("com.coloros.ocs.mediaunit.MediaUnit");
        this.clsMediaClient = ReflectUtils.safeFindClass("com.coloros.ocs.mediaunit.MediaUnitClient");
        this.clsOnConnectionSucceedListener = ReflectUtils.safeFindClass("com.coloros.ocs.base.common.api.OnConnectionSucceedListener");
        if (this.clsMediaClient == null || this.clsMediaUnit == null || this.clsOnConnectionSucceedListener == null) {
            return;
        }
        this.mClsInited = true;
        try {
            Object object;
            if (this.mContext != null && (object = ReflectUtils.safeCallMethod(this.clsMediaUnit, null, "getMediaClient", new Class[]{Context.class}, new Object[]{this.mContext})) != null) {
                Object object2 = Proxy.newProxyInstance(this.clsOnConnectionSucceedListener.getClassLoader(), new Class[]{this.clsOnConnectionSucceedListener}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                        if (method.getName().equals("onConnectionSucceed")) {
                            OppoHardwareEarback.this.isConnected = true;
                        }
                        return null;
                    }
                });
                ReflectUtils.safeCallMethod(this.clsMediaClient, object, "addOnConnectionSucceedListener", new Class[]{this.clsOnConnectionSucceedListener}, new Object[]{object2});
            }
        }
        catch (Exception exception) {
            Logging.e(exception.getMessage());
        }
    }

    @Override
    public boolean isHardwareEarbackSupported() {
        return this.isConnected && this.mClsInited;
    }

    @Override
    public int enableEarbackFeature(boolean bl) {
        if (!this.mClsInited) {
            return -1;
        }
        boolean bl2 = false;
        try {
            if (this.mContext != null && this.isConnected) {
                final Object object = ReflectUtils.safeCallMethod(this.clsMediaUnit, null, "getMediaClient", new Class[]{Context.class}, new Object[]{this.mContext});
                if (bl) {
                    if (object != null) {
                        Object object2 = Proxy.newProxyInstance(this.clsOnConnectionSucceedListener.getClassLoader(), new Class[]{this.clsOnConnectionSucceedListener}, new InvocationHandler(){

                            @Override
                            public Object invoke(Object object2, Method method, Object[] objectArray) throws Throwable {
                                if (method.getName().equals("onConnectionSucceed") && OppoHardwareEarback.this.mContext != null) {
                                    ReflectUtils.safeCallMethod(OppoHardwareEarback.this.clsMediaClient, object, "requestAudioLoopback", new Class[0], new Object[0]);
                                }
                                return null;
                            }
                        });
                        ReflectUtils.safeCallMethod(this.clsMediaClient, object, "addOnConnectionSucceedListener", new Class[]{this.clsOnConnectionSucceedListener}, new Object[]{object2});
                    }
                } else if (object != null) {
                    Object object3 = Proxy.newProxyInstance(this.clsOnConnectionSucceedListener.getClassLoader(), new Class[]{this.clsOnConnectionSucceedListener}, new InvocationHandler(){

                        @Override
                        public Object invoke(Object object2, Method method, Object[] objectArray) throws Throwable {
                            if (method.getName().equals("onConnectionSucceed") && OppoHardwareEarback.this.mContext != null) {
                                ReflectUtils.safeCallMethod(OppoHardwareEarback.this.clsMediaClient, object, "abandonAudioLoopback", new Class[0], new Object[0]);
                            }
                            return null;
                        }
                    });
                    ReflectUtils.safeCallMethod(this.clsMediaClient, object, "addOnConnectionSucceedListener", new Class[]{this.clsOnConnectionSucceedListener}, new Object[]{object3});
                }
                return 0;
            }
        }
        catch (Exception exception) {
            Logging.e(exception.getMessage());
        }
        return -1;
    }

    @Override
    public int setHardwareEarbackVolume(int n) {
        return 0;
    }

    @Override
    public void destroy() {
        if (!this.mClsInited) {
            return;
        }
        try {
            Object object;
            if (this.mContext != null && (object = ReflectUtils.safeCallMethod(this.clsMediaUnit, null, "getMediaClient", new Class[]{Context.class}, new Object[]{this.mContext})) != null) {
                ReflectUtils.safeCallMethod(this.clsMediaClient, object, "release", new Class[0], new Object[0]);
            }
        }
        catch (Exception exception) {
            Logging.e(exception.getMessage());
        }
    }
}

