/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.audio;

import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import io.agora.rtc.audio.IHardwareEarback;
import io.agora.rtc.internal.Logging;
import java.util.StringTokenizer;

class VivoHardwareEarback
implements IHardwareEarback {
    private static final String TAG = "VivoHardwareEarback Java";
    private static final String KEY_KTV_MODE = "vivo_ktv_mode";
    private static final String KEY_VOL_MIC = "vivo_ktv_volume_mic";
    private static final String KEY_MIC_TYPE = "vivo_ktv_mic_type";
    private static final String KEY_PLAY_SRC = "vivo_ktv_play_source";
    private AudioManager mAudioManager = null;
    private Context mContext = null;

    public VivoHardwareEarback(Context context) {
        this.mContext = context;
        this.initialize();
    }

    @Override
    public void initialize() {
        if (null == this.mContext) {
            Logging.e(TAG, "mContext should not be null!");
            return;
        }
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
    }

    @Override
    public boolean isHardwareEarbackSupported() {
        if (null == this.mAudioManager) {
            return false;
        }
        String string = Build.MANUFACTURER;
        if (string.trim().contains("vivo")) {
            String string2;
            int n;
            String string3 = this.mAudioManager.getParameters(KEY_MIC_TYPE);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "=");
            int n2 = stringTokenizer.countTokens();
            if (2 != n2) {
                return false;
            }
            String string4 = stringTokenizer.nextToken();
            if (string4.equals(KEY_MIC_TYPE) && (1 == (n = Integer.parseInt(string2 = stringTokenizer.nextToken())) || 0 == n)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized int setHardwareEarbackVolume(int n) {
        if (0 > n) {
            n = 0;
        }
        if (15 < n) {
            n = 15;
        }
        if (null != this.mAudioManager) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(KEY_VOL_MIC).append("=").append(n);
            this.mAudioManager.setParameters(stringBuilder.toString());
            return 0;
        }
        return -1;
    }

    @Override
    public synchronized int enableEarbackFeature(boolean bl) {
        return -1;
    }

    @Override
    public void destroy() {
        this.mAudioManager = null;
        this.mContext = null;
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }
}

