/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gdp;

import android.graphics.Bitmap;
import android.opengl.EGL14;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.util.Log;
import io.agora.rtc.gdp.EglCore;
import io.agora.rtc.gdp.GlUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class EglSurfaceBase {
    protected static final String TAG = "GDPGlUtil";
    protected EglCore mEglCore;
    private EGLSurface mEGLSurface = EGL14.EGL_NO_SURFACE;
    private int mWidth = -1;
    private int mHeight = -1;

    protected EglSurfaceBase(EglCore eglCore) {
        this.mEglCore = eglCore;
    }

    public void createWindowSurface(Object object) {
        if (this.mEGLSurface != EGL14.EGL_NO_SURFACE) {
            throw new IllegalStateException("surface already created");
        }
        this.mEGLSurface = this.mEglCore.createWindowSurface(object);
    }

    public void createOffscreenSurface(int n, int n2) {
        if (this.mEGLSurface != EGL14.EGL_NO_SURFACE) {
            throw new IllegalStateException("surface already created");
        }
        this.mEGLSurface = this.mEglCore.createOffscreenSurface(n, n2);
        this.mWidth = n;
        this.mHeight = n2;
    }

    public int getWidth() {
        if (this.mWidth < 0) {
            return this.mEglCore.querySurface(this.mEGLSurface, 12375);
        }
        return this.mWidth;
    }

    public int getHeight() {
        if (this.mHeight < 0) {
            return this.mEglCore.querySurface(this.mEGLSurface, 12374);
        }
        return this.mHeight;
    }

    public void releaseEglSurface() {
        this.mEglCore.releaseSurface(this.mEGLSurface);
        this.mEGLSurface = EGL14.EGL_NO_SURFACE;
        this.mHeight = -1;
        this.mWidth = -1;
    }

    public void makeCurrent() {
        this.mEglCore.makeCurrent(this.mEGLSurface);
    }

    public void makeCurrentReadFrom(EglSurfaceBase eglSurfaceBase) {
        this.mEglCore.makeCurrent(this.mEGLSurface, eglSurfaceBase.mEGLSurface);
    }

    public boolean swapBuffers() {
        boolean bl = this.mEglCore.swapBuffers(this.mEGLSurface);
        if (!bl) {
            Log.d((String)TAG, (String)"WARNING: swapBuffers() failed");
        }
        return bl;
    }

    public void setPresentationTime(long l) {
        this.mEglCore.setPresentationTime(this.mEGLSurface, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFrame(File file) throws IOException {
        if (!this.mEglCore.isCurrent(this.mEGLSurface)) {
            throw new RuntimeException("Expected EGL context/surface is not current");
        }
        String string = file.toString();
        int n = this.getWidth();
        int n2 = this.getHeight();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * n2 * 4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        GLES20.glReadPixels((int)0, (int)0, (int)n, (int)n2, (int)6408, (int)5121, (Buffer)byteBuffer);
        GlUtil.checkGlError("glReadPixels");
        byteBuffer.rewind();
        try (FilterOutputStream filterOutputStream = null;){
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            Bitmap bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.copyPixelsFromBuffer((Buffer)byteBuffer);
            bitmap.compress(Bitmap.CompressFormat.PNG, 90, (OutputStream)filterOutputStream);
            bitmap.recycle();
        }
        Log.d((String)TAG, (String)("Saved " + n + "x" + n2 + " frame as '" + string + "'"));
    }
}

