/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gdp;

import android.app.ActivityManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.opengl.GLES20;
import android.os.BatteryManager;
import android.os.Build;
import android.util.Log;
import io.agora.rtc.gdp.EglCore;
import io.agora.rtc.gdp.OffscreenSurface;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;

public class GDPAndroid {
    private static String TAG = "GDPAndroid";
    private static final int DEVICEINFO_UNKNOWN = -1;
    private Context mAppContext = null;
    private String mGpuVendor = "unkown";
    private String mGpuRenderer = "unkown";
    private static final FileFilter CPU_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            String string = file.getName();
            if (string.startsWith("cpu")) {
                for (int i = 3; i < string.length(); ++i) {
                    if (Character.isDigit(string.charAt(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    };
    private static final List<String> CPU_TEMP_FILE_PATHS = Arrays.asList("/sys/devices/system/cpu/cpu0/cpufreq/cpu_temp", "/sys/devices/system/cpu/cpu0/cpufreq/FakeShmoo_cpu_temp", "/sys/class/thermal/thermal_zone0/temp", "/sys/class/i2c-adapter/i2c-4/4-004c/temperature", "/sys/devices/platform/tegra-i2c.3/i2c-4/4-004c/temperature", "/sys/devices/platform/omap/omap_temp_sensor.0/temperature", "/sys/devices/platform/tegra_tmon/temp1_input", "/sys/kernel/debug/tegra_thermal/temp_tj", "/sys/devices/platform/s5p-tmu/temperature", "/sys/class/thermal/thermal_zone1/temp", "/sys/class/hwmon/hwmon0/device/temp1_input", "/sys/devices/virtual/thermal/thermal_zone1/temp", "/sys/devices/virtual/thermal/thermal_zone0/temp", "/sys/class/thermal/thermal_zone3/temp", "/sys/class/thermal/thermal_zone4/temp", "/sys/class/hwmon/hwmonX/temp1_input", "/sys/devices/platform/s5p-tmu/curr_temp");

    public boolean initGDP(Context context) {
        this.mAppContext = context;
        if (this.isEGL14SupportedHere()) {
            this.gatherGlInfo();
        }
        return true;
    }

    public int getCpuCores() {
        return GDPAndroid.getNumberOfCPUCores();
    }

    public int getCpuClock() {
        return GDPAndroid.getCPUMaxFreqKHz();
    }

    public String getCpuVendor() {
        return Build.HARDWARE;
    }

    public int getRam() {
        int n = (int)(GDPAndroid.getTotalMemory(this.mAppContext) / 1024L);
        return n;
    }

    public String getGpuVendor() {
        return this.mGpuVendor;
    }

    public String getGpuRenderer() {
        return this.mGpuRenderer;
    }

    public int getOsVersion() {
        return Build.VERSION.SDK_INT;
    }

    public String getDeviceName() {
        return Build.MODEL;
    }

    public int getBattery() {
        return this.getBatteryLevel();
    }

    private boolean isEGL14SupportedHere() {
        return Build.VERSION.SDK_INT >= 21;
    }

    private void gatherGlInfo() {
        EglCore eglCore = new EglCore(null, 2);
        OffscreenSurface offscreenSurface = new OffscreenSurface(eglCore, 1, 1);
        offscreenSurface.makeCurrent();
        this.mGpuVendor = GLES20.glGetString((int)7936);
        this.mGpuRenderer = GLES20.glGetString((int)7937);
        offscreenSurface.release();
        eglCore.release();
    }

    private int getBatteryLevel() {
        if (Build.VERSION.SDK_INT >= 21) {
            BatteryManager batteryManager = (BatteryManager)this.mAppContext.getSystemService("batterymanager");
            return batteryManager.getIntProperty(4);
        }
        Intent intent = new ContextWrapper(this.mAppContext).registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        return intent.getIntExtra("level", -1) * 100 / intent.getIntExtra("scale", -1);
    }

    private static int getNumberOfCPUCores() {
        int n;
        if (Build.VERSION.SDK_INT <= 10) {
            return 1;
        }
        try {
            n = GDPAndroid.getCoresFromFileInfo("/sys/devices/system/cpu/possible");
            if (n == -1) {
                n = GDPAndroid.getCoresFromFileInfo("/sys/devices/system/cpu/present");
            }
            if (n == -1) {
                n = GDPAndroid.getCoresFromCPUFileList();
            }
        }
        catch (SecurityException securityException) {
            n = -1;
        }
        catch (NullPointerException nullPointerException) {
            n = -1;
        }
        Log.i((String)TAG, (String)("cores:" + n));
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getCoresFromFileInfo(String string) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string2 = bufferedReader.readLine();
            bufferedReader.close();
            int n = GDPAndroid.getCoresFromFileString(string2);
            return n;
        }
        catch (IOException iOException) {
            int n = -1;
            return n;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static int getCoresFromFileString(String string) {
        if (string == null || !string.matches("0-[\\d]+$")) {
            return -1;
        }
        int n = Integer.valueOf(string.substring(2)) + 1;
        return n;
    }

    private static int getCoresFromCPUFileList() {
        return new File("/sys/devices/system/cpu/").listFiles(CPU_FILTER).length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getCPUMaxFreqKHz() {
        int n;
        block13: {
            n = -1;
            try {
                for (int i = 0; i < GDPAndroid.getNumberOfCPUCores(); ++i) {
                    String string = "/sys/devices/system/cpu/cpu" + i + "/cpufreq/cpuinfo_max_freq";
                    File file = new File(string);
                    if (!file.exists() || !file.canRead()) continue;
                    byte[] byArray = new byte[128];
                    try (FileInputStream fileInputStream = new FileInputStream(file);){
                        int n2;
                        fileInputStream.read(byArray);
                        for (n2 = 0; Character.isDigit(byArray[n2]) && n2 < byArray.length; ++n2) {
                        }
                        String string2 = new String(byArray, 0, n2);
                        Integer n3 = Integer.parseInt(string2);
                        if (n3 <= n) continue;
                        n = n3;
                        continue;
                    }
                }
                if (n != -1) break block13;
                try (FileInputStream fileInputStream = new FileInputStream("/proc/cpuinfo");){
                    int n4 = GDPAndroid.parseFileForValue("cpu MHz", fileInputStream);
                    if ((n4 *= 1000) > n) {
                        n = n4;
                    }
                }
            }
            catch (IOException iOException) {
                n = -1;
            }
        }
        Log.i((String)TAG, (String)("max freq:" + n));
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getTotalMemory(Context context) {
        if (Build.VERSION.SDK_INT >= 16) {
            ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            activityManager.getMemoryInfo(memoryInfo);
            if (memoryInfo != null) {
                Log.i((String)TAG, (String)("total mem:" + memoryInfo.totalMem));
                return memoryInfo.totalMem;
            }
            return -1L;
        }
        long l = -1L;
        try (FileInputStream fileInputStream = new FileInputStream("/proc/meminfo");){
            l = GDPAndroid.parseFileForValue("MemTotal", fileInputStream);
            l *= 1024L;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Log.i((String)TAG, (String)("total mem:" + l));
        return l;
    }

    private static int parseFileForValue(String string, FileInputStream fileInputStream) {
        byte[] byArray = new byte[1024];
        try {
            int n = fileInputStream.read(byArray);
            for (int i = 0; i < n; ++i) {
                int n2;
                if (byArray[i] != 10 && i != 0) continue;
                if (byArray[i] == 10) {
                    // empty if block
                }
                for (int j = ++i; j < n && byArray[j] == string.charAt(n2 = j - i); ++j) {
                    if (n2 != string.length() - 1) continue;
                    return GDPAndroid.extractValue(byArray, j);
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    private static int extractValue(byte[] byArray, int n) {
        while (n < byArray.length && byArray[n] != 10) {
            if (Character.isDigit(byArray[n])) {
                int n2 = n++;
                while (n < byArray.length && Character.isDigit(byArray[n])) {
                    ++n;
                }
                String string = new String(byArray, 0, n2, n - n2);
                return Integer.parseInt(string);
            }
            ++n;
        }
        return -1;
    }

    public boolean checkBackground() {
        ActivityManager.RunningAppProcessInfo runningAppProcessInfo = new ActivityManager.RunningAppProcessInfo();
        ActivityManager.getMyMemoryState((ActivityManager.RunningAppProcessInfo)runningAppProcessInfo);
        return runningAppProcessInfo.importance != 100 && runningAppProcessInfo.importance != 200;
    }

    public int getCpuTemperature() {
        String string = null;
        double d = 0.0;
        for (int i = 0; i < CPU_TEMP_FILE_PATHS.size(); ++i) {
            string = CPU_TEMP_FILE_PATHS.get(i);
            Double d2 = this.readOneLine(new File(string));
            if (this.isTemperatureValid(d2)) {
                d = d2;
                Log.i((String)TAG, (String)("getCpuTemperature valid path:" + string));
                break;
            }
            if (!this.isTemperatureValid(d2 / 1000.0)) continue;
            d = d2 / 1000.0;
            Log.i((String)TAG, (String)("getCpuTemperature valid path:" + string));
            break;
        }
        return (int)(d * 1000.0);
    }

    private double readOneLine(File file) {
        FileInputStream fileInputStream = null;
        String string = "";
        if (!file.exists() || !file.canRead()) {
            return -100000.0;
        }
        try {
            fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            string = bufferedReader.readLine();
            fileInputStream.close();
            inputStreamReader.close();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        double d = -100000.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d;
    }

    private boolean isTemperatureValid(double d) {
        return d >= -30.0 && d <= 250.0;
    }
}

