/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gdp;

import android.opengl.GLES20;
import android.opengl.Matrix;
import android.util.Log;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class GlUtil {
    public static final String TAG = "GDPGlUtil";
    public static final float[] IDENTITY_MATRIX = new float[16];
    private static final int SIZEOF_FLOAT = 4;

    private GlUtil() {
    }

    public static int createProgram(String string, String string2) {
        int n = GlUtil.loadShader(35633, string);
        if (n == 0) {
            return 0;
        }
        int n2 = GlUtil.loadShader(35632, string2);
        if (n2 == 0) {
            return 0;
        }
        int n3 = GLES20.glCreateProgram();
        GlUtil.checkGlError("glCreateProgram");
        if (n3 == 0) {
            Log.e((String)TAG, (String)"Could not create program");
        }
        GLES20.glAttachShader((int)n3, (int)n);
        GlUtil.checkGlError("glAttachShader");
        GLES20.glAttachShader((int)n3, (int)n2);
        GlUtil.checkGlError("glAttachShader");
        GLES20.glLinkProgram((int)n3);
        int[] nArray = new int[1];
        GLES20.glGetProgramiv((int)n3, (int)35714, (int[])nArray, (int)0);
        if (nArray[0] != 1) {
            Log.e((String)TAG, (String)"Could not link program: ");
            Log.e((String)TAG, (String)GLES20.glGetProgramInfoLog((int)n3));
            GLES20.glDeleteProgram((int)n3);
            n3 = 0;
        }
        return n3;
    }

    public static int loadShader(int n, String string) {
        int n2 = GLES20.glCreateShader((int)n);
        GlUtil.checkGlError("glCreateShader type=" + n);
        GLES20.glShaderSource((int)n2, (String)string);
        GLES20.glCompileShader((int)n2);
        int[] nArray = new int[1];
        GLES20.glGetShaderiv((int)n2, (int)35713, (int[])nArray, (int)0);
        if (nArray[0] == 0) {
            Log.e((String)TAG, (String)("Could not compile shader " + n + ":"));
            Log.e((String)TAG, (String)(" " + GLES20.glGetShaderInfoLog((int)n2)));
            GLES20.glDeleteShader((int)n2);
            n2 = 0;
        }
        return n2;
    }

    public static void checkGlError(String string) {
        int n = GLES20.glGetError();
        if (n != 0) {
            String string2 = string + ": glError 0x" + Integer.toHexString(n);
            Log.e((String)TAG, (String)string2);
            throw new RuntimeException(string2);
        }
    }

    public static void checkLocation(int n, String string) {
        if (n < 0) {
            throw new RuntimeException("Unable to locate '" + string + "' in program");
        }
    }

    public static int createImageTexture(ByteBuffer byteBuffer, int n, int n2, int n3) {
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        int n4 = nArray[0];
        GlUtil.checkGlError("glGenTextures");
        GLES20.glBindTexture((int)3553, (int)n4);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GlUtil.checkGlError("loadImageTexture");
        GLES20.glTexImage2D((int)3553, (int)0, (int)n3, (int)n, (int)n2, (int)0, (int)n3, (int)5121, (Buffer)byteBuffer);
        GlUtil.checkGlError("loadImageTexture");
        return n4;
    }

    public static FloatBuffer createFloatBuffer(float[] fArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(fArray.length * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        floatBuffer.put(fArray);
        floatBuffer.position(0);
        return floatBuffer;
    }

    public static void logVersionInfo() {
        Log.i((String)TAG, (String)("vendor  : " + GLES20.glGetString((int)7936)));
        Log.i((String)TAG, (String)("renderer: " + GLES20.glGetString((int)7937)));
        Log.i((String)TAG, (String)("version : " + GLES20.glGetString((int)7938)));
    }

    static {
        Matrix.setIdentityM((float[])IDENTITY_MATRIX, (int)0);
    }
}

