/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import android.opengl.GLES20;
import io.agora.rtc.gl.GlShader;
import io.agora.rtc.gl.GlUtil;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.internal.ATrace;
import java.nio.FloatBuffer;
import java.util.IdentityHashMap;
import java.util.Map;

public class GlRectDrawer
implements RendererCommon.GlDrawer {
    private static final String VERTEX_SHADER_STRING = "varying vec2 interp_tc;\nattribute vec4 in_pos;\nattribute vec4 in_tc;\n\nuniform mat4 texMatrix;\n\nvoid main() {\n    gl_Position = in_pos;\n    interp_tc = (texMatrix * in_tc).xy;\n}\n";
    private static final String YUV_FRAGMENT_SHADER_STRING = "precision mediump float;\nvarying vec2 interp_tc;\n\nuniform sampler2D y_tex;\nuniform sampler2D u_tex;\nuniform sampler2D v_tex;\n\nvoid main() {\n  float y = texture2D(y_tex, interp_tc).r;\n  float u = texture2D(u_tex, interp_tc).r - 0.5;\n  float v = texture2D(v_tex, interp_tc).r - 0.5;\n  gl_FragColor = vec4(y + 1.403 * v,                       y - 0.344 * u - 0.714 * v,                       y + 1.77 * u, 1);\n}\n";
    private static final String RGB_FRAGMENT_SHADER_STRING = "precision mediump float;\nvarying vec2 interp_tc;\n\nuniform sampler2D rgb_tex;\n\nvoid main() {\n  gl_FragColor = texture2D(rgb_tex, interp_tc);\n}\n";
    private static final String OES_FRAGMENT_SHADER_STRING = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 interp_tc;\n\nuniform samplerExternalOES oes_tex;\n\nvoid main() {\n  gl_FragColor = texture2D(oes_tex, interp_tc);\n}\n";
    private static final FloatBuffer FULL_RECTANGLE_BUF = GlUtil.createFloatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
    private static final FloatBuffer FULL_RECTANGLE_TEX_BUF = GlUtil.createFloatBuffer(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
    private FloatBuffer mTexCoordinate = GlUtil.createFloatBuffer(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
    private FloatBuffer mPosCoordinate = GlUtil.createFloatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
    private final Map<String, Shader> shaders = new IdentityHashMap<String, Shader>();

    @Override
    public void drawOes(int n, float[] fArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        ATrace.beginSection("prepareShader");
        this.prepareShader(OES_FRAGMENT_SHADER_STRING, fArray);
        ATrace.endSection();
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)n);
        this.drawRectangle(n4, n5, n6, n7);
        GLES20.glBindTexture((int)36197, (int)0);
    }

    @Override
    public void drawRgb(int n, float[] fArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        ATrace.beginSection("prepareShader");
        this.prepareShader(RGB_FRAGMENT_SHADER_STRING, fArray);
        ATrace.endSection();
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)n);
        this.drawRectangle(n4, n5, n6, n7);
        GLES20.glBindTexture((int)3553, (int)0);
    }

    @Override
    public void drawYuv(int[] nArray, float[] fArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        this.prepareShader(YUV_FRAGMENT_SHADER_STRING, fArray);
        for (n7 = 0; n7 < 3; ++n7) {
            GLES20.glActiveTexture((int)(33984 + n7));
            GLES20.glBindTexture((int)3553, (int)nArray[n7]);
        }
        this.drawRectangle(n3, n4, n5, n6);
        for (n7 = 0; n7 < 3; ++n7) {
            GLES20.glActiveTexture((int)(33984 + n7));
            GLES20.glBindTexture((int)3553, (int)0);
        }
    }

    private void drawRectangle(int n, int n2, int n3, int n4) {
        GLES20.glViewport((int)n, (int)n2, (int)n3, (int)n4);
        ATrace.beginSection("glDrawArrays");
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        ATrace.endSection();
    }

    private void prepareShader(String string, float[] fArray) {
        Shader shader;
        if (this.shaders.containsKey(string)) {
            shader = this.shaders.get(string);
        } else {
            shader = new Shader(string);
            this.shaders.put(string, shader);
            shader.glShader.useProgram();
            ATrace.beginSection("initShaderUniforms");
            if (YUV_FRAGMENT_SHADER_STRING.equals(string)) {
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("y_tex"), (int)0);
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("u_tex"), (int)1);
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("v_tex"), (int)2);
            } else if (RGB_FRAGMENT_SHADER_STRING.equals(string)) {
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("rgb_tex"), (int)0);
            } else if (OES_FRAGMENT_SHADER_STRING.equals(string)) {
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("oes_tex"), (int)0);
            } else {
                throw new IllegalStateException("Unknown fragment shader: " + string);
            }
            GlUtil.checkNoGLES2Error("Initialize fragment shader uniform values.");
            ATrace.endSection();
            ATrace.beginSection("initVertexShaderAttrs");
            shader.glShader.setVertexAttribArray("in_pos", 2, FULL_RECTANGLE_BUF);
            shader.glShader.setVertexAttribArray("in_tc", 2, FULL_RECTANGLE_TEX_BUF);
            ATrace.endSection();
        }
        shader.glShader.useProgram();
        GLES20.glUniformMatrix4fv((int)shader.texMatrixLocation, (int)1, (boolean)false, (float[])fArray, (int)0);
    }

    private void prepareShader(String string, float[] fArray, FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        Shader shader;
        if (this.shaders.containsKey(string)) {
            shader = this.shaders.get(string);
        } else {
            shader = new Shader(string);
            this.shaders.put(string, shader);
            shader.glShader.useProgram();
            if (string == YUV_FRAGMENT_SHADER_STRING) {
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("y_tex"), (int)0);
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("u_tex"), (int)1);
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("v_tex"), (int)2);
            } else if (string == RGB_FRAGMENT_SHADER_STRING) {
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("rgb_tex"), (int)0);
            } else if (string == OES_FRAGMENT_SHADER_STRING) {
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("oes_tex"), (int)0);
            } else {
                throw new IllegalStateException("Unknown fragment shader: " + string);
            }
            GlUtil.checkNoGLES2Error("Initialize fragment shader uniform values.");
        }
        shader.glShader.useProgram();
        shader.glShader.setVertexAttribArray("in_pos", 2, floatBuffer2);
        shader.glShader.setVertexAttribArray("in_tc", 2, floatBuffer);
        GLES20.glUniformMatrix4fv((int)shader.texMatrixLocation, (int)1, (boolean)false, (float[])fArray, (int)0);
    }

    public void drawOes(int n, float[] fArray, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        float[] fArray2 = this.ComputeVertexAttribArray(n2, n3, n8, n9);
        this.mTexCoordinate = GlUtil.createFloatBuffer(fArray2);
        if (n8 != n6 || n9 != n7) {
            float[] fArray3 = this.ComputePosVertexAttribArray(n6, n7, n8, n9);
            this.mPosCoordinate = GlUtil.createFloatBuffer(fArray3);
        } else {
            this.mPosCoordinate = FULL_RECTANGLE_BUF;
        }
        this.prepareShader(OES_FRAGMENT_SHADER_STRING, fArray, this.mTexCoordinate, this.mPosCoordinate);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)n);
        this.drawRectangle(n4, n5, n6, n7);
        GLES20.glBindTexture((int)36197, (int)0);
    }

    public void drawRgb(int n, float[] fArray, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        float[] fArray2 = this.ComputeVertexAttribArray(n2, n3, n8, n9);
        if (n8 != n6 || n9 != n7) {
            float[] fArray3 = this.ComputePosVertexAttribArray(n6, n7, n8, n9);
            this.mPosCoordinate = GlUtil.createFloatBuffer(fArray3);
        } else {
            this.mPosCoordinate = FULL_RECTANGLE_BUF;
        }
        this.mTexCoordinate = GlUtil.createFloatBuffer(fArray2);
        this.prepareShader(RGB_FRAGMENT_SHADER_STRING, fArray, this.mTexCoordinate, this.mPosCoordinate);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)n);
        this.drawRectangle(n4, n5, n6, n7);
        GLES20.glBindTexture((int)3553, (int)0);
    }

    private float[] ComputeVertexAttribArray(int n, int n2, int n3, int n4) {
        float f = (float)n / (float)n2;
        float f2 = (float)n3 / (float)n4;
        if (f >= f2) {
            float f3 = (float)n2 * f2;
            float f4 = ((float)n - f3) / 2.0f / (float)n;
            return new float[]{f4, 0.0f, 1.0f - f4, 0.0f, f4, 1.0f, 1.0f - f4, 1.0f};
        }
        float f5 = (float)n / f2;
        float f6 = 0.0f;
        float f7 = ((float)n2 - f5) / 2.0f / (float)n2;
        return new float[]{0.0f, f7, 1.0f, f7, 0.0f, 1.0f - f7, 1.0f, 1.0f - f7};
    }

    private float[] ComputePosVertexAttribArray(int n, int n2, int n3, int n4) {
        float f = n2 == n4 ? -1.0f : 2.0f * (float)(n2 - n4) / (float)n2 - 1.0f;
        float f2 = n == n3 ? 1.0f : 2.0f * (float)n3 / (float)n - 1.0f;
        return new float[]{-1.0f, f, f2, f, -1.0f, 1.0f, f2, 1.0f};
    }

    @Override
    public void release() {
        for (Shader shader : this.shaders.values()) {
            shader.glShader.release();
        }
        this.shaders.clear();
    }

    private static class Shader {
        public final GlShader glShader;
        public final int texMatrixLocation;

        public Shader(String string) {
            this.glShader = new GlShader(GlRectDrawer.VERTEX_SHADER_STRING, string);
            this.texMatrixLocation = this.glShader.getUniformLocation("texMatrix");
        }
    }
}

