/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import android.opengl.GLES20;
import android.opengl.Matrix;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class GlUtil {
    public static final float[] IDENTITY_MATRIX = new float[16];

    private GlUtil() {
    }

    public static void checkNoGLES2Error(String string) {
        int n = GLES20.glGetError();
        if (n != 0) {
            throw new RuntimeException(string + ": GLES20 error: " + n);
        }
    }

    public static FloatBuffer createFloatBuffer(float[] fArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(fArray.length * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        floatBuffer.put(fArray);
        floatBuffer.position(0);
        return floatBuffer;
    }

    public static int generateTexture(int n) {
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        int n2 = nArray[0];
        GLES20.glBindTexture((int)n, (int)n2);
        GLES20.glTexParameterf((int)n, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)n, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)n, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)n, (int)10243, (float)33071.0f);
        GlUtil.checkNoGLES2Error("generateTexture");
        return n2;
    }

    public static int generateTexture(int n, boolean bl) {
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        int n2 = nArray[0];
        GLES20.glBindTexture((int)n, (int)n2);
        GLES20.glTexParameterf((int)n, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)n, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)n, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)n, (int)10243, (float)33071.0f);
        if (bl) {
            GlUtil.checkNoGLES2Error("generateTexture2");
        }
        return n2;
    }

    static {
        Matrix.setIdentityM((float[])IDENTITY_MATRIX, (int)0);
    }
}

