/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import io.agora.rtc.gl.VideoFrame;
import java.nio.ByteBuffer;

public class JavaI420Buffer
implements VideoFrame.I420Buffer {
    private final int width;
    private final int height;
    private final ByteBuffer dataY;
    private final ByteBuffer dataU;
    private final ByteBuffer dataV;
    private final int strideY;
    private final int strideU;
    private final int strideV;
    private final Runnable releaseCallback;
    private final Object refCountLock = new Object();
    private int refCount;

    private JavaI420Buffer(int n, int n2, ByteBuffer byteBuffer, int n3, ByteBuffer byteBuffer2, int n4, ByteBuffer byteBuffer3, int n5, Runnable runnable) {
        this.width = n;
        this.height = n2;
        this.dataY = byteBuffer;
        this.dataU = byteBuffer2;
        this.dataV = byteBuffer3;
        this.strideY = n3;
        this.strideU = n4;
        this.strideV = n5;
        this.releaseCallback = runnable;
        this.refCount = 1;
    }

    public static JavaI420Buffer wrap(int n, int n2, ByteBuffer byteBuffer, int n3, ByteBuffer byteBuffer2, int n4, ByteBuffer byteBuffer3, int n5, Runnable runnable) {
        if (byteBuffer == null || byteBuffer2 == null || byteBuffer3 == null) {
            throw new IllegalArgumentException("Data buffers cannot be null.");
        }
        if (!(byteBuffer.isDirect() && byteBuffer2.isDirect() && byteBuffer3.isDirect())) {
            throw new IllegalArgumentException("Data buffers must be direct byte buffers.");
        }
        byteBuffer = byteBuffer.slice();
        byteBuffer2 = byteBuffer2.slice();
        byteBuffer3 = byteBuffer3.slice();
        int n6 = (n2 + 1) / 2;
        int n7 = n3 * n2;
        int n8 = n4 * n6;
        int n9 = n5 * n6;
        if (byteBuffer.capacity() < n7) {
            throw new IllegalArgumentException("Y-buffer must be at least " + n7 + " bytes.");
        }
        if (byteBuffer2.capacity() < n8) {
            throw new IllegalArgumentException("U-buffer must be at least " + n8 + " bytes.");
        }
        if (byteBuffer3.capacity() < n9) {
            throw new IllegalArgumentException("V-buffer must be at least " + n9 + " bytes.");
        }
        return new JavaI420Buffer(n, n2, byteBuffer, n3, byteBuffer2, n4, byteBuffer3, n5, runnable);
    }

    public static JavaI420Buffer createYUV(byte[] byArray, int n, int n2) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        JavaI420Buffer javaI420Buffer = JavaI420Buffer.allocate(n, n2);
        ByteBuffer byteBuffer = javaI420Buffer.getDataY();
        ByteBuffer byteBuffer2 = javaI420Buffer.getDataU();
        ByteBuffer byteBuffer3 = javaI420Buffer.getDataV();
        int n3 = (n2 + 1) / 2;
        int n4 = n2 * javaI420Buffer.getStrideY();
        int n5 = n3 * javaI420Buffer.getStrideU();
        int n6 = n3 * javaI420Buffer.getStrideV();
        byteBuffer.put(byArray, 0, n4);
        byteBuffer2.put(byArray, n4, n5);
        byteBuffer3.put(byArray, n4 + n5, n6);
        return javaI420Buffer;
    }

    public static JavaI420Buffer allocate(int n, int n2) {
        int n3 = (n2 + 1) / 2;
        int n4 = (n + 1) / 2;
        int n5 = 0;
        int n6 = n5 + n * n2;
        int n7 = n6 + n4 * n3;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * n2 + 2 * n4 * n3);
        byteBuffer.position(n5);
        byteBuffer.limit(n6);
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer.position(n6);
        byteBuffer.limit(n7);
        ByteBuffer byteBuffer3 = byteBuffer.slice();
        byteBuffer.position(n7);
        byteBuffer.limit(n7 + n4 * n3);
        ByteBuffer byteBuffer4 = byteBuffer.slice();
        return new JavaI420Buffer(n, n2, byteBuffer2, n, byteBuffer3, n4, byteBuffer4, n4, null);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public ByteBuffer getDataY() {
        return this.dataY.slice();
    }

    @Override
    public ByteBuffer getDataU() {
        return this.dataU.slice();
    }

    @Override
    public ByteBuffer getDataV() {
        return this.dataV.slice();
    }

    @Override
    public int getStrideY() {
        return this.strideY;
    }

    @Override
    public int getStrideU() {
        return this.strideU;
    }

    @Override
    public int getStrideV() {
        return this.strideV;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        this.retain();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retain() {
        Object object = this.refCountLock;
        synchronized (object) {
            ++this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.refCountLock;
        synchronized (object) {
            if (--this.refCount == 0 && this.releaseCallback != null) {
                this.releaseCallback.run();
            }
        }
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int n, int n2, int n3, int n4, int n5, int n6) {
        return VideoFrame.cropAndScaleI420(this, n, n2, n3, n4, n5, n6);
    }
}

