/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import android.graphics.Point;
import android.opengl.Matrix;
import android.view.View;

public class RendererCommon {
    private static float BALANCED_VISIBLE_FRACTION = 0.5625f;

    public static final float[] identityMatrix() {
        return new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    }

    public static final float[] verticalFlipMatrix() {
        return new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f};
    }

    public static final float[] horizontalFlipMatrix() {
        return new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
    }

    public static float[] rotateTextureMatrix(float[] fArray, float f) {
        float[] fArray2 = new float[16];
        Matrix.setRotateM((float[])fArray2, (int)0, (float)f, (float)0.0f, (float)0.0f, (float)1.0f);
        RendererCommon.adjustOrigin(fArray2);
        return RendererCommon.multiplyMatrices(fArray, fArray2);
    }

    public static float[] multiplyMatrices(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[16];
        Matrix.multiplyMM((float[])fArray3, (int)0, (float[])fArray, (int)0, (float[])fArray2, (int)0);
        return fArray3;
    }

    public static float[] getLayoutMatrix(boolean bl, float f, float f2) {
        float f3 = 1.0f;
        float f4 = 1.0f;
        if (f2 > f) {
            f4 = f / f2;
        } else {
            f3 = f2 / f;
        }
        if (bl) {
            f3 *= -1.0f;
        }
        float[] fArray = new float[16];
        Matrix.setIdentityM((float[])fArray, (int)0);
        Matrix.scaleM((float[])fArray, (int)0, (float)f3, (float)f4, (float)1.0f);
        RendererCommon.adjustOrigin(fArray);
        return fArray;
    }

    public static android.graphics.Matrix convertMatrixToAndroidGraphicsMatrix(float[] fArray) {
        float[] fArray2 = new float[]{fArray[0], fArray[4], fArray[12], fArray[1], fArray[5], fArray[13], fArray[3], fArray[7], fArray[15]};
        android.graphics.Matrix matrix = new android.graphics.Matrix();
        matrix.setValues(fArray2);
        return matrix;
    }

    public static float[] convertMatrixFromAndroidGraphicsMatrix(android.graphics.Matrix matrix) {
        float[] fArray = new float[9];
        matrix.getValues(fArray);
        float[] fArray2 = new float[]{fArray[0], fArray[3], 0.0f, fArray[6], fArray[1], fArray[4], 0.0f, fArray[7], 0.0f, 0.0f, 1.0f, 0.0f, fArray[2], fArray[5], 0.0f, fArray[8]};
        return fArray2;
    }

    public static Point getDisplaySize(ScalingType scalingType, float f, int n, int n2) {
        return RendererCommon.getDisplaySize(RendererCommon.convertScalingTypeToVisibleFraction(scalingType), f, n, n2);
    }

    private static void adjustOrigin(float[] fArray) {
        fArray[12] = fArray[12] - 0.5f * (fArray[0] + fArray[4]);
        fArray[13] = fArray[13] - 0.5f * (fArray[1] + fArray[5]);
        fArray[12] = fArray[12] + 0.5f;
        fArray[13] = fArray[13] + 0.5f;
    }

    private static float convertScalingTypeToVisibleFraction(ScalingType scalingType) {
        switch (scalingType) {
            case SCALE_ASPECT_FIT: {
                return 1.0f;
            }
            case SCALE_ASPECT_FILL: {
                return 0.0f;
            }
            case SCALE_ASPECT_BALANCED: {
                return BALANCED_VISIBLE_FRACTION;
            }
        }
        throw new IllegalArgumentException();
    }

    private static Point getDisplaySize(float f, float f2, int n, int n2) {
        if (f == 0.0f || f2 == 0.0f) {
            return new Point(n, n2);
        }
        int n3 = Math.min(n, Math.round((float)n2 / f * f2));
        int n4 = Math.min(n2, Math.round((float)n / f / f2));
        return new Point(n3, n4);
    }

    public static enum ScalingType {
        SCALE_ASPECT_FIT,
        SCALE_ASPECT_FILL,
        SCALE_ASPECT_BALANCED;

    }

    public static class VideoLayoutMeasure {
        private ScalingType scalingTypeMatchOrientation = ScalingType.SCALE_ASPECT_BALANCED;
        private ScalingType scalingTypeMismatchOrientation = ScalingType.SCALE_ASPECT_BALANCED;

        public void setScalingType(ScalingType scalingType) {
            this.scalingTypeMatchOrientation = scalingType;
            this.scalingTypeMismatchOrientation = scalingType;
        }

        public void setScalingType(ScalingType scalingType, ScalingType scalingType2) {
            this.scalingTypeMatchOrientation = scalingType;
            this.scalingTypeMismatchOrientation = scalingType2;
        }

        public Point measure(int n, int n2, int n3, int n4) {
            int n5 = View.getDefaultSize((int)Integer.MAX_VALUE, (int)n);
            int n6 = View.getDefaultSize((int)Integer.MAX_VALUE, (int)n2);
            if (n3 == 0 || n4 == 0 || n5 == 0 || n6 == 0) {
                return new Point(n5, n6);
            }
            float f = (float)n3 / (float)n4;
            float f2 = (float)n5 / (float)n6;
            ScalingType scalingType = f > 1.0f == f2 > 1.0f ? this.scalingTypeMatchOrientation : this.scalingTypeMismatchOrientation;
            Point point = RendererCommon.getDisplaySize(scalingType, f, n5, n6);
            if (View.MeasureSpec.getMode((int)n) == 0x40000000) {
                point.x = n5;
            }
            if (View.MeasureSpec.getMode((int)n2) == 0x40000000) {
                point.y = n6;
            }
            return point;
        }
    }

    public static interface GlDrawer {
        public void drawOes(int var1, float[] var2, int var3, int var4, int var5, int var6, int var7, int var8);

        public void drawRgb(int var1, float[] var2, int var3, int var4, int var5, int var6, int var7, int var8);

        public void drawYuv(int[] var1, float[] var2, int var3, int var4, int var5, int var6, int var7, int var8);

        public void release();
    }

    public static interface RendererEvents {
        public void onFirstFrameRendered();

        public void onFrameResolutionChanged(int var1, int var2, int var3);
    }
}

