/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import android.graphics.Matrix;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.GlRectDrawer;
import io.agora.rtc.gl.GlUtil;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.gl.TextureBufferImpl;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.gl.YuvConverter;
import io.agora.rtc.internal.ATrace;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.utils.ThreadUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

public class TextureBufferPool {
    private static final boolean VERBOSE = false;
    private static final String TAG = TextureBufferPool.class.getSimpleName();
    private static final AtomicInteger nextSeq = new AtomicInteger(0);
    private final String name;
    private final Handler handler;
    private final boolean ownGlThread;
    private final EglBase eglBase;
    private final EglBase.Context eglContext;
    private final YuvConverter yuvConverter;
    private final GlRectDrawer drawer;
    private final boolean shrinkPool = true;
    private final int glPixelFormat;
    private final int maxBufferCnt;
    private final int keepBufferCnt;
    private final ArrayList<TextureInfo> textureInfoList = new ArrayList();
    private boolean isQuitting = false;
    private int dropCount = 0;

    public static TextureBufferPool create(final String string, final EglBase.Context context, final int n) {
        HandlerThread handlerThread = new HandlerThread(string);
        handlerThread.start();
        final Handler handler = new Handler(handlerThread.getLooper());
        return ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<TextureBufferPool>(){

            @Override
            public TextureBufferPool call() {
                try {
                    EglBase eglBase = EglBase.create(context, EglBase.CONFIG_PIXEL_BUFFER);
                    try {
                        eglBase.createDummyPbufferSurface();
                        eglBase.makeCurrent();
                    }
                    catch (RuntimeException runtimeException) {
                        Logging.e(TAG, string + " failed to create pbufferSurface!!");
                        eglBase.release();
                        handler.getLooper().quit();
                        throw runtimeException;
                    }
                    return new TextureBufferPool(string, n, 6408, handler, true, eglBase, null);
                }
                catch (RuntimeException runtimeException) {
                    Logging.e(TAG, string + " create failure", runtimeException);
                    return null;
                }
            }
        });
    }

    public static TextureBufferPool createWithinGlThread(String string, int n, int n2, Handler handler, EglBase eglBase, YuvConverter yuvConverter) {
        return new TextureBufferPool(string, n, n2, handler, false, eglBase, yuvConverter);
    }

    private TextureBufferPool(String string, int n, int n2, Handler handler, boolean bl, EglBase eglBase, YuvConverter yuvConverter) {
        Logging.i(TAG, string + " init buffer pool, ownGlThread: " + bl + " cnt: " + n);
        this.name = string;
        this.maxBufferCnt = Math.max(n, 1);
        this.keepBufferCnt = Math.min(this.maxBufferCnt, 3);
        this.glPixelFormat = n2;
        this.handler = handler;
        this.ownGlThread = bl;
        this.eglBase = eglBase;
        this.yuvConverter = yuvConverter != null ? yuvConverter : new YuvConverter();
        this.eglContext = eglBase.getEglBaseContext();
        this.drawer = new GlRectDrawer();
    }

    public VideoFrame.TextureBuffer textureCopy(VideoFrame.TextureBuffer textureBuffer, Runnable runnable) {
        if (textureBuffer == null) {
            return null;
        }
        return this.textureCopy(textureBuffer.getTextureId(), textureBuffer.getType(), textureBuffer.getWidth(), textureBuffer.getHeight(), textureBuffer.getTransformMatrix(), runnable);
    }

    public VideoFrame.TextureBuffer textureCopy(final int n, final VideoFrame.TextureBuffer.Type type, final int n2, final int n3, final Matrix matrix, final Runnable runnable) {
        return ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Callable<VideoFrame.TextureBuffer>(){

            @Override
            public VideoFrame.TextureBuffer call() throws Exception {
                return TextureBufferPool.this.doTextureCopy(n, type, n2, n3, matrix, runnable);
            }
        });
    }

    public void dispose() {
        Logging.i(TAG, this.name + " dispose()");
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Runnable(){

            @Override
            public void run() {
                TextureBufferPool.this.isQuitting = true;
                if (!TextureBufferPool.this.anyTextureInUse()) {
                    Logging.i(TAG, TextureBufferPool.this.name + " ready to release since no more buffer in flight");
                    TextureBufferPool.this.release();
                }
            }
        });
    }

    private VideoFrame.TextureBuffer doTextureCopy(int n, VideoFrame.TextureBuffer.Type type, int n2, int n3, Matrix matrix, final Runnable runnable) {
        VideoFrame.TextureBuffer[] textureBufferArray;
        final TextureInfo textureInfo = this.acquireTextureFramebuffer();
        if (textureInfo == null) {
            return null;
        }
        ATrace.beginSection("setupTextureFrameBuffer");
        boolean bl = this.setupTextureFrameBuffer(textureInfo, n2, n3);
        ATrace.endSection();
        if (!bl) {
            this.releaseTextureFramebuffer(textureInfo);
            return null;
        }
        GLES20.glBindFramebuffer((int)36160, (int)textureInfo.frameBufferId);
        ATrace.beginSection("drawTexture");
        this.drawTexture(n, type, n2, n3);
        ATrace.endSection();
        ATrace.beginSection("flush");
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glUseProgram((int)0);
        GLES20.glFlush();
        ATrace.endSection();
        textureBufferArray = new VideoFrame.TextureBuffer[]{new TextureBufferImpl(this.eglContext, n2, n3, VideoFrame.TextureBuffer.Type.RGB, textureInfo.textureId, matrix, this.handler, this.yuvConverter, new Runnable(){

            @Override
            public void run() {
                TextureBufferPool.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        TextureBufferPool.this.releaseTextureFramebuffer(textureInfo);
                        if (TextureBufferPool.this.isQuitting && !TextureBufferPool.this.anyTextureInUse()) {
                            Logging.i(TAG, TextureBufferPool.this.name + " ready to release since no buffer in flight");
                            TextureBufferPool.this.release();
                        }
                        if (runnable != null) {
                            runnable.run();
                        }
                    }
                });
            }
        }, nextSeq.getAndIncrement())};
        return textureBufferArray[0];
    }

    private TextureInfo acquireTextureFramebuffer() {
        TextureInfo textureInfo = null;
        for (TextureInfo object : this.textureInfoList) {
            if (object.inUse) continue;
            textureInfo = object;
            break;
        }
        if (textureInfo == null) {
            if (this.textureInfoList.size() >= this.maxBufferCnt) {
                ++this.dropCount;
                ATrace.traceCounter("Drop@TexPool", this.dropCount);
                return null;
            }
            int n = GlUtil.generateTexture(3553);
            int[] nArray = new int[1];
            GLES20.glGenFramebuffers((int)1, (int[])nArray, (int)0);
            textureInfo = new TextureInfo(n, nArray[0]);
            this.textureInfoList.add(textureInfo);
        }
        textureInfo.inUse = true;
        return textureInfo;
    }

    private void releaseTextureFramebuffer(TextureInfo textureInfo) {
        textureInfo.inUse = false;
        int n = this.textureInfoList.indexOf(textureInfo);
        if (n < 0) {
            Logging.e(TAG, "texture info not found!");
        } else if (n >= this.keepBufferCnt) {
            GLES20.glDeleteTextures((int)1, (int[])new int[]{textureInfo.textureId}, (int)0);
            GLES20.glDeleteFramebuffers((int)1, (int[])new int[]{textureInfo.frameBufferId}, (int)0);
            this.textureInfoList.remove(n);
        }
    }

    private boolean setupTextureFrameBuffer(TextureInfo textureInfo, int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            Logging.w(TAG, "Invalid size: " + n + "x" + n2);
            return false;
        }
        if (textureInfo.specified && textureInfo.width == n && textureInfo.height == n2) {
            return true;
        }
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)textureInfo.textureId);
        ATrace.beginSection("glTexImage2D");
        GLES20.glTexImage2D((int)3553, (int)0, (int)this.glPixelFormat, (int)n, (int)n2, (int)0, (int)this.glPixelFormat, (int)5121, null);
        ATrace.endSection();
        GlUtil.checkNoGLES2Error("TextureBufferPool.glTexImage2D");
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)textureInfo.frameBufferId);
        ATrace.beginSection("glFramebufferTexture2D");
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)textureInfo.textureId, (int)0);
        ATrace.endSection();
        int n3 = GLES20.glCheckFramebufferStatus((int)36160);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        if (n3 != 36053) {
            Logging.w(TAG, "Framebuffer not complete, status: " + n3);
            return false;
        }
        textureInfo.specified = true;
        textureInfo.width = n;
        textureInfo.height = n2;
        return true;
    }

    private void drawTexture(int n, VideoFrame.TextureBuffer.Type type, int n2, int n3) {
        GLES20.glClear((int)16384);
        switch (type) {
            case OES: {
                this.drawer.drawOes(n, GlUtil.IDENTITY_MATRIX, n2, n3, 0, 0, n2, n3);
                break;
            }
            case RGB: {
                this.drawer.drawRgb(n, GlUtil.IDENTITY_MATRIX, n2, n3, 0, 0, n2, n3);
                break;
            }
            default: {
                throw new RuntimeException("Unknown texture type.");
            }
        }
        GlUtil.checkNoGLES2Error("TextureBufferPool.drawFrameBuffer");
    }

    boolean anyTextureInUse() {
        for (TextureInfo textureInfo : this.textureInfoList) {
            if (!textureInfo.inUse) continue;
            return true;
        }
        return false;
    }

    private void release() {
        Logging.i(TAG, this.name + " release()");
        if (!this.textureInfoList.isEmpty()) {
            int n = this.textureInfoList.size();
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            for (int i = 0; i < n; ++i) {
                TextureInfo textureInfo = this.textureInfoList.get(i);
                nArray[i] = textureInfo.textureId;
                nArray2[i] = textureInfo.frameBufferId;
            }
            Logging.d(TAG, this.name + ": delete textures " + Arrays.toString(nArray));
            GLES20.glDeleteTextures((int)nArray.length, (int[])nArray, (int)0);
            GLES20.glDeleteFramebuffers((int)1, (int[])nArray2, (int)0);
            this.textureInfoList.clear();
        }
        this.drawer.release();
        if (this.ownGlThread) {
            if (this.eglBase != null) {
                this.eglBase.release();
            }
            this.handler.getLooper().quit();
        }
    }

    public VideoFrame.TextureBuffer makeTextureBuffer(int n, int n2, int n3, int n4, float[] fArray) {
        Matrix matrix = fArray == null ? new Matrix() : RendererCommon.convertMatrixToAndroidGraphicsMatrix(fArray);
        return new TextureBufferImpl(this.eglContext, n3, n4, TextureBufferPool.agoraFrameTypeToTextureBufferType(n), n2, matrix, this.handler, this.yuvConverter, null, nextSeq.getAndIncrement());
    }

    public static VideoFrame.TextureBuffer makeTextureBuffer(EglBase.Context context, int n, int n2, int n3, int n4, float[] fArray, Handler handler, YuvConverter yuvConverter, Runnable runnable) {
        Matrix matrix = fArray == null ? new Matrix() : RendererCommon.convertMatrixToAndroidGraphicsMatrix(fArray);
        return new TextureBufferImpl(context == null ? EglBase.getCurrentContext() : context, n3, n4, TextureBufferPool.agoraFrameTypeToTextureBufferType(n), n2, matrix, handler, yuvConverter, runnable, nextSeq.getAndIncrement());
    }

    public static VideoFrame.TextureBuffer.Type agoraFrameTypeToTextureBufferType(int n) {
        return n == 11 ? VideoFrame.TextureBuffer.Type.OES : VideoFrame.TextureBuffer.Type.RGB;
    }

    private static class TextureInfo {
        int textureId;
        int frameBufferId;
        boolean inUse;
        boolean specified;
        int width;
        int height;

        public TextureInfo(int n, int n2) {
            this.textureId = n;
            this.frameBufferId = n2;
            this.inUse = false;
            this.specified = false;
            this.width = 0;
            this.height = 0;
        }

        public String toString() {
            return "TextureInfo{textureId=" + this.textureId + ", frameBufferId=" + this.frameBufferId + ", inUse=" + this.inUse + ", specified=" + this.specified + ", width=" + this.width + ", height=" + this.height + '}';
        }
    }
}

