/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import android.opengl.GLES20;
import android.opengl.Matrix;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class TextureConverter {
    public static final int CV_TYPE_OES2OES = 0;
    public static final int CV_TYPE_2D2OES = 1;
    public static final int CV_TYPE_OES22D = 2;
    private static final String VERTEX_SHADER_STRING = "#version 300 es\nuniform mat4 uMVPMatrix;\nuniform mat4 uSTMatrix;\nin vec4 aPosition;\nin vec4 aTextureCoord;\nout vec2 vTextureCoord;\nvoid main() {\ngl_Position = uMVPMatrix * aPosition;\nvTextureCoord = (uSTMatrix * aTextureCoord).st;\n}\n";
    private static final String TEXTURE_2D2OES_FRAGMENT_SHADER_STRING = "#version 300 es\n#extension GL_OES_EGL_image_external_essl3 : require\n#extension GL_EXT_YUV_target : require\nin vec2 vTextureCoord;\nuniform __samplerExternal2DY2YEXT uTextureSampler;\nlayout(yuv) out vec4 gl_FragColor;\nvoid main() {\ngl_FragColor = texture(uTextureSampler, vTextureCoord);\n}\n";
    private static final String TEXTURE_OES_FRAGMENT_SHADER_STRING = "#version 300 es\n#extension GL_OES_EGL_image_external_essl3 : require\nin vec2 vTextureCoord;\nuniform samplerExternalOES uTextureSampler;\nout vec4 gl_FragColor;\nvoid main() {\ngl_FragColor = texture(uTextureSampler, vTextureCoord);\n}\n";
    private static final String TEXTURE_OES2OES_FRAGMENT_SHADER_STRING = "#version 300 es\n#extension GL_OES_EGL_image_external_essl3 : require\n#extension GL_EXT_YUV_target : require\nin vec2 vTextureCoord;\nuniform __samplerExternal2DY2YEXT uTextureSampler;\nlayout(yuv) out vec4 gl_FragColor;\nvoid main() {\ngl_FragColor = texture(uTextureSampler, vTextureCoord);\n}\n";
    private final int mProgram;
    private int mPositionHandle;
    private int mTextureCoordHandle;
    private int mMVPMatrixHandle;
    private int mSTMatrixHandle;
    private int mTextureHandle;
    private float[] mMVPMatrix = new float[16];
    private float[] mSTMatrix = new float[16];
    private final int vertexCount = rectCoords.length / 3;
    private final int vertexStride = 12;
    private FloatBuffer vertexBuffer;
    private FloatBuffer textureCoordBuffer;
    private int mTextureID;
    private int mTextureTarget;
    private int[] mFrameBuffer;
    static final int COORDS_PER_VERTEX = 3;
    static final float[] rectCoords = new float[]{-1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, -1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f};
    static final float[] textureCoords = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};

    public TextureConverter(int n, int n2, int n3) {
        Matrix.setIdentityM((float[])this.mMVPMatrix, (int)0);
        Matrix.setIdentityM((float[])this.mSTMatrix, (int)0);
        this.vertexBuffer = this.arrayToBuffer(rectCoords);
        this.textureCoordBuffer = this.arrayToBuffer(textureCoords);
        this.mTextureID = n;
        this.mTextureTarget = n2;
        int n4 = this.loadShader(35633, VERTEX_SHADER_STRING);
        int n5 = 0;
        switch (n3) {
            case 0: {
                n5 = this.loadShader(35632, "#version 300 es\n#extension GL_OES_EGL_image_external_essl3 : require\n#extension GL_EXT_YUV_target : require\nin vec2 vTextureCoord;\nuniform __samplerExternal2DY2YEXT uTextureSampler;\nlayout(yuv) out vec4 gl_FragColor;\nvoid main() {\ngl_FragColor = texture(uTextureSampler, vTextureCoord);\n}\n");
                break;
            }
            case 1: {
                n5 = this.loadShader(35632, "#version 300 es\n#extension GL_OES_EGL_image_external_essl3 : require\n#extension GL_EXT_YUV_target : require\nin vec2 vTextureCoord;\nuniform __samplerExternal2DY2YEXT uTextureSampler;\nlayout(yuv) out vec4 gl_FragColor;\nvoid main() {\ngl_FragColor = texture(uTextureSampler, vTextureCoord);\n}\n");
                break;
            }
            case 2: {
                n5 = this.loadShader(35632, TEXTURE_OES_FRAGMENT_SHADER_STRING);
                break;
            }
            default: {
                n5 = this.loadShader(35632, "#version 300 es\n#extension GL_OES_EGL_image_external_essl3 : require\n#extension GL_EXT_YUV_target : require\nin vec2 vTextureCoord;\nuniform __samplerExternal2DY2YEXT uTextureSampler;\nlayout(yuv) out vec4 gl_FragColor;\nvoid main() {\ngl_FragColor = texture(uTextureSampler, vTextureCoord);\n}\n");
            }
        }
        this.mProgram = this.createProgram(n4, n5);
        this.mPositionHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"aPosition");
        this.mTextureCoordHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"aTextureCoord");
        this.mMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uMVPMatrix");
        this.mSTMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uSTMatrix");
        this.mTextureHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uTextureSampler");
    }

    public int getOneTexture(int n) {
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        GLES20.glBindTexture((int)n, (int)nArray[0]);
        GLES20.glTexParameterf((int)n, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)n, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)n, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)n, (int)10243, (float)33071.0f);
        return nArray[0];
    }

    public void convert(int n, int n2) {
        this.beginRenderTarget(n, n2);
        this.draw();
        GLES20.glFinish();
        this.endRenderTarget();
    }

    public void release() {
        if (this.mFrameBuffer != null) {
            GLES20.glDeleteFramebuffers((int)1, (int[])this.mFrameBuffer, (int)0);
        }
    }

    private void draw() {
        GLES20.glUseProgram((int)this.mProgram);
        GLES20.glEnableVertexAttribArray((int)this.mPositionHandle);
        GLES20.glVertexAttribPointer((int)this.mPositionHandle, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)this.vertexBuffer);
        GLES20.glEnableVertexAttribArray((int)this.mTextureCoordHandle);
        GLES20.glVertexAttribPointer((int)this.mTextureCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.textureCoordBuffer);
        GLES20.glActiveTexture((int)33987);
        GLES20.glBindTexture((int)this.mTextureTarget, (int)this.mTextureID);
        GLES20.glUniform1i((int)this.mTextureHandle, (int)3);
        GLES20.glUniformMatrix4fv((int)this.mMVPMatrixHandle, (int)1, (boolean)false, (float[])this.mMVPMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.mSTMatrixHandle, (int)1, (boolean)false, (float[])this.mSTMatrix, (int)0);
        GLES20.glDrawArrays((int)5, (int)0, (int)this.vertexCount);
        GLES20.glDisableVertexAttribArray((int)this.mPositionHandle);
    }

    private void beginRenderTarget(int n, int n2) {
        if (this.mFrameBuffer == null) {
            this.mFrameBuffer = new int[1];
            GLES20.glGenFramebuffers((int)1, (int[])this.mFrameBuffer, (int)0);
            this.checkGlError();
        }
        GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBuffer[0]);
        this.checkGlError();
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)n, (int)n2, (int)0);
        this.checkFramebufferStatus();
    }

    private void endRenderTarget() {
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glBindTexture((int)this.mTextureTarget, (int)0);
        this.checkGlError();
    }

    private int createProgram(int ... nArray) {
        int n = GLES20.glCreateProgram();
        if (n == 0) {
            return n;
        }
        for (int n2 : nArray) {
            GLES20.glAttachShader((int)n, (int)n2);
        }
        GLES20.glLinkProgram((int)n);
        int[] nArray2 = new int[1];
        GLES20.glGetProgramiv((int)n, (int)35714, (int[])nArray2, (int)0);
        if (nArray2[0] != 1) {
            GLES20.glDeleteProgram((int)n);
            n = 0;
        }
        return n;
    }

    private int loadShader(int n, String string) {
        int n2 = GLES20.glCreateShader((int)n);
        if (n2 == 0) {
            return n2;
        }
        GLES20.glShaderSource((int)n2, (String)string);
        GLES20.glCompileShader((int)n2);
        int[] nArray = new int[1];
        GLES20.glGetShaderiv((int)n2, (int)35713, (int[])nArray, (int)0);
        if (nArray[0] == 0) {
            GLES20.glDeleteShader((int)n2);
            n2 = 0;
        }
        return n2;
    }

    private void checkGlError() {
        int n = GLES20.glGetError();
        if (n != 0) {
            String string = "";
            switch (n) {
                case 1280: {
                    string = "GL_INVALID_ENUM";
                    break;
                }
                case 1281: {
                    string = "GL_INVALID_VALUE";
                    break;
                }
                case 1282: {
                    string = "GL_INVALID_OPERATION";
                    break;
                }
                case 1286: {
                    string = "GL_INVALID_FRAMEBUFFER_OPERATION";
                    break;
                }
                case 1285: {
                    string = "GL_OUT_OF_MEMORY";
                }
            }
            Throwable throwable = new Throwable();
        }
    }

    private void checkFramebufferStatus() {
        int n = GLES20.glCheckFramebufferStatus((int)36160);
        if (n != 36053) {
            String string = "";
            switch (n) {
                case 36054: {
                    string = "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT";
                    break;
                }
                case 36057: {
                    string = "GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS";
                    break;
                }
                case 36055: {
                    string = "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT";
                    break;
                }
                case 36061: {
                    string = "GL_FRAMEBUFFER_UNSUPPORTED";
                }
            }
            throw new RuntimeException(string + " : 0x" + Integer.toHexString(n));
        }
    }

    private FloatBuffer arrayToBuffer(float[] fArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(fArray.length * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        floatBuffer.put(fArray);
        floatBuffer.position(0);
        return floatBuffer;
    }
}

