/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import android.opengl.GLES20;
import android.opengl.Matrix;
import io.agora.rtc.gl.GlRectDrawer;
import io.agora.rtc.gl.GlTextureFrameBuffer;
import io.agora.rtc.gl.GlUtil;
import io.agora.rtc.utils.ThreadUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

public class TextureTransformer {
    private static final String TAG = TextureTransformer.class.getSimpleName();
    private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();
    private final GlTextureFrameBuffer[] textureFrameBuffer;
    private final GlRectDrawer drawer;
    private final int maxBufferSlot;
    private final Map<Integer, Integer> textureId2SlotMap = new HashMap<Integer, Integer>();
    private final ConcurrentLinkedQueue<Integer> freeSlots = new ConcurrentLinkedQueue();
    public static final float[] IDENTITY_MATRIX = new float[16];

    public TextureTransformer(int n) {
        this.threadChecker.checkIsOnValidThread();
        this.maxBufferSlot = Math.max(n, 1);
        this.textureFrameBuffer = new GlTextureFrameBuffer[n];
        for (int i = 0; i < n; ++i) {
            this.textureFrameBuffer[i] = new GlTextureFrameBuffer(6408);
            this.textureId2SlotMap.put(this.textureFrameBuffer[i].getTextureId(), i);
            this.freeSlots.offer(i);
        }
        this.drawer = new GlRectDrawer();
    }

    public int copy(int n, int n2, int n3, int n4) {
        this.threadChecker.checkIsOnValidThread();
        Integer n5 = this.freeSlots.poll();
        if (n5 == null) {
            return -1;
        }
        int n6 = n3;
        int n7 = n4;
        int n8 = n6;
        int n9 = n7;
        this.textureFrameBuffer[n5].setSize(n8, n9);
        GLES20.glBindFramebuffer((int)36160, (int)this.textureFrameBuffer[n5].getFrameBufferId());
        GlUtil.checkNoGLES2Error("TextureHelper.glBindFramebuffer");
        GLES20.glClear((int)16384);
        switch (n2) {
            case 11: {
                this.drawer.drawOes(n, IDENTITY_MATRIX, n6, n7, 0, 0, n8, n9);
                break;
            }
            case 10: {
                this.drawer.drawRgb(n, IDENTITY_MATRIX, n6, n7, 0, 0, n8, n9);
                break;
            }
            default: {
                throw new RuntimeException("Unknown texture type.");
            }
        }
        GlUtil.checkNoGLES2Error("TextureHelper.draw");
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glFlush();
        int n10 = this.textureFrameBuffer[n5].getTextureId();
        this.freeSlots.offer(this.textureId2SlotMap.get(n10));
        return n10;
    }

    public void release() {
        this.threadChecker.checkIsOnValidThread();
        for (int i = 0; i < this.maxBufferSlot; ++i) {
            this.textureFrameBuffer[i].release();
        }
        this.drawer.release();
    }

    static {
        Matrix.setIdentityM((float[])IDENTITY_MATRIX, (int)0);
    }
}

