/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import android.graphics.Matrix;
import android.graphics.Point;
import android.opengl.GLES20;
import io.agora.rtc.gl.GlUtil;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.gl.RgbaBuffer;
import io.agora.rtc.gl.VideoFrame;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class VideoFrameDrawer {
    static final float[] srcPoints = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
    private final float[] dstPoints = new float[6];
    private final Point renderSize = new Point();
    private int renderWidth;
    private int renderHeight;
    private final YuvUploader yuvUploader = new YuvUploader();
    private VideoFrame lastI420Frame;
    private VideoFrame lastRgbaFrame;
    private final Matrix renderMatrix = new Matrix();
    private final RGBAUploader rgbaUploader = new RGBAUploader();

    static void drawTexture(RendererCommon.GlDrawer glDrawer, VideoFrame.TextureBuffer textureBuffer, Matrix matrix, int n, int n2, int n3, int n4, int n5, int n6) {
        Matrix matrix2 = new Matrix(textureBuffer.getTransformMatrix());
        matrix2.preConcat(matrix);
        float[] fArray = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(matrix2);
        switch (textureBuffer.getType()) {
            case OES: {
                glDrawer.drawOes(textureBuffer.getTextureId(), fArray, n, n2, n3, n4, n5, n6);
                break;
            }
            case RGB: {
                glDrawer.drawRgb(textureBuffer.getTextureId(), fArray, n, n2, n3, n4, n5, n6);
                break;
            }
            default: {
                throw new RuntimeException("Unknown texture type.");
            }
        }
    }

    private static int distance(float f, float f2, float f3, float f4) {
        return (int)Math.round(Math.hypot(f3 - f, f4 - f2));
    }

    private void calculateTransformedRenderSize(int n, int n2, Matrix matrix) {
        if (matrix == null) {
            this.renderWidth = n;
            this.renderHeight = n2;
            return;
        }
        matrix.mapPoints(this.dstPoints, srcPoints);
        for (int i = 0; i < 3; ++i) {
            int n3 = i * 2 + 0;
            this.dstPoints[n3] = this.dstPoints[n3] * (float)n;
            int n4 = i * 2 + 1;
            this.dstPoints[n4] = this.dstPoints[n4] * (float)n2;
        }
        this.renderWidth = VideoFrameDrawer.distance(this.dstPoints[0], this.dstPoints[1], this.dstPoints[2], this.dstPoints[3]);
        this.renderHeight = VideoFrameDrawer.distance(this.dstPoints[0], this.dstPoints[1], this.dstPoints[4], this.dstPoints[5]);
    }

    public void drawFrame(VideoFrame videoFrame, RendererCommon.GlDrawer glDrawer) {
        this.drawFrame(videoFrame, glDrawer, null);
    }

    public void drawFrame(VideoFrame videoFrame, RendererCommon.GlDrawer glDrawer, Matrix matrix) {
        this.drawFrame(videoFrame, glDrawer, matrix, 0, 0, videoFrame.getRotatedWidth(), videoFrame.getRotatedHeight());
    }

    public void drawFrame(VideoFrame videoFrame, RendererCommon.GlDrawer glDrawer, Matrix matrix, int n, int n2, int n3, int n4) {
        int n5 = videoFrame.getRotatedWidth();
        int n6 = videoFrame.getRotatedHeight();
        this.calculateTransformedRenderSize(n5, n6, matrix);
        boolean bl = videoFrame.getBuffer() instanceof VideoFrame.TextureBuffer;
        boolean bl2 = videoFrame.getBuffer() instanceof RgbaBuffer;
        this.renderMatrix.reset();
        this.renderMatrix.preTranslate(0.5f, 0.5f);
        if (!bl) {
            this.renderMatrix.preScale(1.0f, -1.0f);
        }
        this.renderMatrix.preRotate((float)videoFrame.getRotation());
        this.renderMatrix.preTranslate(-0.5f, -0.5f);
        if (matrix != null) {
            this.renderMatrix.preConcat(matrix);
        }
        if (bl) {
            this.lastI420Frame = null;
            this.lastRgbaFrame = null;
            VideoFrameDrawer.drawTexture(glDrawer, (VideoFrame.TextureBuffer)videoFrame.getBuffer(), this.renderMatrix, this.renderWidth, this.renderHeight, n, n2, n3, n4);
        } else if (bl2) {
            if (videoFrame != this.lastRgbaFrame) {
                this.lastRgbaFrame = videoFrame;
                RgbaBuffer rgbaBuffer = (RgbaBuffer)videoFrame.getBuffer();
                this.rgbaUploader.uploadData(rgbaBuffer.getBuffer(), rgbaBuffer.getWidth(), rgbaBuffer.getHeight());
                rgbaBuffer.release();
            }
            glDrawer.drawRgb(this.rgbaUploader.getTextureId(), RendererCommon.convertMatrixFromAndroidGraphicsMatrix(this.renderMatrix), this.renderWidth, this.renderHeight, n, n2, n3, n4);
        } else {
            if (videoFrame != this.lastI420Frame) {
                this.lastI420Frame = videoFrame;
                VideoFrame.I420Buffer i420Buffer = videoFrame.getBuffer().toI420();
                this.yuvUploader.uploadFromBuffer(i420Buffer);
                i420Buffer.release();
            }
            glDrawer.drawYuv(this.yuvUploader.getYuvTextures(), RendererCommon.convertMatrixFromAndroidGraphicsMatrix(this.renderMatrix), this.renderWidth, this.renderHeight, n, n2, n3, n4);
        }
    }

    public void release() {
        this.yuvUploader.release();
        this.lastI420Frame = null;
        this.rgbaUploader.release();
        this.lastRgbaFrame = null;
    }

    private static class RGBAUploader {
        private int mTextureId = 0;
        private ByteBuffer mData;

        private RGBAUploader() {
        }

        public int uploadData(ByteBuffer byteBuffer, int n, int n2) {
            this.mData = byteBuffer;
            if (this.mTextureId == 0) {
                this.mTextureId = GlUtil.generateTexture(3553);
            }
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)this.mTextureId);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)n, (int)n2, (int)0, (int)6408, (int)5121, (Buffer)this.mData);
            GlUtil.checkNoGLES2Error("glTexImage2D");
            return this.mTextureId;
        }

        public int getTextureId() {
            return this.mTextureId;
        }

        public void release() {
            this.mData = null;
            if (this.mTextureId != 0) {
                GLES20.glDeleteTextures((int)1, (int[])new int[]{this.mTextureId}, (int)0);
                this.mTextureId = 0;
            }
        }
    }

    private static class YuvUploader {
        private ByteBuffer copyBuffer;
        private int[] yuvTextures;

        private YuvUploader() {
        }

        public int[] uploadYuvData(int n, int n2, int[] nArray, ByteBuffer[] byteBufferArray) {
            int n3;
            int[] nArray2 = new int[]{n, n / 2, n / 2};
            int[] nArray3 = new int[]{n2, n2 / 2, n2 / 2};
            int n4 = 0;
            for (n3 = 0; n3 < 3; ++n3) {
                if (nArray[n3] <= nArray2[n3]) continue;
                n4 = Math.max(n4, nArray2[n3] * nArray3[n3]);
            }
            if (n4 > 0 && (this.copyBuffer == null || this.copyBuffer.capacity() < n4)) {
                this.copyBuffer = ByteBuffer.allocateDirect(n4);
            }
            if (this.yuvTextures == null) {
                this.yuvTextures = new int[3];
                for (n3 = 0; n3 < 3; ++n3) {
                    this.yuvTextures[n3] = GlUtil.generateTexture(3553);
                }
            }
            for (n3 = 0; n3 < 3; ++n3) {
                GLES20.glActiveTexture((int)(33984 + n3));
                GLES20.glBindTexture((int)3553, (int)this.yuvTextures[n3]);
                ByteBuffer byteBuffer = nArray[n3] == nArray2[n3] ? byteBufferArray[n3] : this.copyBuffer;
                GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)nArray2[n3], (int)nArray3[n3], (int)0, (int)6409, (int)5121, (Buffer)byteBuffer);
            }
            return this.yuvTextures;
        }

        public int[] uploadFromBuffer(VideoFrame.I420Buffer i420Buffer) {
            int[] nArray = new int[]{i420Buffer.getStrideY(), i420Buffer.getStrideU(), i420Buffer.getStrideV()};
            ByteBuffer[] byteBufferArray = new ByteBuffer[]{i420Buffer.getDataY(), i420Buffer.getDataU(), i420Buffer.getDataV()};
            return this.uploadYuvData(i420Buffer.getWidth(), i420Buffer.getHeight(), nArray, byteBufferArray);
        }

        public int[] getYuvTextures() {
            return this.yuvTextures;
        }

        public void release() {
            this.copyBuffer = null;
            if (this.yuvTextures != null) {
                GLES20.glDeleteTextures((int)3, (int[])this.yuvTextures, (int)0);
                this.yuvTextures = null;
            }
        }
    }
}

