/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import android.opengl.GLES20;
import io.agora.rtc.gl.GlShader;
import io.agora.rtc.gl.GlTextureFrameBuffer;
import io.agora.rtc.gl.GlUtil;
import io.agora.rtc.gl.JavaI420Buffer;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.utils.ThreadUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public class YuvConverter {
    private static final FloatBuffer DEVICE_RECTANGLE = GlUtil.createFloatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
    private static final FloatBuffer TEXTURE_RECTANGLE = GlUtil.createFloatBuffer(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
    private static final String VERTEX_SHADER = "varying vec2 interp_tc;\nattribute vec4 in_pos;\nattribute vec4 in_tc;\n\nuniform mat4 texMatrix;\n\nvoid main() {\n    gl_Position = in_pos;\n    interp_tc = (texMatrix * in_tc).xy;\n}\n";
    private static final String OES_FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 interp_tc;\n\nuniform samplerExternalOES tex;\nuniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc + 1.5 * xUnit).rgb);\n}\n";
    private static final String RGB_FRAGMENT_SHADER = "precision mediump float;\nvarying vec2 interp_tc;\n\nuniform sampler2D tex;\nuniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc + 1.5 * xUnit).rgb);\n}\n";
    private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();
    private final GlTextureFrameBuffer textureFrameBuffer;
    private VideoFrame.TextureBuffer.Type shaderTextureType;
    private GlShader shader;
    private int texMatrixLoc;
    private int xUnitLoc;
    private int coeffsLoc;
    private boolean released = false;
    private long nativeHanlder = 0L;

    public YuvConverter() {
        this.threadChecker.checkIsOnValidThread();
        this.textureFrameBuffer = new GlTextureFrameBuffer(6408);
    }

    public VideoFrame.I420Buffer convert(VideoFrame.TextureBuffer textureBuffer) {
        int n = textureBuffer.getWidth();
        int n2 = textureBuffer.getHeight();
        int n3 = (n + 7) / 8 * 8;
        int n4 = (n2 + 1) / 2;
        int n5 = n3 * (n2 + n4 + 1);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n5);
        this.convert(byteBuffer, n, n2, n3, textureBuffer.getTextureId(), RendererCommon.convertMatrixFromAndroidGraphicsMatrix(textureBuffer.getTransformMatrix()), textureBuffer.getType());
        int n6 = 0 + n3 * n2;
        int n7 = n6 + n3 / 2;
        byteBuffer.position(0);
        byteBuffer.limit(0 + n3 * n2);
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer.position(n6);
        byteBuffer.limit(n6 + n3 * n4);
        ByteBuffer byteBuffer3 = byteBuffer.slice();
        byteBuffer.position(n7);
        byteBuffer.limit(n7 + n3 * n4);
        ByteBuffer byteBuffer4 = byteBuffer.slice();
        return JavaI420Buffer.wrap(n, n2, byteBuffer2, n3, byteBuffer3, n3, byteBuffer4, n3, null);
    }

    @Deprecated
    void convert(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, float[] fArray) {
        this.convert(byteBuffer, n, n2, n3, n4, fArray, VideoFrame.TextureBuffer.Type.OES);
    }

    private void initShader(VideoFrame.TextureBuffer.Type type) {
        String string;
        if (this.shader != null) {
            this.shader.release();
        }
        switch (type) {
            case OES: {
                string = OES_FRAGMENT_SHADER;
                break;
            }
            case RGB: {
                string = RGB_FRAGMENT_SHADER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported texture type.");
            }
        }
        this.shaderTextureType = type;
        this.shader = new GlShader(VERTEX_SHADER, string);
        this.shader.useProgram();
        this.texMatrixLoc = this.shader.getUniformLocation("texMatrix");
        this.xUnitLoc = this.shader.getUniformLocation("xUnit");
        this.coeffsLoc = this.shader.getUniformLocation("coeffs");
        GLES20.glUniform1i((int)this.shader.getUniformLocation("tex"), (int)0);
        GlUtil.checkNoGLES2Error("Initialize fragment shader uniform values.");
        this.shader.setVertexAttribArray("in_pos", 2, DEVICE_RECTANGLE);
        this.shader.setVertexAttribArray("in_tc", 2, TEXTURE_RECTANGLE);
    }

    private void convert(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, float[] fArray, VideoFrame.TextureBuffer.Type type) {
        this.threadChecker.checkIsOnValidThread();
        if (this.released) {
            throw new IllegalStateException("YuvConverter.convert called on released object");
        }
        if (type != this.shaderTextureType) {
            this.initShader(type);
        }
        this.shader.useProgram();
        if (n3 % 8 != 0) {
            throw new IllegalArgumentException("Invalid stride, must be a multiple of 8");
        }
        if (n3 < n) {
            throw new IllegalArgumentException("Invalid stride, must >= width");
        }
        int n5 = (n + 3) / 4;
        int n6 = (n + 7) / 8;
        int n7 = (n2 + 1) / 2;
        int n8 = n2 + n7;
        int n9 = n3 * n8;
        if (byteBuffer.capacity() < n9) {
            throw new IllegalArgumentException("YuvConverter.convert called with too small buffer");
        }
        fArray = RendererCommon.multiplyMatrices(fArray, RendererCommon.verticalFlipMatrix());
        int n10 = n3 / 4;
        int n11 = n8;
        this.textureFrameBuffer.setSize(n10, n11);
        GLES20.glBindFramebuffer((int)36160, (int)this.textureFrameBuffer.getFrameBufferId());
        GlUtil.checkNoGLES2Error("glBindFramebuffer");
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)type.getGlTarget(), (int)n4);
        GLES20.glUniformMatrix4fv((int)this.texMatrixLoc, (int)1, (boolean)false, (float[])fArray, (int)0);
        GLES20.glViewport((int)0, (int)0, (int)n5, (int)n2);
        GLES20.glUniform2f((int)this.xUnitLoc, (float)(fArray[0] / (float)n), (float)(fArray[1] / (float)n));
        GLES20.glUniform4f((int)this.coeffsLoc, (float)0.299f, (float)0.587f, (float)0.114f, (float)0.0f);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glViewport((int)0, (int)n2, (int)n6, (int)n7);
        GLES20.glUniform2f((int)this.xUnitLoc, (float)(2.0f * fArray[0] / (float)n), (float)(2.0f * fArray[1] / (float)n));
        GLES20.glUniform4f((int)this.coeffsLoc, (float)-0.169f, (float)-0.331f, (float)0.499f, (float)0.5f);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glViewport((int)(n3 / 8), (int)n2, (int)n6, (int)n7);
        GLES20.glUniform4f((int)this.coeffsLoc, (float)0.499f, (float)-0.418f, (float)-0.0813f, (float)0.5f);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        int n12 = -1;
        if (this.GPUFBOValid()) {
            if (this.nativeHanlder == 0L) {
                this.nativeHanlder = this.GPUFBOInit(n10, n11);
            }
            n12 = this.GPUFBOReadFrame(this.nativeHanlder, byteBuffer.array(), n10, n11);
        }
        if (n12 != 0) {
            GLES20.glReadPixels((int)0, (int)0, (int)n10, (int)n11, (int)6408, (int)5121, (Buffer)byteBuffer);
        }
        GlUtil.checkNoGLES2Error("YuvConverter.convert");
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glBindTexture((int)type.getGlTarget(), (int)0);
    }

    public void release() {
        this.threadChecker.checkIsOnValidThread();
        this.released = true;
        if (this.shader != null) {
            this.shader.release();
        }
        this.textureFrameBuffer.release();
        if (this.GPUFBOValid()) {
            this.GPUFBORelease(this.nativeHanlder);
        }
    }

    private native long GPUFBOInit(int var1, int var2);

    private native boolean GPUFBOValid();

    private native void GPUFBORelease(long var1);

    private native int GPUFBOReadFrame(long var1, byte[] var3, int var4, int var5);

    private native void GPUFBOResetFirstInit(long var1);
}

