/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;

class Connectivity {
    public static final int Network_UNKNOWN = -1;
    public static final int Network_DISCONNECTED = 0;
    public static final int Network_LAN = 1;
    public static final int Network_WIFI = 2;
    public static final int Network_2G = 3;
    public static final int Network_3G = 4;
    public static final int Network_4G = 5;
    public static final int Network_5G = 6;
    public static final int Network_SubType_WIFI_2P4G = 100;
    public static final int Network_SubType_WIFI_5G = 101;

    Connectivity() {
    }

    public static NetworkInfo getNetworkInfo(Context context) {
        if (context == null) {
            return null;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        return connectivityManager.getActiveNetworkInfo();
    }

    public static boolean isConnected(Context context) {
        NetworkInfo networkInfo = Connectivity.getNetworkInfo(context);
        return networkInfo != null && networkInfo.isConnected();
    }

    public static boolean isConnectedWifi(Context context) {
        NetworkInfo networkInfo = Connectivity.getNetworkInfo(context);
        return networkInfo != null && networkInfo.isConnected() && networkInfo.getType() == 1;
    }

    public static boolean isConnectedMobile(Context context) {
        NetworkInfo networkInfo = Connectivity.getNetworkInfo(context);
        return networkInfo != null && networkInfo.isConnected() && networkInfo.getType() == 0;
    }

    public static boolean isConnectedFast(Context context) {
        NetworkInfo networkInfo = Connectivity.getNetworkInfo(context);
        return networkInfo != null && networkInfo.isConnected() && Connectivity.isConnectionFast(networkInfo.getType(), networkInfo.getSubtype());
    }

    public static boolean isConnectionFast(int n, int n2) {
        if (n == 1) {
            return true;
        }
        if (n == 0) {
            switch (n2) {
                case 7: {
                    return false;
                }
                case 4: {
                    return false;
                }
                case 2: {
                    return false;
                }
                case 5: {
                    return true;
                }
                case 6: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 8: {
                    return true;
                }
                case 10: {
                    return true;
                }
                case 9: {
                    return true;
                }
                case 3: {
                    return true;
                }
                case 14: {
                    return true;
                }
                case 12: {
                    return true;
                }
                case 15: {
                    return true;
                }
                case 11: {
                    return false;
                }
                case 13: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static int getNetworkType(NetworkInfo networkInfo) {
        if (networkInfo == null) {
            return 0;
        }
        if (!networkInfo.isConnected()) {
            return 0;
        }
        int n = networkInfo.getType();
        if (n == 1) {
            return 2;
        }
        if (n != 0) {
            return -1;
        }
        switch (networkInfo.getSubtype()) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return 3;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return 4;
            }
            case 13: {
                return 5;
            }
            case 20: {
                return 6;
            }
        }
        return -1;
    }

    public static int getNetworkType(Context context) {
        NetworkInfo networkInfo = Connectivity.getNetworkInfo(context);
        return Connectivity.getNetworkType(networkInfo);
    }

    public static ArrayList<String> getDnsList() {
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Method method = clazz.getMethod("get", String.class);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : new String[]{"net.dns1", "net.dns2", "net.dns3", "net.dns4"}) {
                String string2 = (String)method.invoke(null, string);
                if (string2 == null || "".equals(string2) || arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
            return arrayList;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

