/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import android.content.Context;
import android.os.Build;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.utils.CameraUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeviceUtils {
    public static final int DEVICE_INFO_UNKNOWN = -1;
    private static final String TAG = "DeviceUtils";
    private static final String[] H264_HW_BLACKLIST = new String[]{"SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4", "P6-C00", "HM 2A", "XT105", "XT109", "XT1060"};
    private static final FileFilter CPU_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            String string = file.getName();
            if (string.startsWith("cpu")) {
                for (int i = 3; i < string.length(); ++i) {
                    if (Character.isDigit(string.charAt(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    };

    public static String buildDeviceId() {
        String string = Build.MANUFACTURER + "/" + Build.MODEL + "/" + Build.PRODUCT + "/" + Build.DEVICE + "/" + Build.VERSION.SDK_INT + "/" + System.getProperty("os.version");
        if (string != null) {
            string = string.toLowerCase();
        }
        String string2 = Build.ID;
        Pattern pattern = Pattern.compile(".*[A-Z][A-M][0-9]$");
        Matcher matcher = pattern.matcher(string2);
        if (Build.BRAND.toLowerCase().equals("samsung") && Build.DEVICE.toLowerCase().startsWith("cs02") && !matcher.find() && Build.VERSION.SDK_INT == 19) {
            string = "yeshen/simulator/" + Build.MODEL + "/" + Build.PRODUCT + "/" + Build.DEVICE + "/" + Build.VERSION.SDK_INT + "/" + System.getProperty("os.version");
        }
        return string;
    }

    public static String getDeviceInfo() {
        String string = Build.MANUFACTURER + "/" + Build.MODEL + "/" + Build.HARDWARE;
        if (string != null) {
            string = string.toLowerCase();
        }
        return string;
    }

    public static String getSystemInfo() {
        String string = "Android/" + Build.VERSION.RELEASE;
        return string;
    }

    public static int selectFrontCamera(Context context) {
        return CameraUtils.selectFrontCamera(context);
    }

    public static int getNumberOfCameras(Context context) {
        return CameraUtils.getNumberOfCameras(context);
    }

    public static int getRecommendedEncoderType() {
        List<String> list = Arrays.asList(H264_HW_BLACKLIST);
        if (list.contains(Build.MODEL)) {
            Logging.w(TAG, "Model: " + Build.MODEL + " has black listed H.264 encoder.");
            return 1;
        }
        if (Build.VERSION.SDK_INT <= 18) {
            return 1;
        }
        return 0;
    }

    public static int getNumberOfCPUCores() {
        int n;
        if (Build.VERSION.SDK_INT <= 10) {
            return 1;
        }
        try {
            n = DeviceUtils.getCoresFromFileInfo("/sys/devices/system/cpu/possible");
            if (n == -1) {
                n = DeviceUtils.getCoresFromFileInfo("/sys/devices/system/cpu/present");
            }
            if (n == -1) {
                n = DeviceUtils.getCoresFromCPUFileList();
            }
        }
        catch (SecurityException securityException) {
            n = -1;
        }
        catch (NullPointerException nullPointerException) {
            n = -1;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCpuName() {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader("/proc/cpuinfo");
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string = bufferedReader.readLine();
            String[] stringArray = string.split(":\\s+", 2);
            for (int i = 0; i < stringArray.length; ++i) {
            }
            if (fileReader != null) {
                fileReader.close();
            }
            String string2 = stringArray[1];
            return string2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logging.e(TAG, "getCpuName failed, no /proc/cpuinfo found in system", fileNotFoundException);
        }
        catch (IOException iOException) {
            Logging.e(TAG, "getCpuName failed,", iOException);
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {
                    Logging.e(TAG, "failed to close proc file", iOException);
                }
            }
        }
        return null;
    }

    public static String getCpuABI() {
        return Build.CPU_ABI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getCoresFromFileInfo(String string) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string2 = bufferedReader.readLine();
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
            int n = DeviceUtils.getCoresFromFileString(string2);
            return n;
        }
        catch (IOException iOException) {
            int n = -1;
            return n;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {
                    Logging.e(TAG, "close file stream", iOException);
                }
            }
        }
    }

    private static int getCoresFromFileString(String string) {
        if (string == null || !string.matches("0-[\\d]+$")) {
            return -1;
        }
        int n = Integer.valueOf(string.substring(2)) + 1;
        return n;
    }

    private static int getCoresFromCPUFileList() {
        return new File("/sys/devices/system/cpu").listFiles(CPU_FILTER).length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCPUMaxFreqKHz() {
        int n;
        block15: {
            n = -1;
            try {
                for (int i = 0; i < DeviceUtils.getNumberOfCPUCores(); ++i) {
                    String string = "/sys/devices/system/cpu/cpu" + i + "/cpufreq/cpuinfo_max_freq";
                    File file = new File(string);
                    if (!file.exists()) continue;
                    byte[] byArray = new byte[128];
                    try (FileInputStream fileInputStream = new FileInputStream(file);){
                        int n2;
                        fileInputStream.read(byArray);
                        for (n2 = 0; Character.isDigit(byArray[n2]) && n2 < byArray.length; ++n2) {
                        }
                        String string2 = new String(byArray, 0, n2);
                        Integer n3 = Integer.parseInt(string2);
                        if (n3 <= n) continue;
                        n = n3;
                        continue;
                    }
                }
                if (n != -1) break block15;
                try (FileInputStream fileInputStream = new FileInputStream("/proc/cpuinfo");){
                    int n4 = DeviceUtils.parseFileForValue("cpu MHz", fileInputStream);
                    if ((n4 *= 1000) > n) {
                        n = n4;
                    }
                }
            }
            catch (IOException iOException) {
                n = -1;
            }
        }
        return n;
    }

    private static int parseFileForValue(String string, FileInputStream fileInputStream) {
        byte[] byArray = new byte[1024];
        try {
            int n = fileInputStream.read(byArray);
            for (int i = 0; i < n; ++i) {
                int n2;
                if (byArray[i] != 10 && i != 0) continue;
                if (byArray[i] == 10) {
                    // empty if block
                }
                for (int j = ++i; j < n && byArray[j] == string.charAt(n2 = j - i); ++j) {
                    if (n2 != string.length() - 1) continue;
                    return DeviceUtils.extractValue(byArray, j);
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    private static int extractValue(byte[] byArray, int n) {
        while (n < byArray.length && byArray[n] != 10) {
            if (Character.isDigit(byArray[n])) {
                int n2 = n++;
                while (n < byArray.length && Character.isDigit(byArray[n])) {
                    ++n;
                }
                String string = new String(byArray, 0, n2, n - n2);
                return Integer.parseInt(string);
            }
            ++n;
        }
        return -1;
    }
}

