/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import io.agora.rtc.internal.CommonUtility;
import io.agora.rtc.internal.Logging;
import java.lang.ref.WeakReference;

public class PowerConnectionReceiver
extends BroadcastReceiver {
    private WeakReference<CommonUtility> mCommonUtility;

    public PowerConnectionReceiver(CommonUtility commonUtility) {
        this.mCommonUtility = new WeakReference<CommonUtility>(commonUtility);
    }

    public void onReceive(Context context, Intent intent) {
        CommonUtility commonUtility = (CommonUtility)this.mCommonUtility.get();
        if (commonUtility == null) {
            Logging.w("rtc engine is not ready");
            return;
        }
        if (intent != null) {
            int n = intent.getIntExtra("level", -1);
            int n2 = intent.getIntExtra("scale", -1);
            if (n2 != 0) {
                float f = (float)n / (float)n2;
                commonUtility.onPowerChange((int)(f * 100.0f));
            }
        }
    }
}

