/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.mediaio;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.ImageFormat;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import android.view.WindowManager;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.mediaio.CameraSource;
import io.agora.rtc.mediaio.CaptureParameters;
import io.agora.rtc.mediaio.IVideoFrameConsumer;
import io.agora.rtc.mediaio.MediaIO;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

@TargetApi(value=21)
public class AgoraBufferedCamera2
extends CameraSource {
    private static final String TAG = AgoraBufferedCamera2.class.getSimpleName();
    private Context mContext;
    private String mCameraId;
    private int cameraOrientation;
    private boolean isCameraFrontFacing;
    private CameraCaptureSession mCaptureSession;
    private CaptureRequest.Builder mPreviewRequestBuilder;
    private CaptureRequest mPreviewRequest;
    private CameraDevice mCameraDevice;
    private CameraCharacteristics mCharacteristics;
    private boolean mFlashSupported;
    private int mState = 0;
    private static final int STATE_PREVIEW = 0;
    private static final int STATE_WAITING_LOCK = 1;
    private static final int STATE_WAITING_PRECAPTURE = 2;
    private static final int STATE_WAITING_NON_PRECAPTURE = 3;
    private HandlerThread mBackgroundThread;
    private Handler mBackgroundHandler;
    private Semaphore mCameraOpenCloseLock = new Semaphore(1);
    private ImageReader mImageReader;
    private byte[] mBufferArrayData;
    private ByteBuffer mByteBufferData;
    private CaptureParameters mParameters;
    private final ImageReader.OnImageAvailableListener mOnImageAvailableListener = new ImageReader.OnImageAvailableListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onImageAvailable(ImageReader imageReader) {
            try (Image image = null;){
                image = imageReader.acquireLatestImage();
                if (image == null) {
                    return;
                }
                if (image.getFormat() != 35 || image.getPlanes().length != 3) {
                    Logging.e(TAG, "Unexpected image format: " + image.getFormat() + "or #planes:" + image.getPlanes().length);
                    return;
                }
                if (imageReader.getWidth() != image.getWidth() || imageReader.getHeight() != image.getHeight()) {
                    throw new IllegalStateException("ImageReader size " + imageReader.getWidth() + "x" + imageReader.getHeight() + " did not match Image size: " + image.getWidth() + "x" + image.getHeight());
                }
                AgoraBufferedCamera2.readImageIntoBuffer(image, AgoraBufferedCamera2.this.mBufferArrayData);
                int n = AgoraBufferedCamera2.this.getFrameOrientation();
                if (AgoraBufferedCamera2.this.consumer != null && ((AgoraBufferedCamera2)AgoraBufferedCamera2.this).mParameters.bufferType == MediaIO.BufferType.BYTE_ARRAY.intValue()) {
                    AgoraBufferedCamera2.this.consumer.consumeByteArrayFrame(AgoraBufferedCamera2.this.mBufferArrayData, ((AgoraBufferedCamera2)AgoraBufferedCamera2.this).mParameters.pixelFormat, image.getWidth(), image.getHeight(), n, System.currentTimeMillis());
                } else if (AgoraBufferedCamera2.this.consumer != null && ((AgoraBufferedCamera2)AgoraBufferedCamera2.this).mParameters.bufferType == MediaIO.BufferType.BYTE_BUFFER.intValue()) {
                    AgoraBufferedCamera2.this.mByteBufferData.rewind();
                    AgoraBufferedCamera2.this.mByteBufferData.put(AgoraBufferedCamera2.this.mBufferArrayData, 0, AgoraBufferedCamera2.this.mBufferArrayData.length);
                    AgoraBufferedCamera2.this.consumer.consumeByteBufferFrame(AgoraBufferedCamera2.this.mByteBufferData, ((AgoraBufferedCamera2)AgoraBufferedCamera2.this).mParameters.pixelFormat, image.getWidth(), image.getHeight(), n, System.currentTimeMillis());
                }
            }
        }
    };
    private final CameraDevice.StateCallback mStateCallback = new CameraDevice.StateCallback(){

        public void onOpened(CameraDevice cameraDevice) {
            AgoraBufferedCamera2.this.mCameraDevice = cameraDevice;
            AgoraBufferedCamera2.this.createCameraPreviewSession();
            AgoraBufferedCamera2.this.mCameraOpenCloseLock.release();
        }

        public void onDisconnected(CameraDevice cameraDevice) {
            cameraDevice.close();
            AgoraBufferedCamera2.this.mCameraDevice = null;
            AgoraBufferedCamera2.this.mCameraOpenCloseLock.release();
        }

        public void onError(CameraDevice cameraDevice, int n) {
            cameraDevice.close();
            AgoraBufferedCamera2.this.mCameraDevice = null;
            AgoraBufferedCamera2.this.mCameraOpenCloseLock.release();
        }
    };
    private CameraCaptureSession.CaptureCallback mCaptureCallback = new CameraCaptureSession.CaptureCallback(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void process(CaptureResult captureResult) {
            switch (AgoraBufferedCamera2.this.mState) {
                case 0: {
                    return;
                }
                case 1: {
                    Integer n;
                    Integer n2 = (Integer)captureResult.get(CaptureResult.CONTROL_AF_STATE);
                    if (n2 != null && (4 == n2 || 5 == n2) && (n = (Integer)captureResult.get(CaptureResult.CONTROL_AE_STATE)) != null && n != 2) return;
                }
                case 2: {
                    Integer n = (Integer)captureResult.get(CaptureResult.CONTROL_AE_STATE);
                    if (n != null && n != 5 && n != 4) return;
                    AgoraBufferedCamera2.this.mState = 3;
                    return;
                }
                case 3: {
                    Integer n = (Integer)captureResult.get(CaptureResult.CONTROL_AE_STATE);
                    if (n == null || n == 5) return;
                    return;
                }
            }
        }

        public void onCaptureProgressed(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, CaptureResult captureResult) {
            this.process(captureResult);
        }

        public void onCaptureCompleted(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, TotalCaptureResult totalCaptureResult) {
            this.process((CaptureResult)totalCaptureResult);
        }
    };

    public AgoraBufferedCamera2(Context context) {
        this.mContext = context;
        this.mParameters = new CaptureParameters();
        this.mParameters.width = 640;
        this.mParameters.height = 480;
        this.mParameters.fps = 15;
        this.mParameters.pixelFormat = MediaIO.PixelFormat.I420.intValue();
        this.mParameters.bufferType = MediaIO.BufferType.BYTE_BUFFER.intValue();
        this.mParameters.captureType = MediaIO.CaptureType.CAMERA.intValue();
        this.mParameters.contentHint = MediaIO.ContentHint.NONE.intValue();
    }

    public AgoraBufferedCamera2(Context context, CaptureParameters captureParameters) {
        this.mContext = context;
        if (captureParameters != null) {
            this.mParameters = new CaptureParameters();
            this.mParameters.width = captureParameters.width;
            this.mParameters.height = captureParameters.height;
            this.mParameters.fps = captureParameters.fps;
            this.mParameters.pixelFormat = captureParameters.pixelFormat;
            this.mParameters.bufferType = captureParameters.bufferType;
            this.mParameters.captureType = captureParameters.captureType;
            this.mParameters.contentHint = captureParameters.contentHint;
        }
    }

    public void useFrontCamera(boolean bl) {
        this.isCameraFrontFacing = bl;
    }

    @Override
    public boolean onInitialize(IVideoFrameConsumer iVideoFrameConsumer) {
        this.consumer = iVideoFrameConsumer;
        this.allocateBuffer(this.mParameters.pixelFormat);
        return true;
    }

    @Override
    public boolean onStart() {
        this.startBackgroundThread();
        this.openCamera(this.mParameters.width, this.mParameters.height);
        return true;
    }

    @Override
    public void onStop() {
        this.doStop();
    }

    @Override
    public void onDispose() {
        this.doStop();
        this.mBufferArrayData = null;
        this.mByteBufferData = null;
    }

    @Override
    public int getBufferType() {
        return this.mParameters.bufferType;
    }

    @Override
    public int getCaptureType() {
        return this.mParameters.captureType;
    }

    @Override
    public int getContentHint() {
        return this.mParameters.contentHint;
    }

    private void allocateBuffer(int n) {
        int n2 = 0;
        if (n == MediaIO.PixelFormat.I420.intValue()) {
            n2 = this.mParameters.width * this.mParameters.height * ImageFormat.getBitsPerPixel((int)35) / 8;
        }
        if (this.mParameters.bufferType == MediaIO.BufferType.BYTE_ARRAY.intValue()) {
            this.mBufferArrayData = new byte[n2];
        } else if (this.mParameters.bufferType == MediaIO.BufferType.BYTE_BUFFER.intValue()) {
            this.mBufferArrayData = new byte[n2];
            this.mByteBufferData = ByteBuffer.allocateDirect(n2);
        }
    }

    private void openCamera(int n, int n2) {
        this.setUpCameraOutputs(n, n2);
        CameraManager cameraManager = (CameraManager)this.mContext.getSystemService("camera");
        try {
            if (!this.mCameraOpenCloseLock.tryAcquire(2500L, TimeUnit.MILLISECONDS)) {
                throw new RuntimeException("Time out waiting to lock camera opening.");
            }
            cameraManager.openCamera(this.mCameraId, this.mStateCallback, this.mBackgroundHandler);
        }
        catch (CameraAccessException cameraAccessException) {
            Log.e((String)TAG, (String)cameraAccessException.toString());
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted while trying to lock camera opening.", interruptedException);
        }
        catch (SecurityException securityException) {
            Log.e((String)TAG, (String)securityException.toString());
        }
    }

    private void doStop() {
        this.closeCamera();
        this.stopBackgroundThread();
    }

    private void createCameraPreviewSession() {
        try {
            this.mPreviewRequestBuilder = this.mCameraDevice.createCaptureRequest(1);
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_MODE, (Object)1);
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_LOCK, (Object)false);
            if (this.mFlashSupported) {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)2);
            }
            this.mPreviewRequestBuilder.addTarget(this.mImageReader.getSurface());
            List<Surface> list = Arrays.asList(this.mImageReader.getSurface());
            this.mCameraDevice.createCaptureSession(list, new CameraCaptureSession.StateCallback(){

                public void onConfigured(CameraCaptureSession cameraCaptureSession) {
                    if (null == AgoraBufferedCamera2.this.mCameraDevice) {
                        return;
                    }
                    AgoraBufferedCamera2.this.mCaptureSession = cameraCaptureSession;
                    try {
                        AgoraBufferedCamera2.this.mPreviewRequest = AgoraBufferedCamera2.this.mPreviewRequestBuilder.build();
                        AgoraBufferedCamera2.this.mCaptureSession.setRepeatingRequest(AgoraBufferedCamera2.this.mPreviewRequest, AgoraBufferedCamera2.this.mCaptureCallback, AgoraBufferedCamera2.this.mBackgroundHandler);
                    }
                    catch (CameraAccessException | IllegalStateException throwable) {
                        throwable.printStackTrace();
                    }
                }

                public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
                    Log.e((String)TAG, (String)"Configure camera failed");
                }
            }, null);
        }
        catch (CameraAccessException cameraAccessException) {
            cameraAccessException.printStackTrace();
        }
    }

    private void setUpCameraOutputs(int n, int n2) {
        CameraManager cameraManager = (CameraManager)this.mContext.getSystemService("camera");
        try {
            String[] stringArray = cameraManager.getCameraIdList();
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                this.mCameraId = string = stringArray[i];
                this.mCharacteristics = cameraManager.getCameraCharacteristics(string);
                this.cameraOrientation = (Integer)this.mCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
                Boolean bl = (Boolean)this.mCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
                boolean bl2 = this.mFlashSupported = bl == null ? false : bl;
                if (!this.isCameraFrontFacing || (Integer)this.mCharacteristics.get(CameraCharacteristics.LENS_FACING) == 0) break;
            }
            this.mImageReader = ImageReader.newInstance((int)this.mParameters.width, (int)this.mParameters.height, (int)this.getAndroidImageFormat(this.mParameters.pixelFormat), (int)2);
            this.mImageReader.setOnImageAvailableListener(this.mOnImageAvailableListener, this.mBackgroundHandler);
        }
        catch (CameraAccessException cameraAccessException) {
            cameraAccessException.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private int getAndroidImageFormat(int n) {
        int n2 = n == MediaIO.PixelFormat.I420.intValue() ? 35 : 0;
        return n2;
    }

    private static Size chooseOptimalSize(Size[] sizeArray, int n, int n2, int n3, int n4, Size size) {
        ArrayList<Size> arrayList = new ArrayList<Size>();
        ArrayList<Size> arrayList2 = new ArrayList<Size>();
        int n5 = size.getWidth();
        int n6 = size.getHeight();
        for (Size size2 : sizeArray) {
            if (size2.getWidth() > n3 || size2.getHeight() > n4 || size2.getHeight() != size2.getWidth() * n6 / n5) continue;
            if (size2.getWidth() >= n && size2.getHeight() >= n2) {
                arrayList.add(size2);
                continue;
            }
            arrayList2.add(size2);
        }
        if (arrayList.size() > 0) {
            return Collections.min(arrayList, new CompareSizesByArea());
        }
        if (arrayList2.size() > 0) {
            return Collections.max(arrayList2, new CompareSizesByArea());
        }
        Log.e((String)TAG, (String)"Couldn't find any suitable preview size");
        return sizeArray[0];
    }

    private void closeCamera() {
        try {
            this.mCameraOpenCloseLock.acquire();
            if (null != this.mCaptureSession) {
                this.mCaptureSession.close();
                this.mCaptureSession = null;
            }
            if (null != this.mCameraDevice) {
                this.mCameraDevice.close();
                this.mCameraDevice = null;
            }
            if (null != this.mImageReader) {
                this.mImageReader.close();
                this.mImageReader = null;
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted while trying to lock camera closing.", interruptedException);
        }
        finally {
            this.mCameraOpenCloseLock.release();
        }
    }

    private void startBackgroundThread() {
        this.mBackgroundThread = new HandlerThread("CameraBackground");
        this.mBackgroundThread.start();
        this.mBackgroundHandler = new Handler(this.mBackgroundThread.getLooper());
    }

    private void stopBackgroundThread() {
        if (this.mBackgroundThread == null) {
            return;
        }
        this.mBackgroundThread.quitSafely();
        try {
            this.mBackgroundThread.join();
            this.mBackgroundThread = null;
            this.mBackgroundHandler = null;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private static void readImageIntoBuffer(Image image, byte[] byArray) {
        int n = image.getWidth();
        int n2 = image.getHeight();
        Image.Plane[] planeArray = image.getPlanes();
        int n3 = 0;
        for (int i = 0; i < planeArray.length; ++i) {
            int n4;
            int n5;
            ByteBuffer byteBuffer = planeArray[i].getBuffer();
            int n6 = planeArray[i].getRowStride();
            int n7 = planeArray[i].getPixelStride();
            int n8 = i == 0 ? n : n / 2;
            int n9 = n5 = i == 0 ? n2 : n2 / 2;
            if (n7 == 1 && n6 == n8) {
                byteBuffer.get(byArray, n3, n8 * n5);
                n3 += n8 * n5;
                continue;
            }
            byte[] byArray2 = new byte[n6];
            for (n4 = 0; n4 < n5 - 1; ++n4) {
                byteBuffer.get(byArray2, 0, n6);
                for (int j = 0; j < n8; ++j) {
                    byArray[n3++] = byArray2[j * n7];
                }
            }
            byteBuffer.get(byArray2, 0, Math.min(n6, byteBuffer.remaining()));
            for (n4 = 0; n4 < n8; ++n4) {
                byArray[n3++] = byArray2[n4 * n7];
            }
        }
    }

    private int getDeviceOrientation() {
        int n = 0;
        WindowManager windowManager = (WindowManager)this.mContext.getSystemService("window");
        switch (windowManager.getDefaultDisplay().getRotation()) {
            case 1: {
                n = 90;
                break;
            }
            case 2: {
                n = 180;
                break;
            }
            case 3: {
                n = 270;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    private int getFrameOrientation() {
        int n = this.getDeviceOrientation();
        if (!this.isCameraFrontFacing) {
            n = 360 - n;
        }
        return (this.cameraOrientation + n) % 360;
    }

    static class CompareSizesByArea
    implements Comparator<Size> {
        CompareSizesByArea() {
        }

        @Override
        public int compare(Size size, Size size2) {
            return Long.signum((long)size.getWidth() * (long)size.getHeight() - (long)size2.getWidth() * (long)size2.getHeight());
        }
    }
}

