/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.mediaio;

import android.content.Context;
import android.hardware.Camera;
import android.util.Log;
import android.view.WindowManager;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.mediaio.IVideoFrameConsumer;
import io.agora.rtc.mediaio.MediaIO;
import io.agora.rtc.mediaio.TextureSource;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.List;

public class AgoraTextureCamera
extends TextureSource {
    private static final String TAG = AgoraTextureCamera.class.getSimpleName();
    private Context mContext;
    private Camera camera;
    private Camera.CameraInfo info;

    public AgoraTextureCamera(Context context, int n, int n2) {
        super(null, n, n2);
        this.mContext = context;
    }

    public AgoraTextureCamera(Context context, int n, int n2, boolean bl) {
        super(null, n, n2, bl);
        this.mContext = context;
    }

    @Override
    public void onTextureFrameAvailable(int n, float[] fArray, long l) {
        IVideoFrameConsumer iVideoFrameConsumer;
        WeakReference weakReference;
        super.onTextureFrameAvailable(n, fArray, l);
        int n2 = this.getFrameOrientation();
        if (this.info.facing == 1) {
            fArray = RendererCommon.multiplyMatrices(fArray, RendererCommon.horizontalFlipMatrix());
        }
        if ((weakReference = this.mConsumer) != null && (iVideoFrameConsumer = (IVideoFrameConsumer)weakReference.get()) != null) {
            iVideoFrameConsumer.consumeTextureFrame(n, MediaIO.PixelFormat.TEXTURE_OES.intValue(), this.mWidth, this.mHeight, n2, System.currentTimeMillis(), fArray);
        }
    }

    @Override
    public void onTextureFrameAvailable(int n, MediaIO.PixelFormat pixelFormat, float[] fArray, long l) {
        IVideoFrameConsumer iVideoFrameConsumer;
        WeakReference weakReference;
        super.onTextureFrameAvailable(n, pixelFormat, fArray, l);
        int n2 = this.getFrameOrientation();
        if (this.info.facing == 1) {
            fArray = RendererCommon.multiplyMatrices(fArray, RendererCommon.horizontalFlipMatrix());
        }
        if ((weakReference = this.mConsumer) != null && (iVideoFrameConsumer = (IVideoFrameConsumer)weakReference.get()) != null) {
            iVideoFrameConsumer.consumeTextureFrame(n, pixelFormat.intValue(), this.mWidth, this.mHeight, n2, System.currentTimeMillis(), fArray);
        }
    }

    @Override
    protected boolean onCapturerOpened() {
        try {
            this.openCamera();
            this.camera.setPreviewTexture(this.getSurfaceTexture());
            this.camera.startPreview();
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)"initialize: failed to initalize camera device");
            return false;
        }
        return true;
    }

    @Override
    protected boolean onCapturerStarted() {
        this.camera.startPreview();
        return true;
    }

    @Override
    protected void onCapturerStopped() {
        this.camera.stopPreview();
    }

    @Override
    protected void onCapturerClosed() {
        this.releaseCamera();
    }

    private void openCamera() {
        if (this.camera != null) {
            throw new RuntimeException("camera already initialized");
        }
        this.info = new Camera.CameraInfo();
        int n = Camera.getNumberOfCameras();
        for (int i = 0; i < n; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)this.info);
            if (this.info.facing != 1) continue;
            this.camera = Camera.open((int)i);
            break;
        }
        if (this.camera == null) {
            Log.d((String)TAG, (String)"No front-facing camera found; opening default");
            this.camera = Camera.open();
        }
        if (this.camera == null) {
            throw new RuntimeException("Unable to open camera");
        }
        Camera.Parameters parameters = this.camera.getParameters();
        List list = parameters.getSupportedPreviewFpsRange();
        int n2 = ((int[])list.get(list.size() - 1))[0];
        int n3 = ((int[])list.get(list.size() - 1))[1];
        parameters.setPreviewFpsRange(n2, n3);
        parameters.setPreviewSize(this.mWidth, this.mHeight);
        parameters.setRecordingHint(true);
        this.camera.setParameters(parameters);
        Camera.Size size = parameters.getPreviewSize();
        String string = size.width + "x" + size.height;
        Log.i((String)TAG, (String)("Camera config: " + string));
    }

    private int getDeviceOrientation() {
        int n = 0;
        WindowManager windowManager = (WindowManager)this.mContext.getSystemService("window");
        switch (windowManager.getDefaultDisplay().getRotation()) {
            case 1: {
                n = 90;
                break;
            }
            case 2: {
                n = 180;
                break;
            }
            case 3: {
                n = 270;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    private int getFrameOrientation() {
        int n = this.getDeviceOrientation();
        if (this.info.facing == 0) {
            n = 360 - n;
        }
        return (this.info.orientation + n) % 360;
    }

    private void releaseCamera() {
        if (this.camera != null) {
            this.camera.stopPreview();
            try {
                this.camera.setPreviewTexture(null);
            }
            catch (Exception exception) {
                Log.e((String)TAG, (String)"failed to set Preview Texture");
            }
            this.camera.release();
            this.camera = null;
            Log.d((String)TAG, (String)"releaseCamera -- done");
        }
    }
}

