/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.mediaio;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.util.Log;
import android.view.TextureView;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.mediaio.BaseVideoRenderer;
import io.agora.rtc.mediaio.IVideoSink;
import io.agora.rtc.mediaio.MediaIO;
import io.agora.rtc.utils.ThreadUtils;
import java.nio.ByteBuffer;

public class AgoraTextureView
extends TextureView
implements IVideoSink,
TextureView.SurfaceTextureListener {
    private static final String TAG = TextureView.class.getSimpleName();
    private BaseVideoRenderer mRender = new BaseVideoRenderer(TAG);
    private EglBase.Context mEglContext;
    private int[] mConfigAttributes;
    private RendererCommon.GlDrawer mDrawer;

    public AgoraTextureView(Context context) {
        super(context);
        this.mRender.setRenderView(this, this);
    }

    public AgoraTextureView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mRender.setRenderView(this, this);
    }

    public void init(EglBase.Context context) {
        this.mEglContext = context;
    }

    public void init(EglBase.Context context, int[] nArray, RendererCommon.GlDrawer glDrawer) {
        this.mEglContext = context;
        this.mConfigAttributes = nArray;
        this.mDrawer = glDrawer;
    }

    @Override
    public long getEGLContextHandle() {
        return this.mRender.getEGLContextHandle();
    }

    public void setBufferType(MediaIO.BufferType bufferType) {
        this.mRender.setBufferType(bufferType);
    }

    public void setPixelFormat(MediaIO.PixelFormat pixelFormat) {
        this.mRender.setPixelFormat(pixelFormat);
    }

    public void setMirror(boolean bl) {
        this.mRender.getEglRender().setMirror(bl);
    }

    @Override
    public boolean onInitialize() {
        if (this.mConfigAttributes != null && this.mDrawer != null) {
            this.mRender.init(this.mEglContext, this.mConfigAttributes, this.mDrawer);
        } else {
            this.mRender.init(this.mEglContext);
        }
        return true;
    }

    @Override
    public boolean onStart() {
        return this.mRender.start();
    }

    @Override
    public void onStop() {
        this.mRender.stop();
    }

    @Override
    public void onDispose() {
        this.mRender.release();
    }

    @Override
    public void consumeTextureFrame(int n, int n2, int n3, int n4, int n5, long l, float[] fArray) {
        this.mRender.consume(n, n2, n3, n4, n5, l, fArray);
    }

    @Override
    public void consumeByteBufferFrame(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, long l) {
        this.mRender.consume(byteBuffer, n, n2, n3, n4, l);
    }

    @Override
    public void consumeByteArrayFrame(byte[] byArray, int n, int n2, int n3, int n4, long l) {
        this.mRender.consume(byArray, n, n2, n3, n4, l);
    }

    @Override
    public int getBufferType() {
        int n = this.mRender.getBufferType();
        if (n == -1) {
            throw new IllegalArgumentException("Buffer type is not set");
        }
        return n;
    }

    @Override
    public int getPixelFormat() {
        int n = this.mRender.getPixelFormat();
        if (n == -1) {
            throw new IllegalArgumentException("Pixel format is not set");
        }
        return n;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        Log.e((String)TAG, (String)("onSurfaceTextureSizeChanged: width- " + n + ", height: " + n2));
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        ThreadUtils.checkIsOnMainThread();
        this.mRender.getEglRender().setLayoutAspectRatio((float)(n3 - n) / (float)(n4 - n2));
    }
}

