/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.mediaio;

import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.EglRenderer;
import io.agora.rtc.gl.GlRectDrawer;
import io.agora.rtc.gl.JavaI420Buffer;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.gl.RgbaBuffer;
import io.agora.rtc.gl.TextureBufferImpl;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.mediaio.MediaIO;
import io.agora.rtc.utils.ThreadUtils;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;

public class BaseVideoRenderer
implements SurfaceHolder.Callback,
TextureView.SurfaceTextureListener {
    private static final String TAG = BaseVideoRenderer.class.getSimpleName();
    private static final String ERROR_EGL = "Only one egl surface allowed";
    private final EglRenderer eglRenderer;
    private int mBufferType = -1;
    private int mPixelFormat = -1;
    private SurfaceView mSurfaceView;
    private TextureView mTextureView;
    private Surface mSurface;
    private SurfaceTexture mSurfaceTexture;
    private SurfaceHolder.Callback mSurfaceViewListener;
    private TextureView.SurfaceTextureListener mSurfaceTextureListener;
    private boolean mHasEglSurface = false;
    private boolean mStarted = false;

    public BaseVideoRenderer(String string) {
        this.eglRenderer = new EglRenderer(string);
    }

    public EglRenderer getEglRender() {
        return this.eglRenderer;
    }

    public long getEGLContextHandle() {
        return this.eglRenderer.getEglContext().getNativeEglContext();
    }

    public void init(EglBase.Context context) {
        this.init(context, EglBase.CONFIG_PLAIN, new GlRectDrawer());
    }

    public void init(EglBase.Context context, int[] nArray, RendererCommon.GlDrawer glDrawer) {
        this.eglRenderer.init(context, nArray, glDrawer);
    }

    public void setRenderView(SurfaceView surfaceView, SurfaceHolder.Callback callback) {
        ThreadUtils.checkIsOnMainThread();
        if (this.mHasEglSurface) {
            throw new IllegalStateException(ERROR_EGL);
        }
        this.mSurfaceView = surfaceView;
        this.mSurfaceViewListener = callback;
        this.mSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    public void setRenderView(TextureView textureView, TextureView.SurfaceTextureListener surfaceTextureListener) {
        ThreadUtils.checkIsOnMainThread();
        if (this.mHasEglSurface) {
            throw new IllegalStateException(ERROR_EGL);
        }
        this.mTextureView = textureView;
        this.mSurfaceTextureListener = surfaceTextureListener;
        this.mTextureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
    }

    public void setRenderSurface(Surface surface) {
        ThreadUtils.checkIsOnMainThread();
        if (this.mHasEglSurface) {
            throw new IllegalStateException(ERROR_EGL);
        }
        this.mSurface = surface;
        this.eglRenderer.createEglSurface(surface);
        this.mHasEglSurface = true;
    }

    public void setRenderSurface(SurfaceTexture surfaceTexture) {
        ThreadUtils.checkIsOnMainThread();
        if (this.mHasEglSurface) {
            throw new IllegalStateException(ERROR_EGL);
        }
        this.mSurfaceTexture = surfaceTexture;
        this.eglRenderer.createEglSurface(surfaceTexture);
        this.mHasEglSurface = true;
    }

    public void setBufferType(MediaIO.BufferType bufferType) {
        this.mBufferType = bufferType.intValue();
    }

    public void setPixelFormat(MediaIO.PixelFormat pixelFormat) {
        this.mPixelFormat = pixelFormat.intValue();
    }

    public void release() {
        this.eglRenderer.release();
    }

    public boolean start() {
        this.mStarted = true;
        return true;
    }

    public void stop() {
        this.mStarted = false;
    }

    public void consume(int n, int n2, int n3, int n4, int n5, long l, float[] fArray) {
        VideoFrame.TextureBuffer.Type type;
        if (!this.mStarted) {
            return;
        }
        if (n2 == 11) {
            type = VideoFrame.TextureBuffer.Type.OES;
        } else if (n2 == 10) {
            type = VideoFrame.TextureBuffer.Type.RGB;
        } else {
            return;
        }
        this.rendTextureFrame(n, type, n3, n4, n5, l, fArray);
    }

    public void consume(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, long l) {
        if (!this.mStarted) {
            return;
        }
        if (n == 1) {
            this.rendI420Frame(byteBuffer, n, n2, n3, n4, l);
        } else if (n == 4) {
            this.rendRGBAFrame(byteBuffer, n, n2, n3, n4, l);
        }
    }

    public void consume(byte[] byArray, int n, int n2, int n3, int n4, long l) {
        if (!this.mStarted) {
            return;
        }
        if (n == 1) {
            this.rendI420Frame(byArray, n, n2, n3, n4, l);
        } else if (n == 4) {
            this.rendRGBAFrame(byArray, n, n2, n3, n4, l);
        }
    }

    public int getBufferType() {
        if (this.mBufferType == -1) {
            throw new IllegalArgumentException("Buffer type is not set");
        }
        return this.mBufferType;
    }

    public int getPixelFormat() {
        if (this.mPixelFormat == -1) {
            throw new IllegalArgumentException("Pixel format is not set");
        }
        return this.mPixelFormat;
    }

    private void rendTextureFrame(int n, VideoFrame.TextureBuffer.Type type, int n2, int n3, int n4, long l, float[] fArray) {
        Matrix matrix = RendererCommon.convertMatrixToAndroidGraphicsMatrix(fArray);
        TextureBufferImpl textureBufferImpl = new TextureBufferImpl(this.eglRenderer.getEglContext(), n2, n3, type, n, matrix, null, null, new Runnable(){

            @Override
            public void run() {
            }
        });
        VideoFrame videoFrame = new VideoFrame(textureBufferImpl, n4, l);
        this.eglRenderer.renderFrame(videoFrame);
        videoFrame.release();
    }

    private void rendI420Frame(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, long l) {
        if (byteBuffer == null) {
            return;
        }
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray, 0, byArray.length);
        JavaI420Buffer javaI420Buffer = JavaI420Buffer.createYUV(byArray, n2, n3);
        if (javaI420Buffer == null) {
            return;
        }
        VideoFrame videoFrame = new VideoFrame(javaI420Buffer, n4, l);
        this.eglRenderer.renderFrame(videoFrame);
        videoFrame.release();
    }

    private void rendI420Frame(byte[] byArray, int n, int n2, int n3, int n4, long l) {
        if (byArray == null || byArray.length == 0) {
            return;
        }
        JavaI420Buffer javaI420Buffer = JavaI420Buffer.createYUV(byArray, n2, n3);
        if (javaI420Buffer == null) {
            return;
        }
        VideoFrame videoFrame = new VideoFrame(javaI420Buffer, n4, l);
        this.eglRenderer.renderFrame(videoFrame);
        videoFrame.release();
    }

    private void rendRGBAFrame(final ByteBuffer byteBuffer, int n, int n2, int n3, int n4, long l) {
        if (byteBuffer == null) {
            return;
        }
        RgbaBuffer rgbaBuffer = new RgbaBuffer(byteBuffer, n2, n3, new Runnable(){

            @Override
            public void run() {
                BaseVideoRenderer.this.releaseBuffer(byteBuffer);
            }
        });
        VideoFrame videoFrame = new VideoFrame(rgbaBuffer, n4, l);
        this.eglRenderer.renderFrame(videoFrame);
        videoFrame.release();
    }

    private void rendRGBAFrame(byte[] byArray, int n, int n2, int n3, int n4, long l) {
        if (byArray == null || byArray.length == 0) {
            return;
        }
        final ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        RgbaBuffer rgbaBuffer = new RgbaBuffer(byteBuffer, n2, n3, new Runnable(){

            @Override
            public void run() {
                BaseVideoRenderer.this.releaseBuffer(byteBuffer);
            }
        });
        VideoFrame videoFrame = new VideoFrame(rgbaBuffer, n4, l);
        this.eglRenderer.renderFrame(videoFrame);
        videoFrame.release();
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        ThreadUtils.checkIsOnMainThread();
        this.eglRenderer.createEglSurface(surfaceHolder.getSurface());
        this.mHasEglSurface = true;
        if (this.mSurfaceViewListener != null) {
            this.mSurfaceViewListener.surfaceCreated(surfaceHolder);
        }
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        ThreadUtils.checkIsOnMainThread();
        Log.e((String)TAG, (String)("surfaceChanged: format: " + n + " size: " + n2 + "x" + n3));
        if (this.mSurfaceViewListener != null) {
            this.mSurfaceViewListener.surfaceChanged(surfaceHolder, n, n2, n3);
        }
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        ThreadUtils.checkIsOnMainThread();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        this.eglRenderer.releaseEglSurface(new Runnable(){

            @Override
            public void run() {
                countDownLatch.countDown();
            }
        });
        ThreadUtils.awaitUninterruptibly(countDownLatch);
        if (this.mSurfaceViewListener != null) {
            this.mSurfaceViewListener.surfaceDestroyed(surfaceHolder);
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        ThreadUtils.checkIsOnMainThread();
        this.eglRenderer.createEglSurface(surfaceTexture);
        this.mHasEglSurface = true;
        if (this.mSurfaceTextureListener != null) {
            this.mSurfaceTextureListener.onSurfaceTextureAvailable(surfaceTexture, n, n2);
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        Log.e((String)TAG, (String)("onSurfaceTextureSizeChanged: width- " + n + ", height: " + n2));
        if (this.mSurfaceTextureListener != null) {
            this.mSurfaceTextureListener.onSurfaceTextureSizeChanged(surfaceTexture, n, n2);
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        ThreadUtils.checkIsOnMainThread();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        this.eglRenderer.releaseEglSurface(new Runnable(){

            @Override
            public void run() {
                countDownLatch.countDown();
            }
        });
        ThreadUtils.awaitUninterruptibly(countDownLatch);
        if (this.mSurfaceTextureListener != null) {
            this.mSurfaceTextureListener.onSurfaceTextureDestroyed(surfaceTexture);
        }
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        if (this.mSurfaceTextureListener != null) {
            this.mSurfaceTextureListener.onSurfaceTextureUpdated(surfaceTexture);
        }
    }

    private void releaseBuffer(ByteBuffer byteBuffer) {
        byteBuffer = null;
    }
}

