/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.mediaio;

import android.graphics.SurfaceTexture;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.mediaio.IVideoFrameConsumer;
import io.agora.rtc.mediaio.IVideoSource;
import io.agora.rtc.mediaio.MediaIO;
import io.agora.rtc.mediaio.SurfaceTextureHelper;
import java.lang.ref.WeakReference;

public abstract class TextureSource
implements IVideoSource,
SurfaceTextureHelper.OnTextureFrameAvailableListener {
    protected WeakReference<IVideoFrameConsumer> mConsumer;
    protected SurfaceTextureHelper mSurfaceTextureHelper;
    protected int mWidth;
    protected int mHeight;
    protected int mPixelFormat;

    public TextureSource(EglBase.Context context, int n, int n2) {
        this.mWidth = n;
        this.mHeight = n2;
        this.mPixelFormat = 11;
        this.mSurfaceTextureHelper = SurfaceTextureHelper.create("TexCamThread", context);
        this.mSurfaceTextureHelper.getSurfaceTexture().setDefaultBufferSize(n, n2);
        this.mSurfaceTextureHelper.startListening(this);
    }

    public TextureSource(EglBase.Context context, int n, int n2, boolean bl) {
        this.mWidth = n;
        this.mHeight = n2;
        this.mPixelFormat = 11;
        this.mSurfaceTextureHelper = SurfaceTextureHelper.create("TexCamThreadOesTo2D", context, bl, n, n2);
        this.mSurfaceTextureHelper.getSurfaceTexture().setDefaultBufferSize(n, n2);
        this.mSurfaceTextureHelper.startListening(this);
    }

    @Override
    public boolean onInitialize(IVideoFrameConsumer iVideoFrameConsumer) {
        this.mConsumer = new WeakReference<IVideoFrameConsumer>(iVideoFrameConsumer);
        return this.onCapturerOpened();
    }

    @Override
    public boolean onStart() {
        return this.onCapturerStarted();
    }

    @Override
    public void onStop() {
        this.onCapturerStopped();
    }

    @Override
    public void onDispose() {
        this.mConsumer = null;
        this.onCapturerClosed();
    }

    @Override
    public int getBufferType() {
        return 3;
    }

    @Override
    public int getCaptureType() {
        return MediaIO.CaptureType.CAMERA.intValue();
    }

    @Override
    public int getContentHint() {
        return MediaIO.ContentHint.NONE.intValue();
    }

    @Override
    public void onTextureFrameAvailable(int n, float[] fArray, long l) {
        this.mSurfaceTextureHelper.returnTextureFrame();
    }

    @Override
    public void onTextureFrameAvailable(int n, MediaIO.PixelFormat pixelFormat, float[] fArray, long l) {
        this.mSurfaceTextureHelper.returnTextureFrame();
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.mSurfaceTextureHelper.getSurfaceTexture();
    }

    public EglBase.Context getEglContext() {
        return this.mSurfaceTextureHelper.getEglContext();
    }

    public void release() {
        this.mSurfaceTextureHelper.stopListening();
        this.mSurfaceTextureHelper.dispose();
        this.mSurfaceTextureHelper = null;
    }

    protected abstract boolean onCapturerOpened();

    protected abstract boolean onCapturerStarted();

    protected abstract void onCapturerStopped();

    protected abstract void onCapturerClosed();
}

