/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.mediaio;

import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.opengl.GLException;
import android.util.Log;
import io.agora.rtc.mediaio.IVideoFrameConsumer;
import java.nio.ByteBuffer;

public class VideoFrameConsumerImpl
implements IVideoFrameConsumer {
    private long mCaptureHandle;

    public VideoFrameConsumerImpl(long l) {
        this.mCaptureHandle = l;
    }

    @Override
    public void consumeByteBufferFrame(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, long l) {
        if (n4 % 90 != 0) {
            Log.e((String)"IVideoFrameConsumer", (String)"consumeByteArrayFrame rotation is not times of 90, set rotation to 0!");
            n4 = 0;
        }
        this.provideByteBufferFrame(this.mCaptureHandle, byteBuffer, n, n2, n3, n4, l);
    }

    @Override
    public void consumeByteArrayFrame(byte[] byArray, int n, int n2, int n3, int n4, long l) {
        int n5 = -1;
        if (n == 8 || n == 3 || n == 1) {
            int n6 = n2 + 1 >> 1;
            int n7 = n3 + 1 >> 1;
            n5 = n2 * n3 + n6 * n7 * 2;
        } else if (n == 4 || n == 2 || n == 7) {
            n5 = n2 * n3 * 4;
        }
        if (n4 % 90 != 0) {
            Log.e((String)"IVideoFrameConsumer", (String)"consumeByteArrayFrame rotation is not times of 90, set rotation to 0!");
            n4 = 0;
        }
        if (n5 == 0 || n5 > 0 && byArray.length < n5) {
            Log.e((String)"IVideoFrameConsumer", (String)("The size of consumeByteArrayFrame is illegal, format " + n));
        } else {
            this.provideByteArrayFrame(this.mCaptureHandle, byArray, n, n2, n3, n4, l);
        }
    }

    @Override
    public void consumeTextureFrame(int n, int n2, int n3, int n4, int n5, long l, float[] fArray) {
        EGLContext eGLContext = EGL14.eglGetCurrentContext();
        int n6 = EGL14.eglGetError();
        if (n6 != 12288) {
            String string = "eglError: " + n6;
            throw new GLException(n6, string);
        }
        if (n5 % 90 != 0) {
            Log.e((String)"IVideoFrameConsumer", (String)"consumeByteArrayFrame rotation is not times of 90, set rotation to 0!");
            n5 = 0;
        }
        this.provideTextureFrame(this.mCaptureHandle, eGLContext, n, n2, n3, n4, n5, l, fArray);
    }

    public native void provideByteArrayFrame(long var1, byte[] var3, int var4, int var5, int var6, int var7, long var8);

    public native void provideTextureFrame(long var1, Object var3, int var4, int var5, int var6, int var7, int var8, long var9, float[] var11);

    public native void provideByteBufferFrame(long var1, ByteBuffer var3, int var4, int var5, int var6, int var7, long var8);
}

