/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.utils;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.media.Image;
import android.util.Log;
import io.agora.rtc.gl.JavaI420Buffer;
import io.agora.rtc.gl.VideoFrame;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

@TargetApi(value=21)
public class YuvUtils {
    private static final String TAG = YuvUtils.class.getSimpleName();
    public static final int I420 = 35;
    public static final int NV21 = 17;

    public static boolean supportedImageFormat(Image image) {
        int n = image.getFormat();
        switch (n) {
            case 17: 
            case 35: 
            case 842094169: {
                return true;
            }
        }
        return false;
    }

    public static byte[] getImageData(Image image, int n) {
        if (n != 35 && n != 17) {
            throw new IllegalArgumentException("only support COLOR_FormatI420 and COLOR_FormatNV21");
        }
        if (!YuvUtils.supportedImageFormat(image)) {
            throw new RuntimeException("can't convert Image to byte array, format " + image.getFormat());
        }
        Rect rect = image.getCropRect();
        int n2 = image.getFormat();
        int n3 = rect.width();
        int n4 = rect.height();
        Image.Plane[] planeArray = image.getPlanes();
        byte[] byArray = new byte[n3 * n4 * ImageFormat.getBitsPerPixel((int)n2) / 8];
        byte[] byArray2 = new byte[planeArray[0].getRowStride()];
        int n5 = 0;
        int n6 = 1;
        for (int i = 0; i < planeArray.length; ++i) {
            switch (i) {
                case 0: {
                    n5 = 0;
                    n6 = 1;
                    break;
                }
                case 1: {
                    if (n == 35) {
                        n5 = n3 * n4;
                        n6 = 1;
                        break;
                    }
                    if (n != 17) break;
                    n5 = n3 * n4 + 1;
                    n6 = 2;
                    break;
                }
                case 2: {
                    if (n == 35) {
                        n5 = (int)((double)(n3 * n4) * 1.25);
                        n6 = 1;
                        break;
                    }
                    if (n != 17) break;
                    n5 = n3 * n4;
                    n6 = 2;
                }
            }
            ByteBuffer byteBuffer = planeArray[i].getBuffer();
            int n7 = planeArray[i].getRowStride();
            int n8 = planeArray[i].getPixelStride();
            int n9 = i == 0 ? 0 : 1;
            int n10 = n3 >> n9;
            int n11 = n4 >> n9;
            byteBuffer.position(n7 * (rect.top >> n9) + n8 * (rect.left >> n9));
            for (int j = 0; j < n11; ++j) {
                int n12;
                if (n8 == 1 && n6 == 1) {
                    n12 = n10;
                    byteBuffer.get(byArray, n5, n12);
                    n5 += n12;
                } else {
                    n12 = (n10 - 1) * n8 + 1;
                    byteBuffer.get(byArray2, 0, n12);
                    for (int k = 0; k < n10; ++k) {
                        byArray[n5] = byArray2[k * n8];
                        n5 += n6;
                    }
                }
                if (j >= n11 - 1) continue;
                byteBuffer.position(byteBuffer.position() + n7 - n12);
            }
        }
        return byArray;
    }

    public static boolean writeNV21ToFile(byte[] byArray, int n, int n2, String string) {
        YuvImage yuvImage = new YuvImage(byArray, 17, n, n2, null);
        Rect rect = new Rect(0, 0, n, n2);
        try {
            File file = new File(string);
            file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            yuvImage.compressToJpeg(rect, 100, (OutputStream)fileOutputStream);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)iOException.toString());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeRawData(byte[] byArray, String string) {
        if (byArray == null || byArray.length == 0) {
            return;
        }
        try {
            File file = new File(string);
            file.createNewFile();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            bufferedOutputStream.write(byArray);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)iOException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write420ImageToFile(Image image, String string) {
        if (image == null) {
            return;
        }
        byte[] byArray = YuvUtils.yuv420toNV21(image);
        try {
            YuvImage yuvImage = new YuvImage(byArray, 17, image.getWidth(), image.getHeight(), null);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            yuvImage.compressToJpeg(new Rect(0, 0, image.getWidth(), image.getHeight()), 100, (OutputStream)byteArrayOutputStream);
            File file = new File(string);
            file.createNewFile();
            FileOutputStream fileOutputStream = null;
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byteArrayOutputStream.toByteArray());
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)iOException.toString());
        }
    }

    public static byte[] yuv420toNV21(Image image) {
        Rect rect = image.getCropRect();
        int n = image.getFormat();
        int n2 = rect.width();
        int n3 = rect.height();
        Image.Plane[] planeArray = image.getPlanes();
        byte[] byArray = new byte[n2 * n3 * ImageFormat.getBitsPerPixel((int)n) / 8];
        byte[] byArray2 = new byte[planeArray[0].getRowStride()];
        int n4 = 0;
        int n5 = 1;
        for (int i = 0; i < planeArray.length; ++i) {
            switch (i) {
                case 0: {
                    n4 = 0;
                    n5 = 1;
                    break;
                }
                case 1: {
                    n4 = n2 * n3 + 1;
                    n5 = 2;
                    break;
                }
                case 2: {
                    n4 = n2 * n3;
                    n5 = 2;
                }
            }
            ByteBuffer byteBuffer = planeArray[i].getBuffer();
            int n6 = planeArray[i].getRowStride();
            int n7 = planeArray[i].getPixelStride();
            int n8 = i == 0 ? 0 : 1;
            int n9 = n2 >> n8;
            int n10 = n3 >> n8;
            byteBuffer.position(n6 * (rect.top >> n8) + n7 * (rect.left >> n8));
            for (int j = 0; j < n10; ++j) {
                int n11;
                if (n7 == 1 && n5 == 1) {
                    n11 = n9;
                    byteBuffer.get(byArray, n4, n11);
                    n4 += n11;
                } else {
                    n11 = (n9 - 1) * n7 + 1;
                    byteBuffer.get(byArray2, 0, n11);
                    for (int k = 0; k < n9; ++k) {
                        byArray[n4] = byArray2[k * n7];
                        n4 += n5;
                    }
                }
                if (j >= n10 - 1) continue;
                byteBuffer.position(byteBuffer.position() + n6 - n11);
            }
        }
        return byArray;
    }

    public static byte[] yuv420toNV21(byte[] byArray, int n, int n2) {
        JavaI420Buffer javaI420Buffer = JavaI420Buffer.createYUV(byArray, n, n2);
        byte[] byArray2 = YuvUtils.yuv420toNV21(javaI420Buffer, n, n2);
        return byArray2;
    }

    public static byte[] yuv420toNV21(VideoFrame.I420Buffer i420Buffer, int n, int n2) {
        Rect rect = new Rect(0, 0, n, n2);
        int n3 = 35;
        Plane[] planeArray = new Plane[3];
        Plane plane = new Plane(i420Buffer.getDataY(), i420Buffer.getStrideY(), 1);
        Plane plane2 = new Plane(i420Buffer.getDataU(), i420Buffer.getStrideU(), 1);
        Plane plane3 = new Plane(i420Buffer.getDataV(), i420Buffer.getStrideV(), 1);
        planeArray[0] = plane;
        planeArray[1] = plane2;
        planeArray[2] = plane3;
        byte[] byArray = new byte[n * n2 * ImageFormat.getBitsPerPixel((int)n3) / 8];
        byte[] byArray2 = new byte[planeArray[0].getRowStride()];
        int n4 = 0;
        int n5 = 1;
        for (int i = 0; i < planeArray.length; ++i) {
            switch (i) {
                case 0: {
                    n4 = 0;
                    n5 = 1;
                    break;
                }
                case 1: {
                    n4 = n * n2 + 1;
                    n5 = 2;
                    break;
                }
                case 2: {
                    n4 = n * n2;
                    n5 = 2;
                }
            }
            ByteBuffer byteBuffer = planeArray[i].getBuffer();
            int n6 = planeArray[i].getRowStride();
            int n7 = planeArray[i].getPixelStride();
            int n8 = i == 0 ? 0 : 1;
            int n9 = n >> n8;
            int n10 = n2 >> n8;
            byteBuffer.position(n6 * (rect.top >> n8) + n7 * (rect.left >> n8));
            for (int j = 0; j < n10; ++j) {
                int n11;
                if (n7 == 1 && n5 == 1) {
                    n11 = n9;
                    byteBuffer.get(byArray, n4, n11);
                    n4 += n11;
                } else {
                    n11 = (n9 - 1) * n7 + 1;
                    byteBuffer.get(byArray2, 0, n11);
                    for (int k = 0; k < n9; ++k) {
                        byArray[n4] = byArray2[k * n7];
                        n4 += n5;
                    }
                }
                if (j >= n10 - 1) continue;
                byteBuffer.position(byteBuffer.position() + n6 - n11);
            }
        }
        return byArray;
    }

    public static void writeRgbaToFile(Buffer buffer, int n, int n2, String string) {
        try {
            File file = new File(string);
            file.createNewFile();
            FileOutputStream fileOutputStream = null;
            fileOutputStream = new FileOutputStream(file);
            Bitmap bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.copyPixelsFromBuffer(buffer);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 50, (OutputStream)fileOutputStream);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)iOException.toString());
        }
    }

    static class Plane {
        private ByteBuffer buffer;
        private int rowStride;
        private int pixelStride;

        public Plane(ByteBuffer byteBuffer, int n, int n2) {
            this.buffer = byteBuffer;
            this.rowStride = n;
            this.pixelStride = n2;
        }

        public ByteBuffer getBuffer() {
            return this.buffer;
        }

        public int getRowStride() {
            return this.rowStride;
        }

        public int getPixelStride() {
            return this.pixelStride;
        }
    }
}

