/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.hardware.Camera;
import io.agora.rtc.internal.Logging;
import java.util.ArrayList;
import java.util.List;

public class CameraHelper {
    private static final String TAG = "CameraHelper";

    public static boolean checkPermission() {
        try {
            return true;
        }
        catch (Exception exception) {
            Logging.e(TAG, "exception in check permission", exception);
            return false;
        }
    }

    public static Capability createCapability(int n, int n2, Camera.Parameters parameters) {
        List list = parameters.getSupportedPreviewSizes();
        List list2 = parameters.getSupportedPreviewFpsRange();
        if (list.isEmpty() || list2.isEmpty()) {
            Logging.e(TAG, "failed get preview size/fps, parameters = " + parameters.flatten());
            throw new IllegalArgumentException(parameters.flatten());
        }
        Camera.Size size = (Camera.Size)list.get(0);
        for (Camera.Size size2 : list) {
            if (size2.width * size2.height <= size.width * size.height) continue;
            size = size2;
        }
        int n3 = ((int[])list2.get(0))[1] / 1000;
        Logging.d(TAG, "creaet capability for camera " + n + " : width: " + size.width + " , height: " + size.height + " max fps: " + n3);
        return new Capability(n, n2, size.width, size.height, n3);
    }

    public static synchronized List<Capability> getCameraCapability() {
        ArrayList<Capability> arrayList = new ArrayList<Capability>();
        int n = Camera.getNumberOfCameras();
        if (n < 1) {
            throw new RuntimeException("no camera device");
        }
        for (int i = 0; i < n; ++i) {
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            Camera camera = Camera.open((int)i);
            Camera.Parameters parameters = camera.getParameters();
            arrayList.add(CameraHelper.createCapability(i, cameraInfo.facing, parameters));
            camera.release();
            camera = null;
        }
        return arrayList;
    }

    public static class Capability {
        public static final int CAMERA_FACING_FRONT = 1;
        public static final int CAMERA_FACING_BACK = 0;
        public int width;
        public int height;
        public int maxFps;
        public int id;
        public int facing;

        public Capability(int n, int n2, int n3, int n4, int n5) {
            this.id = n;
            this.facing = n2;
            this.width = n3;
            this.height = n4;
            this.maxFps = n5;
        }
    }
}

