/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;

public class CoordinatesTransform {
    public static RectF normalizedFaceRect(Rect rect, int n, boolean bl) {
        Matrix matrix = new Matrix();
        CoordinatesTransform.prepareMatrix(matrix, bl, n);
        RectF rectF = new RectF(rect);
        matrix.mapRect(rectF);
        return rectF;
    }

    private static void prepareMatrix(Matrix matrix, boolean bl, int n) {
        matrix.setScale(bl ? -1.0f : 1.0f, 1.0f);
        matrix.postRotate((float)n);
        matrix.postScale(5.0E-4f, 5.0E-4f);
        matrix.postTranslate(0.5f, 0.5f);
    }

    public static Rect sensorToNormalizedPreview(Rect rect, int n, int n2, Rect rect2) {
        double d = n > n2 ? (double)n / (double)n2 : (double)n2 / (double)n;
        double d2 = (double)rect2.width() / (double)rect2.height();
        int n3 = rect2.width();
        int n4 = rect2.height();
        if (d > d2) {
            n4 = (int)((double)n3 / d);
        } else {
            n3 = (int)((double)n4 * d);
        }
        int n5 = Math.abs(n3 - rect2.width());
        int n6 = Math.abs(n4 - rect2.height());
        RectF rectF = new RectF(rect);
        Matrix matrix = new Matrix();
        matrix.postTranslate((float)(-rect2.left - n5 / 2), (float)(-rect2.top - n6 / 2));
        matrix.postTranslate((float)(-n3 / 2), (float)(-n4 / 2));
        matrix.postScale(2000.0f / (float)n3, 2000.0f / (float)n4);
        matrix.mapRect(rectF);
        Rect rect3 = new Rect();
        rectF.round(rect3);
        return rect3;
    }
}

