/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLDebugHelper;
import android.view.TextureView;
import android.view.View;
import io.agora.rtc.internal.Logging;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL;
import javax.microedition.khronos.opengles.GL10;

public class GLTextureViewWrapper
implements TextureView.SurfaceTextureListener,
View.OnLayoutChangeListener {
    private static final String TAG = "GLTextureViewWrapper";
    private static final boolean LOG_ATTACH_DETACH = false;
    private static final boolean LOG_THREADS = false;
    private static final boolean LOG_PAUSE_RESUME = false;
    private static final boolean LOG_SURFACE = false;
    private static final boolean LOG_RENDERER = false;
    private static final boolean LOG_RENDERER_DRAW_FRAME = false;
    private static final boolean LOG_EGL = false;
    private static final boolean LOG_GL_STATE = false;
    private TextureView mTextureView;
    public static final int RENDERMODE_WHEN_DIRTY = 0;
    public static final int RENDERMODE_CONTINUOUSLY = 1;
    public static final int DEBUG_CHECK_GL_ERROR = 1;
    public static final int DEBUG_LOG_GL_CALLS = 2;
    private static final GLThreadManager sGLThreadManager = new GLThreadManager();
    private final WeakReference<GLTextureViewWrapper> mThisWeakRef = new WeakReference<GLTextureViewWrapper>(this);
    private GLThread mGLThread;
    private Renderer mRenderer;
    private boolean mDetached;
    private EGLConfigChooser mEGLConfigChooser;
    private EGLContextFactory mEGLContextFactory;
    private EGLWindowSurfaceFactory mEGLWindowSurfaceFactory;
    private GLWrapper mGLWrapper;
    private int mDebugFlags;
    private int mEGLContextClientVersion;
    private boolean mPreserveEGLContextOnPause;

    public GLTextureViewWrapper(TextureView textureView) {
        this.mTextureView = textureView;
        this.init();
    }

    public TextureView getTextureView() {
        return this.mTextureView;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mGLThread != null) {
                this.mGLThread.requestExitAndWait();
            }
        }
        finally {
            super.finalize();
        }
    }

    private void init() {
        this.mTextureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
        this.mTextureView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View view) {
                GLTextureViewWrapper.this.attachedToWindow();
            }

            public void onViewDetachedFromWindow(View view) {
                GLTextureViewWrapper.this.detachedFromWindow();
            }
        });
    }

    protected Context getContext() {
        return this.mTextureView.getContext();
    }

    public void setGLWrapper(GLWrapper gLWrapper) {
        this.mGLWrapper = gLWrapper;
    }

    public void setDebugFlags(int n) {
        this.mDebugFlags = n;
    }

    public int getDebugFlags() {
        return this.mDebugFlags;
    }

    public void setPreserveEGLContextOnPause(boolean bl) {
        this.mPreserveEGLContextOnPause = bl;
    }

    public boolean getPreserveEGLContextOnPause() {
        return this.mPreserveEGLContextOnPause;
    }

    public void setRenderer(Renderer renderer) {
        this.checkRenderThreadState();
        if (this.mEGLConfigChooser == null) {
            this.mEGLConfigChooser = new SimpleEGLConfigChooser(true);
        }
        if (this.mEGLContextFactory == null) {
            this.mEGLContextFactory = new DefaultContextFactory();
        }
        if (this.mEGLWindowSurfaceFactory == null) {
            this.mEGLWindowSurfaceFactory = new DefaultWindowSurfaceFactory();
        }
        this.mRenderer = renderer;
        this.mGLThread = new GLThread(this.mThisWeakRef);
        this.mGLThread.start();
        if (this.mTextureView.isAttachedToWindow()) {
            this.surfaceCreated(this.mTextureView.getSurfaceTexture());
            this.surfaceChanged(this.mTextureView.getSurfaceTexture(), 0, this.mTextureView.getWidth(), this.mTextureView.getHeight());
        }
    }

    public void setEGLContextFactory(EGLContextFactory eGLContextFactory) {
        this.checkRenderThreadState();
        this.mEGLContextFactory = eGLContextFactory;
    }

    public void setEGLWindowSurfaceFactory(EGLWindowSurfaceFactory eGLWindowSurfaceFactory) {
        this.checkRenderThreadState();
        this.mEGLWindowSurfaceFactory = eGLWindowSurfaceFactory;
    }

    public void setEGLConfigChooser(EGLConfigChooser eGLConfigChooser) {
        this.checkRenderThreadState();
        this.mEGLConfigChooser = eGLConfigChooser;
    }

    public void setEGLConfigChooser(boolean bl) {
        this.setEGLConfigChooser(new SimpleEGLConfigChooser(bl));
    }

    public void setEGLConfigChooser(int n, int n2, int n3, int n4, int n5, int n6) {
        this.setEGLConfigChooser(new ComponentSizeChooser(n, n2, n3, n4, n5, n6));
    }

    public void setEGLContextClientVersion(int n) {
        this.checkRenderThreadState();
        this.mEGLContextClientVersion = n;
    }

    public void setRenderMode(int n) {
        this.mGLThread.setRenderMode(n);
    }

    public int getRenderMode() {
        return this.mGLThread.getRenderMode();
    }

    public void requestRender() {
        this.mGLThread.requestRender();
    }

    public void surfaceCreated(SurfaceTexture surfaceTexture) {
        this.mGLThread.surfaceCreated();
    }

    public void surfaceDestroyed(SurfaceTexture surfaceTexture) {
        this.mGLThread.surfaceDestroyed();
    }

    public void surfaceChanged(SurfaceTexture surfaceTexture, int n, int n2, int n3) {
        this.mGLThread.onWindowResize(n2, n3);
    }

    public void onPause() {
        this.mGLThread.onPause();
    }

    public void onResume() {
        this.mGLThread.onResume();
    }

    public void queueEvent(Runnable runnable) {
        this.mGLThread.queueEvent(runnable);
    }

    private void attachedToWindow() {
        if (this.mDetached && this.mRenderer != null) {
            int n = 1;
            if (this.mGLThread != null) {
                n = this.mGLThread.getRenderMode();
            }
            this.mGLThread = new GLThread(this.mThisWeakRef);
            if (n != 1) {
                this.mGLThread.setRenderMode(n);
            }
            this.mGLThread.start();
        }
        this.mDetached = false;
    }

    private void detachedFromWindow() {
        if (this.mGLThread != null) {
            this.mGLThread.requestExitAndWait();
        }
        this.mDetached = true;
    }

    public void onLayoutChange(View view, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.surfaceChanged(this.mTextureView.getSurfaceTexture(), 0, n3 - n, n4 - n2);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        this.surfaceCreated(surfaceTexture);
        this.surfaceChanged(surfaceTexture, 0, n, n2);
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        this.surfaceChanged(surfaceTexture, 0, n, n2);
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        this.surfaceDestroyed(surfaceTexture);
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }

    private void checkRenderThreadState() {
        if (this.mGLThread != null) {
            throw new IllegalStateException("setRenderer has already been called for this instance.");
        }
    }

    static /* synthetic */ boolean access$1100(GLTextureViewWrapper gLTextureViewWrapper) {
        return gLTextureViewWrapper.mPreserveEGLContextOnPause;
    }

    static /* synthetic */ Renderer access$1200(GLTextureViewWrapper gLTextureViewWrapper) {
        return gLTextureViewWrapper.mRenderer;
    }

    private static class GLThreadManager {
        private static String TAG = "GLThreadManager";
        private boolean mGLESVersionCheckComplete;
        private int mGLESVersion;
        private boolean mGLESDriverCheckComplete;
        private boolean mMultipleGLESContextsAllowed;
        private boolean mLimitedGLESContexts;
        private static final int kGLES_20 = 131072;
        private static final String kMSM7K_RENDERER_PREFIX = "Q3Dimension MSM7500 ";
        private GLThread mEglOwner;

        private GLThreadManager() {
        }

        public synchronized void threadExiting(GLThread gLThread) {
            gLThread.mExited = true;
            if (this.mEglOwner == gLThread) {
                this.mEglOwner = null;
            }
            this.notifyAll();
        }

        public boolean tryAcquireEglContextLocked(GLThread gLThread) {
            if (this.mEglOwner == gLThread || this.mEglOwner == null) {
                this.mEglOwner = gLThread;
                this.notifyAll();
                return true;
            }
            this.checkGLESVersion();
            if (this.mMultipleGLESContextsAllowed) {
                return true;
            }
            if (this.mEglOwner != null) {
                this.mEglOwner.requestReleaseEglContextLocked();
            }
            return false;
        }

        public void releaseEglContextLocked(GLThread gLThread) {
            if (this.mEglOwner == gLThread) {
                this.mEglOwner = null;
            }
            this.notifyAll();
        }

        public synchronized boolean shouldReleaseEGLContextWhenPausing() {
            return this.mLimitedGLESContexts;
        }

        public synchronized boolean shouldTerminateEGLWhenPausing() {
            this.checkGLESVersion();
            return !this.mMultipleGLESContextsAllowed;
        }

        public synchronized void checkGLDriver(GL10 gL10) {
            if (!this.mGLESDriverCheckComplete) {
                this.checkGLESVersion();
                String string = gL10.glGetString(7937);
                if (this.mGLESVersion < 131072) {
                    this.mMultipleGLESContextsAllowed = !string.startsWith(kMSM7K_RENDERER_PREFIX);
                    this.notifyAll();
                }
                this.mLimitedGLESContexts = !this.mMultipleGLESContextsAllowed;
                this.mGLESDriverCheckComplete = true;
            }
        }

        private void checkGLESVersion() {
            if (!this.mGLESVersionCheckComplete) {
                this.mGLESVersionCheckComplete = true;
            }
        }
    }

    static class LogWriter
    extends Writer {
        private StringBuilder mBuilder = new StringBuilder();

        LogWriter() {
        }

        @Override
        public void close() {
            this.flushBuilder();
        }

        @Override
        public void flush() {
            this.flushBuilder();
        }

        @Override
        public void write(char[] cArray, int n, int n2) {
            for (int i = 0; i < n2; ++i) {
                char c = cArray[n + i];
                if (c == '\n') {
                    this.flushBuilder();
                    continue;
                }
                this.mBuilder.append(c);
            }
        }

        private void flushBuilder() {
            if (this.mBuilder.length() > 0) {
                Logging.d("GLTextureView", this.mBuilder.toString());
                this.mBuilder.delete(0, this.mBuilder.length());
            }
        }
    }

    static class GLThread
    extends Thread {
        private boolean mShouldExit;
        private boolean mExited;
        private boolean mRequestPaused;
        private boolean mPaused;
        private boolean mHasSurface;
        private boolean mSurfaceIsBad;
        private boolean mWaitingForSurface;
        private boolean mHaveEglContext;
        private boolean mHaveEglSurface;
        private boolean mShouldReleaseEglContext;
        private int mWidth = 0;
        private int mHeight = 0;
        private int mRenderMode = 1;
        private boolean mRequestRender = true;
        private boolean mRenderComplete;
        private ArrayList<Runnable> mEventQueue = new ArrayList();
        private boolean mSizeChanged = true;
        private EglHelper mEglHelper;
        private WeakReference<GLTextureViewWrapper> mGLSurfaceViewWeakRef;

        GLThread(WeakReference<GLTextureViewWrapper> weakReference) {
            this.mGLSurfaceViewWeakRef = weakReference;
        }

        @Override
        public void run() {
            this.setName("GLThread " + this.getId());
            try {
                this.guardedRun();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                sGLThreadManager.threadExiting(this);
            }
        }

        private void stopEglSurfaceLocked() {
            if (this.mHaveEglSurface) {
                this.mHaveEglSurface = false;
                this.mEglHelper.destroySurface();
            }
        }

        private void stopEglContextLocked() {
            if (this.mHaveEglContext) {
                this.mEglHelper.finish();
                this.mHaveEglContext = false;
                sGLThreadManager.releaseEglContextLocked(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void guardedRun() throws InterruptedException {
            this.mEglHelper = new EglHelper(this.mGLSurfaceViewWeakRef);
            this.mHaveEglContext = false;
            this.mHaveEglSurface = false;
            try {
                var1_1 = null;
                var2_2 = false;
                var3_3 = false;
                var4_4 = false;
                var5_5 = false;
                var6_6 = false;
                var7_7 = false;
                var8_8 = false;
                var9_9 = false;
                var10_10 = 0;
                var11_11 = 0;
                var12_12 = null;
                while (true) {
                    var13_13 = GLTextureViewWrapper.access$1000();
                    synchronized (var13_13) {
                        while (true) {
                            if (this.mShouldExit) {
                                return;
                            }
                            if (!this.mEventQueue.isEmpty()) {
                                var12_12 = this.mEventQueue.remove(0);
                                break;
                            }
                            var14_16 = false;
                            if (this.mPaused != this.mRequestPaused) {
                                var14_16 = this.mRequestPaused;
                                this.mPaused = this.mRequestPaused;
                                GLTextureViewWrapper.access$1000().notifyAll();
                            }
                            if (this.mShouldReleaseEglContext) {
                                this.stopEglSurfaceLocked();
                                this.stopEglContextLocked();
                                this.mShouldReleaseEglContext = false;
                                var9_9 = true;
                            }
                            if (var5_5) {
                                this.stopEglSurfaceLocked();
                                this.stopEglContextLocked();
                                var5_5 = false;
                            }
                            if (var14_16 && this.mHaveEglSurface) {
                                this.stopEglSurfaceLocked();
                            }
                            if (var14_16 && this.mHaveEglContext) {
                                var15_18 = (GLTextureViewWrapper)this.mGLSurfaceViewWeakRef.get();
                                v0 = var16_20 = var15_18 == null ? false : GLTextureViewWrapper.access$1100(var15_18);
                                if (!var16_20 || GLTextureViewWrapper.access$1000().shouldReleaseEGLContextWhenPausing()) {
                                    this.stopEglContextLocked();
                                }
                            }
                            if (var14_16 && GLTextureViewWrapper.access$1000().shouldTerminateEGLWhenPausing()) {
                                this.mEglHelper.finish();
                            }
                            if (!this.mHasSurface && !this.mWaitingForSurface) {
                                if (this.mHaveEglSurface) {
                                    this.stopEglSurfaceLocked();
                                }
                                this.mWaitingForSurface = true;
                                this.mSurfaceIsBad = false;
                                GLTextureViewWrapper.access$1000().notifyAll();
                            }
                            if (this.mHasSurface && this.mWaitingForSurface) {
                                this.mWaitingForSurface = false;
                                GLTextureViewWrapper.access$1000().notifyAll();
                            }
                            if (var8_8) {
                                var7_7 = false;
                                var8_8 = false;
                                this.mRenderComplete = true;
                                GLTextureViewWrapper.access$1000().notifyAll();
                            }
                            if (this.readyToDraw()) {
                                if (!this.mHaveEglContext) {
                                    if (var9_9) {
                                        var9_9 = false;
                                    } else if (GLTextureViewWrapper.access$1000().tryAcquireEglContextLocked(this)) {
                                        try {
                                            this.mEglHelper.start();
                                        }
                                        catch (RuntimeException var15_19) {
                                            GLTextureViewWrapper.access$1000().releaseEglContextLocked(this);
                                            throw var15_19;
                                        }
                                        this.mHaveEglContext = true;
                                        var2_2 = true;
                                        GLTextureViewWrapper.access$1000().notifyAll();
                                    }
                                }
                                if (this.mHaveEglContext && !this.mHaveEglSurface) {
                                    this.mHaveEglSurface = true;
                                    var3_3 = true;
                                    var4_4 = true;
                                    var6_6 = true;
                                }
                                if (this.mHaveEglSurface) {
                                    if (this.mSizeChanged) {
                                        var6_6 = true;
                                        var10_10 = this.mWidth;
                                        var11_11 = this.mHeight;
                                        var7_7 = true;
                                        var3_3 = true;
                                        this.mSizeChanged = false;
                                    }
                                    this.mRequestRender = false;
                                    GLTextureViewWrapper.access$1000().notifyAll();
                                    break;
                                }
                            }
                            GLTextureViewWrapper.access$1000().wait();
                        }
                        ** if (var12_12 == null) goto lbl100
                    }
lbl-1000:
                    // 1 sources

                    {
                        var12_12.run();
                        var12_12 = null;
                        continue;
                    }
lbl100:
                    // 1 sources

                    if (var3_3) {
                        if (!this.mEglHelper.createSurface()) {
                            var13_13 = GLTextureViewWrapper.access$1000();
                            synchronized (var13_13) {
                                this.mSurfaceIsBad = true;
                                GLTextureViewWrapper.access$1000().notifyAll();
                                continue;
                            }
                        }
                        var3_3 = false;
                    }
                    if (var4_4) {
                        var1_1 = (GL10)this.mEglHelper.createGL();
                        GLTextureViewWrapper.access$1000().checkGLDriver(var1_1);
                        var4_4 = false;
                    }
                    if (var2_2) {
                        var13_13 = (GLTextureViewWrapper)this.mGLSurfaceViewWeakRef.get();
                        if (var13_13 != null) {
                            GLTextureViewWrapper.access$1200((GLTextureViewWrapper)var13_13).onSurfaceCreated(var1_1, this.mEglHelper.mEglConfig);
                        }
                        var2_2 = false;
                    }
                    if (var6_6) {
                        var13_13 = (GLTextureViewWrapper)this.mGLSurfaceViewWeakRef.get();
                        if (var13_13 != null) {
                            GLTextureViewWrapper.access$1200((GLTextureViewWrapper)var13_13).onSurfaceChanged(var1_1, var10_10, var11_11);
                        }
                        var6_6 = false;
                    }
                    if ((var13_13 = (GLTextureViewWrapper)this.mGLSurfaceViewWeakRef.get()) != null) {
                        GLTextureViewWrapper.access$1200((GLTextureViewWrapper)var13_13).onDrawFrame(var1_1);
                    }
                    var13_14 = this.mEglHelper.swap();
                    switch (var13_14) {
                        case 12288: {
                            break;
                        }
                        case 12302: {
                            var5_5 = true;
                            break;
                        }
                        default: {
                            EglHelper.logEglErrorAsWarning("GLThread", "eglSwapBuffers", var13_14);
                            var14_17 = GLTextureViewWrapper.access$1000();
                            synchronized (var14_17) {
                                this.mSurfaceIsBad = true;
                                GLTextureViewWrapper.access$1000().notifyAll();
                                break;
                            }
                        }
                    }
                    if (!var7_7) continue;
                    var8_8 = true;
                }
            }
            finally {
                var14_15 = GLTextureViewWrapper.access$1000();
                synchronized (var14_15) {
                    this.stopEglSurfaceLocked();
                    this.stopEglContextLocked();
                }
            }
        }

        public boolean ableToDraw() {
            return this.mHaveEglContext && this.mHaveEglSurface && this.readyToDraw();
        }

        private boolean readyToDraw() {
            return !this.mPaused && this.mHasSurface && !this.mSurfaceIsBad && this.mWidth > 0 && this.mHeight > 0 && (this.mRequestRender || this.mRenderMode == 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setRenderMode(int n) {
            if (0 > n || n > 1) {
                throw new IllegalArgumentException("renderMode");
            }
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRenderMode = n;
                sGLThreadManager.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRenderMode() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                return this.mRenderMode;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestRender() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestRender = true;
                sGLThreadManager.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void surfaceCreated() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mHasSurface = true;
                sGLThreadManager.notifyAll();
                while (this.mWaitingForSurface && !this.mExited) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void surfaceDestroyed() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mHasSurface = false;
                sGLThreadManager.notifyAll();
                while (!this.mWaitingForSurface && !this.mExited) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPause() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestPaused = true;
                sGLThreadManager.notifyAll();
                while (!this.mExited && !this.mPaused) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResume() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestPaused = false;
                this.mRequestRender = true;
                this.mRenderComplete = false;
                sGLThreadManager.notifyAll();
                while (!this.mExited && this.mPaused && !this.mRenderComplete) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWindowResize(int n, int n2) {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mWidth = n;
                this.mHeight = n2;
                this.mSizeChanged = true;
                this.mRequestRender = true;
                this.mRenderComplete = false;
                sGLThreadManager.notifyAll();
                while (!this.mExited && !this.mPaused && !this.mRenderComplete && this.ableToDraw()) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestExitAndWait() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mShouldExit = true;
                sGLThreadManager.notifyAll();
                while (!this.mExited) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        public void requestReleaseEglContextLocked() {
            this.mShouldReleaseEglContext = true;
            sGLThreadManager.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueEvent(Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException("r must not be null");
            }
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mEventQueue.add(runnable);
                sGLThreadManager.notifyAll();
            }
        }
    }

    private static class EglHelper {
        private WeakReference<GLTextureViewWrapper> mGLSurfaceViewWeakRef;
        EGL10 mEgl;
        EGLDisplay mEglDisplay;
        EGLSurface mEglSurface;
        EGLConfig mEglConfig;
        EGLContext mEglContext;

        public EglHelper(WeakReference<GLTextureViewWrapper> weakReference) {
            this.mGLSurfaceViewWeakRef = weakReference;
        }

        public void start() {
            this.mEgl = (EGL10)EGLContext.getEGL();
            this.mEglDisplay = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
            if (this.mEglDisplay == EGL10.EGL_NO_DISPLAY) {
                throw new RuntimeException("eglGetDisplay failed");
            }
            int[] nArray = new int[2];
            if (!this.mEgl.eglInitialize(this.mEglDisplay, nArray)) {
                throw new RuntimeException("eglInitialize failed");
            }
            GLTextureViewWrapper gLTextureViewWrapper = (GLTextureViewWrapper)this.mGLSurfaceViewWeakRef.get();
            if (gLTextureViewWrapper == null) {
                this.mEglConfig = null;
                this.mEglContext = null;
            } else {
                this.mEglConfig = gLTextureViewWrapper.mEGLConfigChooser.chooseConfig(this.mEgl, this.mEglDisplay);
                this.mEglContext = gLTextureViewWrapper.mEGLContextFactory.createContext(this.mEgl, this.mEglDisplay, this.mEglConfig);
            }
            if (this.mEglContext == null || this.mEglContext == EGL10.EGL_NO_CONTEXT) {
                this.mEglContext = null;
                this.throwEglException("createContext");
            }
            this.mEglSurface = null;
        }

        public boolean createSurface() {
            if (this.mEgl == null) {
                throw new RuntimeException("egl not initialized");
            }
            if (this.mEglDisplay == null) {
                throw new RuntimeException("eglDisplay not initialized");
            }
            if (this.mEglConfig == null) {
                throw new RuntimeException("mEglConfig not initialized");
            }
            this.destroySurfaceImp();
            GLTextureViewWrapper gLTextureViewWrapper = (GLTextureViewWrapper)this.mGLSurfaceViewWeakRef.get();
            if (gLTextureViewWrapper.getTextureView().getSurfaceTexture() == null) {
                Logging.e("EglHelper", "createWindowSurface but  wrapper's textureview texture is null");
                return false;
            }
            this.mEglSurface = gLTextureViewWrapper != null ? gLTextureViewWrapper.mEGLWindowSurfaceFactory.createWindowSurface(this.mEgl, this.mEglDisplay, this.mEglConfig, gLTextureViewWrapper.getTextureView().getSurfaceTexture()) : null;
            if (this.mEglSurface == null || this.mEglSurface == EGL10.EGL_NO_SURFACE) {
                int n = this.mEgl.eglGetError();
                if (n == 12299) {
                    Logging.e("EglHelper", "createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
                }
                return false;
            }
            if (!this.mEgl.eglMakeCurrent(this.mEglDisplay, this.mEglSurface, this.mEglSurface, this.mEglContext)) {
                EglHelper.logEglErrorAsWarning("EGLHelper", "eglMakeCurrent", this.mEgl.eglGetError());
                return false;
            }
            return true;
        }

        GL createGL() {
            GL gL = this.mEglContext.getGL();
            GLTextureViewWrapper gLTextureViewWrapper = (GLTextureViewWrapper)this.mGLSurfaceViewWeakRef.get();
            if (gLTextureViewWrapper != null) {
                if (gLTextureViewWrapper.mGLWrapper != null) {
                    gL = gLTextureViewWrapper.mGLWrapper.wrap(gL);
                }
                if ((gLTextureViewWrapper.mDebugFlags & 3) != 0) {
                    int n = 0;
                    LogWriter logWriter = null;
                    if ((gLTextureViewWrapper.mDebugFlags & 1) != 0) {
                        n |= 1;
                    }
                    if ((gLTextureViewWrapper.mDebugFlags & 2) != 0) {
                        logWriter = new LogWriter();
                    }
                    gL = GLDebugHelper.wrap((GL)gL, (int)n, (Writer)logWriter);
                }
            }
            return gL;
        }

        public int swap() {
            if (!this.mEgl.eglSwapBuffers(this.mEglDisplay, this.mEglSurface)) {
                return this.mEgl.eglGetError();
            }
            return 12288;
        }

        public void destroySurface() {
            this.destroySurfaceImp();
        }

        private void destroySurfaceImp() {
            if (this.mEglSurface != null && this.mEglSurface != EGL10.EGL_NO_SURFACE) {
                this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                GLTextureViewWrapper gLTextureViewWrapper = (GLTextureViewWrapper)this.mGLSurfaceViewWeakRef.get();
                if (gLTextureViewWrapper != null) {
                    gLTextureViewWrapper.mEGLWindowSurfaceFactory.destroySurface(this.mEgl, this.mEglDisplay, this.mEglSurface);
                }
                this.mEglSurface = null;
            }
        }

        public void finish() {
            if (this.mEglContext != null) {
                GLTextureViewWrapper gLTextureViewWrapper = (GLTextureViewWrapper)this.mGLSurfaceViewWeakRef.get();
                if (gLTextureViewWrapper != null) {
                    gLTextureViewWrapper.mEGLContextFactory.destroyContext(this.mEgl, this.mEglDisplay, this.mEglContext);
                }
                this.mEglContext = null;
            }
            if (this.mEglDisplay != null) {
                this.mEgl.eglTerminate(this.mEglDisplay);
                this.mEglDisplay = null;
            }
        }

        private void throwEglException(String string) {
            EglHelper.throwEglException(string, this.mEgl.eglGetError());
        }

        public static void throwEglException(String string, int n) {
            String string2 = EglHelper.formatEglError(string, n);
            throw new RuntimeException(string2);
        }

        public static void logEglErrorAsWarning(String string, String string2, int n) {
            Logging.w(string, EglHelper.formatEglError(string2, n));
        }

        public static String formatEglError(String string, int n) {
            return string + " failed: " + n;
        }
    }

    private class SimpleEGLConfigChooser
    extends ComponentSizeChooser {
        public SimpleEGLConfigChooser(boolean bl) {
            super(8, 8, 8, 0, bl ? 16 : 0, 0);
        }
    }

    private class ComponentSizeChooser
    extends BaseConfigChooser {
        private int[] mValue;
        protected int mRedSize;
        protected int mGreenSize;
        protected int mBlueSize;
        protected int mAlphaSize;
        protected int mDepthSize;
        protected int mStencilSize;

        public ComponentSizeChooser(int n, int n2, int n3, int n4, int n5, int n6) {
            super(new int[]{12324, n, 12323, n2, 12322, n3, 12321, n4, 12325, n5, 12326, n6, 12344});
            this.mValue = new int[1];
            this.mRedSize = n;
            this.mGreenSize = n2;
            this.mBlueSize = n3;
            this.mAlphaSize = n4;
            this.mDepthSize = n5;
            this.mStencilSize = n6;
        }

        @Override
        public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray) {
            for (EGLConfig eGLConfig : eGLConfigArray) {
                int n = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12325, 0);
                int n2 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12326, 0);
                if (n < this.mDepthSize || n2 < this.mStencilSize) continue;
                int n3 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12324, 0);
                int n4 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12323, 0);
                int n5 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12322, 0);
                int n6 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12321, 0);
                if (n3 != this.mRedSize || n4 != this.mGreenSize || n5 != this.mBlueSize || n6 != this.mAlphaSize) continue;
                return eGLConfig;
            }
            return null;
        }

        private int findConfigAttrib(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n, int n2) {
            if (eGL10.eglGetConfigAttrib(eGLDisplay, eGLConfig, n, this.mValue)) {
                return this.mValue[0];
            }
            return n2;
        }
    }

    private abstract class BaseConfigChooser
    implements EGLConfigChooser {
        protected int[] mConfigSpec;

        public BaseConfigChooser(int[] nArray) {
            this.mConfigSpec = this.filterConfigSpec(nArray);
        }

        @Override
        public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay) {
            int[] nArray = new int[1];
            if (!eGL10.eglChooseConfig(eGLDisplay, this.mConfigSpec, null, 0, nArray)) {
                throw new IllegalArgumentException("eglChooseConfig failed");
            }
            int n = nArray[0];
            if (n <= 0) {
                throw new IllegalArgumentException("No configs match configSpec");
            }
            EGLConfig[] eGLConfigArray = new EGLConfig[n];
            if (!eGL10.eglChooseConfig(eGLDisplay, this.mConfigSpec, eGLConfigArray, n, nArray)) {
                throw new IllegalArgumentException("eglChooseConfig#2 failed");
            }
            EGLConfig eGLConfig = this.chooseConfig(eGL10, eGLDisplay, eGLConfigArray);
            if (eGLConfig == null) {
                throw new IllegalArgumentException("No config chosen");
            }
            return eGLConfig;
        }

        abstract EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2, EGLConfig[] var3);

        private int[] filterConfigSpec(int[] nArray) {
            if (GLTextureViewWrapper.this.mEGLContextClientVersion != 2) {
                return nArray;
            }
            int n = nArray.length;
            int[] nArray2 = new int[n + 2];
            System.arraycopy(nArray, 0, nArray2, 0, n - 1);
            nArray2[n - 1] = 12352;
            nArray2[n] = 4;
            nArray2[n + 1] = 12344;
            return nArray2;
        }
    }

    public static interface EGLConfigChooser {
        public EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2);
    }

    private static class DefaultWindowSurfaceFactory
    implements EGLWindowSurfaceFactory {
        private DefaultWindowSurfaceFactory() {
        }

        @Override
        public EGLSurface createWindowSurface(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig, Object object) {
            EGLSurface eGLSurface = null;
            try {
                eGLSurface = eGL10.eglCreateWindowSurface(eGLDisplay, eGLConfig, object, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(GLTextureViewWrapper.TAG, "eglCreateWindowSurface", illegalArgumentException);
            }
            return eGLSurface;
        }

        @Override
        public void destroySurface(EGL10 eGL10, EGLDisplay eGLDisplay, EGLSurface eGLSurface) {
            eGL10.eglDestroySurface(eGLDisplay, eGLSurface);
        }
    }

    public static interface EGLWindowSurfaceFactory {
        public EGLSurface createWindowSurface(EGL10 var1, EGLDisplay var2, EGLConfig var3, Object var4);

        public void destroySurface(EGL10 var1, EGLDisplay var2, EGLSurface var3);
    }

    private class DefaultContextFactory
    implements EGLContextFactory {
        private int EGL_CONTEXT_CLIENT_VERSION = 12440;

        private DefaultContextFactory() {
        }

        @Override
        public EGLContext createContext(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
            int[] nArray = new int[]{this.EGL_CONTEXT_CLIENT_VERSION, GLTextureViewWrapper.this.mEGLContextClientVersion, 12344};
            return eGL10.eglCreateContext(eGLDisplay, eGLConfig, EGL10.EGL_NO_CONTEXT, (int[])(GLTextureViewWrapper.this.mEGLContextClientVersion != 0 ? nArray : null));
        }

        @Override
        public void destroyContext(EGL10 eGL10, EGLDisplay eGLDisplay, EGLContext eGLContext) {
            if (!eGL10.eglDestroyContext(eGLDisplay, eGLContext)) {
                Logging.e("DefaultContextFactory", "display:" + eGLDisplay + " context: " + eGLContext);
                EglHelper.throwEglException("eglDestroyContex", eGL10.eglGetError());
            }
        }
    }

    public static interface EGLContextFactory {
        public EGLContext createContext(EGL10 var1, EGLDisplay var2, EGLConfig var3);

        public void destroyContext(EGL10 var1, EGLDisplay var2, EGLContext var3);
    }

    public static interface Renderer {
        public void onSurfaceCreated(GL10 var1, EGLConfig var2);

        public void onSurfaceChanged(GL10 var1, int var2, int var3);

        public void onDrawFrame(GL10 var1);

        public void onSurfaceDestroyed(GL10 var1);
    }

    public static interface GLWrapper {
        public GL wrap(GL var1);
    }
}

